/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.topologicalsort;

import java.util.ArrayList;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.neo4j.gds.mem.BitUtil;

class TopologicalSortQueue {
    private final int numThreads;
    private final ArrayList<ConcurrentLinkedQueue<Long>> queues;
    private final long rangeSize;

    TopologicalSortQueue(long nodeCount, int numThreads) {
        this.queues = new ArrayList(numThreads);
        for (int i = 0; i < numThreads; ++i) {
            this.queues.add(new ConcurrentLinkedQueue());
        }
        this.numThreads = numThreads;
        this.rangeSize = BitUtil.ceilDiv((long)nodeCount, (long)numThreads);
    }

    void add(long nodeId) {
        int index = (int)(nodeId / this.rangeSize);
        this.queues.get(index).add(nodeId);
    }

    long peekBy(int threadId) {
        Long nodeId = this.queues.get(threadId).peek();
        if (nodeId == null) {
            if (this.isDone()) {
                this.finish();
            }
            while (nodeId == null) {
                nodeId = this.queues.get(threadId).peek();
            }
        }
        return nodeId;
    }

    void popBy(int threadId) {
        this.queues.get(threadId).poll();
    }

    private boolean isDone() {
        for (int i = 0; i < this.numThreads; ++i) {
            if (this.queues.get(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    private void finish() {
        for (int i = 0; i < this.numThreads; ++i) {
            this.queues.get(i).add(-1L);
        }
    }
}

