/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.topologicalsort;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.gds.core.utils.paged.HugeLongArray;

public class TopologicalSortResult {
    private final HugeLongArray sortedNodes;
    private final AtomicLong addIndex = new AtomicLong(0L);

    TopologicalSortResult(long nodeCount) {
        this.sortedNodes = HugeLongArray.newArray((long)nodeCount);
    }

    public HugeLongArray value() {
        return this.sortedNodes;
    }

    public long size() {
        return this.addIndex.get();
    }

    void addNode(long nodeId) {
        this.sortedNodes.set(this.addIndex.getAndIncrement(), nodeId);
    }
}

