/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.traversal;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.ConcurrencyConfig;
import org.neo4j.gds.config.JobIdConfig;
import org.neo4j.gds.config.RandomSeedConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.config.SourceNodesConfig;
import org.neo4j.gds.core.utils.progress.JobId;
import org.neo4j.gds.traversal.RandomWalkBaseConfig;
import org.neo4j.gds.traversal.RandomWalkStatsConfig;

@Generated(from="RandomWalkStatsConfig", generator="Immutables")
public final class ImmutableRandomWalkStatsConfig
implements RandomWalkStatsConfig {
    private final String usernameOverride;
    private final boolean sudo;
    private final boolean logProgress;
    private final Collection<String> configKeys;
    private final transient Map<String, Object> toMap;
    private final int concurrency;
    private final int minBatchSize;
    private final JobId jobId;
    private final List<String> relationshipTypes;
    private final List<String> nodeLabels;
    private final String relationshipWeightProperty;
    private final transient boolean hasRelationshipWeightProperty;
    private final Long randomSeed;
    private final List<Long> sourceNodes;
    private final int walkLength;
    private final int walksPerNode;
    private final int walkBufferSize;
    private final double inOutFactor;
    private final double returnFactor;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableRandomWalkStatsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
        this.randomSeed = randomSeed.orElse(null);
        this.initShim.sourceNodes(ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    private ImmutableRandomWalkStatsConfig(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, Long randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.relationshipTypes(ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(relationshipTypes, true, false)));
        this.initShim.nodeLabels(ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(nodeLabels, true, false)));
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.randomSeed = randomSeed;
        this.initShim.sourceNodes(ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(sourceNodes, true, false)));
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.usernameOverride = null;
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    private ImmutableRandomWalkStatsConfig(Builder builder) {
        this.usernameOverride = builder.usernameOverride;
        this.relationshipWeightProperty = builder.relationshipWeightProperty;
        this.randomSeed = builder.randomSeed;
        if (builder.sudoIsSet()) {
            this.initShim.sudo(builder.sudo);
        }
        if (builder.logProgressIsSet()) {
            this.initShim.logProgress(builder.logProgress);
        }
        if (builder.configKeys != null) {
            this.initShim.configKeys(builder.configKeys);
        }
        if (builder.concurrencyIsSet()) {
            this.initShim.concurrency(builder.concurrency);
        }
        if (builder.minBatchSizeIsSet()) {
            this.initShim.minBatchSize(builder.minBatchSize);
        }
        if (builder.jobId != null) {
            this.initShim.jobId(builder.jobId);
        }
        if (builder.relationshipTypesIsSet()) {
            this.initShim.relationshipTypes(builder.relationshipTypes == null ? Collections.emptyList() : ImmutableRandomWalkStatsConfig.createUnmodifiableList(true, builder.relationshipTypes));
        }
        if (builder.nodeLabelsIsSet()) {
            this.initShim.nodeLabels(builder.nodeLabels == null ? Collections.emptyList() : ImmutableRandomWalkStatsConfig.createUnmodifiableList(true, builder.nodeLabels));
        }
        if (builder.sourceNodesIsSet()) {
            this.initShim.sourceNodes(builder.sourceNodes == null ? Collections.emptyList() : ImmutableRandomWalkStatsConfig.createUnmodifiableList(true, builder.sourceNodes));
        }
        if (builder.walkLengthIsSet()) {
            this.initShim.walkLength(builder.walkLength);
        }
        if (builder.walksPerNodeIsSet()) {
            this.initShim.walksPerNode(builder.walksPerNode);
        }
        if (builder.walkBufferSizeIsSet()) {
            this.initShim.walkBufferSize(builder.walkBufferSize);
        }
        if (builder.inOutFactorIsSet()) {
            this.initShim.inOutFactor(builder.inOutFactor);
        }
        if (builder.returnFactorIsSet()) {
            this.initShim.returnFactor(builder.returnFactor);
        }
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    private ImmutableRandomWalkStatsConfig(String usernameOverride, boolean sudo, boolean logProgress, Collection<String> configKeys, int concurrency, int minBatchSize, JobId jobId, List<String> relationshipTypes, List<String> nodeLabels, String relationshipWeightProperty, Long randomSeed, List<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        this.usernameOverride = usernameOverride;
        this.initShim.sudo(sudo);
        this.initShim.logProgress(logProgress);
        this.initShim.configKeys(configKeys);
        this.initShim.concurrency(concurrency);
        this.initShim.minBatchSize(minBatchSize);
        this.initShim.jobId(jobId);
        this.initShim.relationshipTypes(relationshipTypes);
        this.initShim.nodeLabels(nodeLabels);
        this.relationshipWeightProperty = relationshipWeightProperty;
        this.randomSeed = randomSeed;
        this.initShim.sourceNodes(sourceNodes);
        this.initShim.walkLength(walkLength);
        this.initShim.walksPerNode(walksPerNode);
        this.initShim.walkBufferSize(walkBufferSize);
        this.initShim.inOutFactor(inOutFactor);
        this.initShim.returnFactor(returnFactor);
        this.sudo = this.initShim.sudo();
        this.logProgress = this.initShim.logProgress();
        this.configKeys = this.initShim.configKeys();
        this.toMap = this.initShim.toMap();
        this.concurrency = this.initShim.concurrency();
        this.minBatchSize = this.initShim.minBatchSize();
        this.jobId = this.initShim.jobId();
        this.relationshipTypes = this.initShim.relationshipTypes();
        this.nodeLabels = this.initShim.nodeLabels();
        this.hasRelationshipWeightProperty = this.initShim.hasRelationshipWeightProperty();
        this.sourceNodes = this.initShim.sourceNodes();
        this.walkLength = this.initShim.walkLength();
        this.walksPerNode = this.initShim.walksPerNode();
        this.walkBufferSize = this.initShim.walkBufferSize();
        this.inOutFactor = this.initShim.inOutFactor();
        this.returnFactor = this.initShim.returnFactor();
        this.initShim = null;
    }

    private boolean sudoInitialize() {
        return RandomWalkStatsConfig.super.sudo();
    }

    private boolean logProgressInitialize() {
        return RandomWalkStatsConfig.super.logProgress();
    }

    private Collection<String> configKeysInitialize() {
        return RandomWalkStatsConfig.super.configKeys();
    }

    private Map<String, Object> toMapInitialize() {
        return RandomWalkStatsConfig.super.toMap();
    }

    private int concurrencyInitialize() {
        return RandomWalkStatsConfig.super.concurrency();
    }

    private int minBatchSizeInitialize() {
        return RandomWalkStatsConfig.super.minBatchSize();
    }

    private JobId jobIdInitialize() {
        return RandomWalkStatsConfig.super.jobId();
    }

    private List<String> relationshipTypesInitialize() {
        return RandomWalkStatsConfig.super.relationshipTypes();
    }

    private List<String> nodeLabelsInitialize() {
        return RandomWalkStatsConfig.super.nodeLabels();
    }

    private boolean hasRelationshipWeightPropertyInitialize() {
        return RandomWalkStatsConfig.super.hasRelationshipWeightProperty();
    }

    private List<Long> sourceNodesInitialize() {
        return RandomWalkStatsConfig.super.sourceNodes();
    }

    private int walkLengthInitialize() {
        return RandomWalkStatsConfig.super.walkLength();
    }

    private int walksPerNodeInitialize() {
        return RandomWalkStatsConfig.super.walksPerNode();
    }

    private int walkBufferSizeInitialize() {
        return RandomWalkStatsConfig.super.walkBufferSize();
    }

    private double inOutFactorInitialize() {
        return RandomWalkStatsConfig.super.inOutFactor();
    }

    private double returnFactorInitialize() {
        return RandomWalkStatsConfig.super.returnFactor();
    }

    public Optional<String> usernameOverride() {
        return Optional.ofNullable(this.usernameOverride);
    }

    public boolean sudo() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sudo() : this.sudo;
    }

    public boolean logProgress() {
        InitShim shim = this.initShim;
        return shim != null ? shim.logProgress() : this.logProgress;
    }

    public Collection<String> configKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.configKeys() : this.configKeys;
    }

    public Map<String, Object> toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    public int concurrency() {
        InitShim shim = this.initShim;
        return shim != null ? shim.concurrency() : this.concurrency;
    }

    public int minBatchSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.minBatchSize() : this.minBatchSize;
    }

    public JobId jobId() {
        InitShim shim = this.initShim;
        return shim != null ? shim.jobId() : this.jobId;
    }

    public List<String> relationshipTypes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.relationshipTypes() : this.relationshipTypes;
    }

    public List<String> nodeLabels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.nodeLabels() : this.nodeLabels;
    }

    public Optional<String> relationshipWeightProperty() {
        return Optional.ofNullable(this.relationshipWeightProperty);
    }

    public boolean hasRelationshipWeightProperty() {
        InitShim shim = this.initShim;
        return shim != null ? shim.hasRelationshipWeightProperty() : this.hasRelationshipWeightProperty;
    }

    public Optional<Long> randomSeed() {
        return Optional.ofNullable(this.randomSeed);
    }

    public List<Long> sourceNodes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.sourceNodes() : this.sourceNodes;
    }

    @Override
    public int walkLength() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkLength() : this.walkLength;
    }

    @Override
    public int walksPerNode() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walksPerNode() : this.walksPerNode;
    }

    @Override
    public int walkBufferSize() {
        InitShim shim = this.initShim;
        return shim != null ? shim.walkBufferSize() : this.walkBufferSize;
    }

    @Override
    public double inOutFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.inOutFactor() : this.inOutFactor;
    }

    @Override
    public double returnFactor() {
        InitShim shim = this.initShim;
        return shim != null ? shim.returnFactor() : this.returnFactor;
    }

    public final ImmutableRandomWalkStatsConfig withUsernameOverride(String value) {
        String newValue = value;
        if (Objects.equals(this.usernameOverride, newValue)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(newValue, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withUsernameOverride(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.usernameOverride, value)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(value, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withSudo(boolean value) {
        if (this.sudo == value) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, value, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withLogProgress(boolean value) {
        if (this.logProgress == value) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, value, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withConfigKeys(Collection<String> value) {
        if (this.configKeys == value) {
            return this;
        }
        Collection<String> newValue = Objects.requireNonNull(value, "configKeys");
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, newValue, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withConcurrency(int value) {
        if (this.concurrency == value) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, value, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withMinBatchSize(int value) {
        if (this.minBatchSize == value) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, value, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withJobId(JobId value) {
        if (this.jobId == value) {
            return this;
        }
        JobId newValue = Objects.requireNonNull(value, "jobId");
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, newValue, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withRelationshipTypes(String ... elements) {
        List<String> newValue = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withRelationshipTypes(Iterable<String> elements) {
        if (this.relationshipTypes == elements) {
            return this;
        }
        List<String> newValue = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(elements, true, false));
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, newValue, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withNodeLabels(String ... elements) {
        List<String> newValue = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(Arrays.asList(elements), true, false));
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withNodeLabels(Iterable<String> elements) {
        if (this.nodeLabels == elements) {
            return this;
        }
        List<String> newValue = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(elements, true, false));
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, newValue, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withRelationshipWeightProperty(String value) {
        String newValue = value;
        if (Objects.equals(this.relationshipWeightProperty, newValue)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, newValue, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withRelationshipWeightProperty(Optional<String> optional) {
        String value = optional.orElse(null);
        if (Objects.equals(this.relationshipWeightProperty, value)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, value, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withRandomSeed(Long value) {
        Long newValue = value;
        if (Objects.equals(this.randomSeed, newValue)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, newValue, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withRandomSeed(Optional<Long> optional) {
        Long value = optional.orElse(null);
        if (Objects.equals(this.randomSeed, value)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, value, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withSourceNodes(long ... elements) {
        ArrayList<Long> wrappedList = new ArrayList<Long>(elements.length);
        for (long element : elements) {
            wrappedList.add(element);
        }
        List<Long> newValue = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, wrappedList);
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, newValue, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withSourceNodes(Iterable<Long> elements) {
        if (this.sourceNodes == elements) {
            return this;
        }
        List<Long> newValue = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(elements, true, false));
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, newValue, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withWalkLength(int value) {
        if (this.walkLength == value) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, value, this.walksPerNode, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withWalksPerNode(int value) {
        if (this.walksPerNode == value) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, value, this.walkBufferSize, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withWalkBufferSize(int value) {
        if (this.walkBufferSize == value) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, value, this.inOutFactor, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withInOutFactor(double value) {
        if (Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, value, this.returnFactor));
    }

    public final ImmutableRandomWalkStatsConfig withReturnFactor(double value) {
        if (Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(value)) {
            return this;
        }
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this.usernameOverride, this.sudo, this.logProgress, this.configKeys, this.concurrency, this.minBatchSize, this.jobId, this.relationshipTypes, this.nodeLabels, this.relationshipWeightProperty, this.randomSeed, this.sourceNodes, this.walkLength, this.walksPerNode, this.walkBufferSize, this.inOutFactor, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableRandomWalkStatsConfig && this.equalTo((ImmutableRandomWalkStatsConfig)another);
    }

    private boolean equalTo(ImmutableRandomWalkStatsConfig another) {
        return Objects.equals(this.usernameOverride, another.usernameOverride) && this.sudo == another.sudo && this.logProgress == another.logProgress && this.concurrency == another.concurrency && this.minBatchSize == another.minBatchSize && this.jobId.equals((Object)another.jobId) && this.relationshipTypes.equals(another.relationshipTypes) && this.nodeLabels.equals(another.nodeLabels) && Objects.equals(this.relationshipWeightProperty, another.relationshipWeightProperty) && this.hasRelationshipWeightProperty == another.hasRelationshipWeightProperty && Objects.equals(this.randomSeed, another.randomSeed) && this.sourceNodes.equals(another.sourceNodes) && this.walkLength == another.walkLength && this.walksPerNode == another.walksPerNode && this.walkBufferSize == another.walkBufferSize && Double.doubleToLongBits(this.inOutFactor) == Double.doubleToLongBits(another.inOutFactor) && Double.doubleToLongBits(this.returnFactor) == Double.doubleToLongBits(another.returnFactor);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.usernameOverride);
        h += (h << 5) + Boolean.hashCode(this.sudo);
        h += (h << 5) + Boolean.hashCode(this.logProgress);
        h += (h << 5) + this.concurrency;
        h += (h << 5) + this.minBatchSize;
        h += (h << 5) + this.jobId.hashCode();
        h += (h << 5) + this.relationshipTypes.hashCode();
        h += (h << 5) + this.nodeLabels.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipWeightProperty);
        h += (h << 5) + Boolean.hashCode(this.hasRelationshipWeightProperty);
        h += (h << 5) + Objects.hashCode(this.randomSeed);
        h += (h << 5) + this.sourceNodes.hashCode();
        h += (h << 5) + this.walkLength;
        h += (h << 5) + this.walksPerNode;
        h += (h << 5) + this.walkBufferSize;
        h += (h << 5) + Double.hashCode(this.inOutFactor);
        h += (h << 5) + Double.hashCode(this.returnFactor);
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("RandomWalkStatsConfig{");
        if (this.usernameOverride != null) {
            builder.append("usernameOverride=").append(this.usernameOverride);
        }
        if (builder.length() > 22) {
            builder.append(", ");
        }
        builder.append("sudo=").append(this.sudo);
        builder.append(", ");
        builder.append("logProgress=").append(this.logProgress);
        builder.append(", ");
        builder.append("concurrency=").append(this.concurrency);
        builder.append(", ");
        builder.append("minBatchSize=").append(this.minBatchSize);
        builder.append(", ");
        builder.append("jobId=").append(this.jobId);
        builder.append(", ");
        builder.append("relationshipTypes=").append(this.relationshipTypes);
        builder.append(", ");
        builder.append("nodeLabels=").append(this.nodeLabels);
        if (this.relationshipWeightProperty != null) {
            builder.append(", ");
            builder.append("relationshipWeightProperty=").append(this.relationshipWeightProperty);
        }
        builder.append(", ");
        builder.append("hasRelationshipWeightProperty=").append(this.hasRelationshipWeightProperty);
        if (this.randomSeed != null) {
            builder.append(", ");
            builder.append("randomSeed=").append(this.randomSeed);
        }
        builder.append(", ");
        builder.append("sourceNodes=").append(this.sourceNodes);
        builder.append(", ");
        builder.append("walkLength=").append(this.walkLength);
        builder.append(", ");
        builder.append("walksPerNode=").append(this.walksPerNode);
        builder.append(", ");
        builder.append("walkBufferSize=").append(this.walkBufferSize);
        builder.append(", ");
        builder.append("inOutFactor=").append(this.inOutFactor);
        builder.append(", ");
        builder.append("returnFactor=").append(this.returnFactor);
        return builder.append("}").toString();
    }

    public static RandomWalkStatsConfig of(int concurrency, int minBatchSize, List<String> relationshipTypes, List<String> nodeLabels, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, List<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        return ImmutableRandomWalkStatsConfig.of(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, sourceNodes, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor);
    }

    public static RandomWalkStatsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, Optional<String> relationshipWeightProperty, Optional<Long> randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, sourceNodes, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor));
    }

    public static RandomWalkStatsConfig of(int concurrency, int minBatchSize, Iterable<String> relationshipTypes, Iterable<String> nodeLabels, String relationshipWeightProperty, Long randomSeed, Iterable<Long> sourceNodes, int walkLength, int walksPerNode, int walkBufferSize, double inOutFactor, double returnFactor) {
        return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(concurrency, minBatchSize, relationshipTypes, nodeLabels, relationshipWeightProperty, randomSeed, sourceNodes, walkLength, walksPerNode, walkBufferSize, inOutFactor, returnFactor));
    }

    private static ImmutableRandomWalkStatsConfig validate(ImmutableRandomWalkStatsConfig instance) {
        instance.validateRelationshipWeightProperty();
        instance.validateConcurrency();
        return instance;
    }

    public static RandomWalkStatsConfig copyOf(RandomWalkStatsConfig instance) {
        if (instance instanceof ImmutableRandomWalkStatsConfig) {
            return (ImmutableRandomWalkStatsConfig)instance;
        }
        return ImmutableRandomWalkStatsConfig.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="RandomWalkStatsConfig", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_SUDO = 1L;
        private static final long OPT_BIT_LOG_PROGRESS = 2L;
        private static final long OPT_BIT_CONCURRENCY = 4L;
        private static final long OPT_BIT_MIN_BATCH_SIZE = 8L;
        private static final long OPT_BIT_RELATIONSHIP_TYPES = 16L;
        private static final long OPT_BIT_NODE_LABELS = 32L;
        private static final long OPT_BIT_SOURCE_NODES = 64L;
        private static final long OPT_BIT_WALK_LENGTH = 128L;
        private static final long OPT_BIT_WALKS_PER_NODE = 256L;
        private static final long OPT_BIT_WALK_BUFFER_SIZE = 512L;
        private static final long OPT_BIT_IN_OUT_FACTOR = 1024L;
        private static final long OPT_BIT_RETURN_FACTOR = 2048L;
        private long optBits;
        private String usernameOverride;
        private boolean sudo;
        private boolean logProgress;
        private Collection<String> configKeys;
        private int concurrency;
        private int minBatchSize;
        private JobId jobId;
        private List<String> relationshipTypes = null;
        private List<String> nodeLabels = null;
        private String relationshipWeightProperty;
        private Long randomSeed;
        private List<Long> sourceNodes = null;
        private int walkLength;
        private int walksPerNode;
        private int walkBufferSize;
        private double inOutFactor;
        private double returnFactor;

        private Builder() {
        }

        public final Builder from(RelationshipWeightConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(JobIdConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(ConcurrencyConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomSeedConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomWalkBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(SourceNodesConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(BaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(AlgoBaseConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        public final Builder from(RandomWalkStatsConfig instance) {
            Objects.requireNonNull(instance, "instance");
            this.from((Object)instance);
            return this;
        }

        private void from(Object object) {
            Optional randomSeedOptional;
            RelationshipWeightConfig instance;
            Optional relationshipWeightPropertyOptional;
            if (object instanceof RelationshipWeightConfig && (relationshipWeightPropertyOptional = (instance = (RelationshipWeightConfig)object).relationshipWeightProperty()).isPresent()) {
                this.relationshipWeightProperty(relationshipWeightPropertyOptional);
            }
            if (object instanceof JobIdConfig) {
                instance = (JobIdConfig)object;
                this.jobId(instance.jobId());
            }
            if (object instanceof ConcurrencyConfig) {
                instance = (ConcurrencyConfig)object;
                this.minBatchSize(instance.minBatchSize());
                this.concurrency(instance.concurrency());
            }
            if (object instanceof RandomSeedConfig && (randomSeedOptional = (instance = (RandomSeedConfig)object).randomSeed()).isPresent()) {
                this.randomSeed(randomSeedOptional);
            }
            if (object instanceof RandomWalkBaseConfig) {
                instance = (RandomWalkBaseConfig)object;
                this.walkLength(instance.walkLength());
                this.walksPerNode(instance.walksPerNode());
                this.walkBufferSize(instance.walkBufferSize());
                this.returnFactor(instance.returnFactor());
                this.inOutFactor(instance.inOutFactor());
            }
            if (object instanceof SourceNodesConfig) {
                instance = (SourceNodesConfig)object;
                this.addAllSourceNodes(instance.sourceNodes());
            }
            if (object instanceof BaseConfig) {
                instance = (BaseConfig)object;
                this.logProgress(instance.logProgress());
                this.sudo(instance.sudo());
                Optional usernameOverrideOptional = instance.usernameOverride();
                if (usernameOverrideOptional.isPresent()) {
                    this.usernameOverride(usernameOverrideOptional);
                }
                this.configKeys(instance.configKeys());
            }
            if (object instanceof AlgoBaseConfig) {
                instance = (AlgoBaseConfig)object;
                this.addAllRelationshipTypes(instance.relationshipTypes());
                this.addAllNodeLabels(instance.nodeLabels());
            }
        }

        public final Builder usernameOverride(String usernameOverride) {
            this.usernameOverride = usernameOverride;
            return this;
        }

        public final Builder usernameOverride(Optional<String> usernameOverride) {
            this.usernameOverride = usernameOverride.orElse(null);
            return this;
        }

        public final Builder sudo(boolean sudo) {
            this.sudo = sudo;
            this.optBits |= 1L;
            return this;
        }

        public final Builder logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.optBits |= 2L;
            return this;
        }

        public final Builder configKeys(Collection<String> configKeys) {
            this.configKeys = Objects.requireNonNull(configKeys, "configKeys");
            return this;
        }

        public final Builder concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.optBits |= 4L;
            return this;
        }

        public final Builder minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.optBits |= 8L;
            return this;
        }

        public final Builder jobId(JobId jobId) {
            this.jobId = Objects.requireNonNull(jobId, "jobId");
            return this;
        }

        public final Builder addRelationshipType(String element) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addRelationshipTypes(String ... elements) {
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder relationshipTypes(Iterable<String> elements) {
            this.relationshipTypes = new ArrayList<String>();
            return this.addAllRelationshipTypes(elements);
        }

        public final Builder addAllRelationshipTypes(Iterable<String> elements) {
            Objects.requireNonNull(elements, "relationshipTypes element");
            if (this.relationshipTypes == null) {
                this.relationshipTypes = new ArrayList<String>();
            }
            for (String element : elements) {
                this.relationshipTypes.add(Objects.requireNonNull(element, "relationshipTypes element"));
            }
            this.optBits |= 0x10L;
            return this;
        }

        public final Builder addNodeLabel(String element) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder addNodeLabels(String ... elements) {
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder nodeLabels(Iterable<String> elements) {
            this.nodeLabels = new ArrayList<String>();
            return this.addAllNodeLabels(elements);
        }

        public final Builder addAllNodeLabels(Iterable<String> elements) {
            Objects.requireNonNull(elements, "nodeLabels element");
            if (this.nodeLabels == null) {
                this.nodeLabels = new ArrayList<String>();
            }
            for (String element : elements) {
                this.nodeLabels.add(Objects.requireNonNull(element, "nodeLabels element"));
            }
            this.optBits |= 0x20L;
            return this;
        }

        public final Builder relationshipWeightProperty(String relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty;
            return this;
        }

        public final Builder relationshipWeightProperty(Optional<String> relationshipWeightProperty) {
            this.relationshipWeightProperty = relationshipWeightProperty.orElse(null);
            return this;
        }

        public final Builder randomSeed(Long randomSeed) {
            this.randomSeed = randomSeed;
            return this;
        }

        public final Builder randomSeed(Optional<Long> randomSeed) {
            this.randomSeed = randomSeed.orElse(null);
            return this;
        }

        public final Builder addSourceNode(long element) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            this.sourceNodes.add(element);
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder addSourceNodes(long ... elements) {
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(element);
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder sourceNodes(Iterable<Long> elements) {
            this.sourceNodes = new ArrayList<Long>();
            return this.addAllSourceNodes(elements);
        }

        public final Builder addAllSourceNodes(Iterable<Long> elements) {
            Objects.requireNonNull(elements, "sourceNodes element");
            if (this.sourceNodes == null) {
                this.sourceNodes = new ArrayList<Long>();
            }
            for (long element : elements) {
                this.sourceNodes.add(Objects.requireNonNull(Long.valueOf(element), "sourceNodes element"));
            }
            this.optBits |= 0x40L;
            return this;
        }

        public final Builder walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.optBits |= 0x80L;
            return this;
        }

        public final Builder walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.optBits |= 0x100L;
            return this;
        }

        public final Builder walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.optBits |= 0x200L;
            return this;
        }

        public final Builder inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.optBits |= 0x400L;
            return this;
        }

        public final Builder returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.optBits |= 0x800L;
            return this;
        }

        public Builder clear() {
            this.optBits = 0L;
            this.usernameOverride = null;
            this.sudo = false;
            this.logProgress = false;
            this.configKeys = null;
            this.concurrency = 0;
            this.minBatchSize = 0;
            this.jobId = null;
            if (this.relationshipTypes != null) {
                this.relationshipTypes.clear();
            }
            if (this.nodeLabels != null) {
                this.nodeLabels.clear();
            }
            this.relationshipWeightProperty = null;
            this.randomSeed = null;
            if (this.sourceNodes != null) {
                this.sourceNodes.clear();
            }
            this.walkLength = 0;
            this.walksPerNode = 0;
            this.walkBufferSize = 0;
            this.inOutFactor = 0.0;
            this.returnFactor = 0.0;
            return this;
        }

        public RandomWalkStatsConfig build() {
            return ImmutableRandomWalkStatsConfig.validate(new ImmutableRandomWalkStatsConfig(this));
        }

        private boolean sudoIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean logProgressIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean concurrencyIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean minBatchSizeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean relationshipTypesIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean nodeLabelsIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean sourceNodesIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean walkLengthIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean walksPerNodeIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private boolean walkBufferSizeIsSet() {
            return (this.optBits & 0x200L) != 0L;
        }

        private boolean inOutFactorIsSet() {
            return (this.optBits & 0x400L) != 0L;
        }

        private boolean returnFactorIsSet() {
            return (this.optBits & 0x800L) != 0L;
        }
    }

    @Generated(from="RandomWalkStatsConfig", generator="Immutables")
    private final class InitShim {
        private byte sudoBuildStage = 0;
        private boolean sudo;
        private byte logProgressBuildStage = 0;
        private boolean logProgress;
        private byte configKeysBuildStage = 0;
        private Collection<String> configKeys;
        private byte toMapBuildStage = 0;
        private Map<String, Object> toMap;
        private byte concurrencyBuildStage = 0;
        private int concurrency;
        private byte minBatchSizeBuildStage = 0;
        private int minBatchSize;
        private byte jobIdBuildStage = 0;
        private JobId jobId;
        private byte relationshipTypesBuildStage = 0;
        private List<String> relationshipTypes;
        private byte nodeLabelsBuildStage = 0;
        private List<String> nodeLabels;
        private byte hasRelationshipWeightPropertyBuildStage = 0;
        private boolean hasRelationshipWeightProperty;
        private byte sourceNodesBuildStage = 0;
        private List<Long> sourceNodes;
        private byte walkLengthBuildStage = 0;
        private int walkLength;
        private byte walksPerNodeBuildStage = 0;
        private int walksPerNode;
        private byte walkBufferSizeBuildStage = 0;
        private int walkBufferSize;
        private byte inOutFactorBuildStage = 0;
        private double inOutFactor;
        private byte returnFactorBuildStage = 0;
        private double returnFactor;

        private InitShim() {
        }

        boolean sudo() {
            if (this.sudoBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sudoBuildStage == 0) {
                this.sudoBuildStage = (byte)-1;
                this.sudo = ImmutableRandomWalkStatsConfig.this.sudoInitialize();
                this.sudoBuildStage = 1;
            }
            return this.sudo;
        }

        void sudo(boolean sudo) {
            this.sudo = sudo;
            this.sudoBuildStage = 1;
        }

        boolean logProgress() {
            if (this.logProgressBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.logProgressBuildStage == 0) {
                this.logProgressBuildStage = (byte)-1;
                this.logProgress = ImmutableRandomWalkStatsConfig.this.logProgressInitialize();
                this.logProgressBuildStage = 1;
            }
            return this.logProgress;
        }

        void logProgress(boolean logProgress) {
            this.logProgress = logProgress;
            this.logProgressBuildStage = 1;
        }

        Collection<String> configKeys() {
            if (this.configKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.configKeysBuildStage == 0) {
                this.configKeysBuildStage = (byte)-1;
                this.configKeys = Objects.requireNonNull(ImmutableRandomWalkStatsConfig.this.configKeysInitialize(), "configKeys");
                this.configKeysBuildStage = 1;
            }
            return this.configKeys;
        }

        void configKeys(Collection<String> configKeys) {
            this.configKeys = configKeys;
            this.configKeysBuildStage = 1;
        }

        Map<String, Object> toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = Objects.requireNonNull(ImmutableRandomWalkStatsConfig.this.toMapInitialize(), "toMap");
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        int concurrency() {
            if (this.concurrencyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.concurrencyBuildStage == 0) {
                this.concurrencyBuildStage = (byte)-1;
                this.concurrency = ImmutableRandomWalkStatsConfig.this.concurrencyInitialize();
                this.concurrencyBuildStage = 1;
            }
            return this.concurrency;
        }

        void concurrency(int concurrency) {
            this.concurrency = concurrency;
            this.concurrencyBuildStage = 1;
        }

        int minBatchSize() {
            if (this.minBatchSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.minBatchSizeBuildStage == 0) {
                this.minBatchSizeBuildStage = (byte)-1;
                this.minBatchSize = ImmutableRandomWalkStatsConfig.this.minBatchSizeInitialize();
                this.minBatchSizeBuildStage = 1;
            }
            return this.minBatchSize;
        }

        void minBatchSize(int minBatchSize) {
            this.minBatchSize = minBatchSize;
            this.minBatchSizeBuildStage = 1;
        }

        JobId jobId() {
            if (this.jobIdBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.jobIdBuildStage == 0) {
                this.jobIdBuildStage = (byte)-1;
                this.jobId = Objects.requireNonNull(ImmutableRandomWalkStatsConfig.this.jobIdInitialize(), "jobId");
                this.jobIdBuildStage = 1;
            }
            return this.jobId;
        }

        void jobId(JobId jobId) {
            this.jobId = jobId;
            this.jobIdBuildStage = 1;
        }

        List<String> relationshipTypes() {
            if (this.relationshipTypesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.relationshipTypesBuildStage == 0) {
                this.relationshipTypesBuildStage = (byte)-1;
                this.relationshipTypes = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(ImmutableRandomWalkStatsConfig.this.relationshipTypesInitialize(), true, false));
                this.relationshipTypesBuildStage = 1;
            }
            return this.relationshipTypes;
        }

        void relationshipTypes(List<String> relationshipTypes) {
            this.relationshipTypes = relationshipTypes;
            this.relationshipTypesBuildStage = 1;
        }

        List<String> nodeLabels() {
            if (this.nodeLabelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.nodeLabelsBuildStage == 0) {
                this.nodeLabelsBuildStage = (byte)-1;
                this.nodeLabels = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(ImmutableRandomWalkStatsConfig.this.nodeLabelsInitialize(), true, false));
                this.nodeLabelsBuildStage = 1;
            }
            return this.nodeLabels;
        }

        void nodeLabels(List<String> nodeLabels) {
            this.nodeLabels = nodeLabels;
            this.nodeLabelsBuildStage = 1;
        }

        boolean hasRelationshipWeightProperty() {
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.hasRelationshipWeightPropertyBuildStage == 0) {
                this.hasRelationshipWeightPropertyBuildStage = (byte)-1;
                this.hasRelationshipWeightProperty = ImmutableRandomWalkStatsConfig.this.hasRelationshipWeightPropertyInitialize();
                this.hasRelationshipWeightPropertyBuildStage = 1;
            }
            return this.hasRelationshipWeightProperty;
        }

        List<Long> sourceNodes() {
            if (this.sourceNodesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.sourceNodesBuildStage == 0) {
                this.sourceNodesBuildStage = (byte)-1;
                this.sourceNodes = ImmutableRandomWalkStatsConfig.createUnmodifiableList(false, ImmutableRandomWalkStatsConfig.createSafeList(ImmutableRandomWalkStatsConfig.this.sourceNodesInitialize(), true, false));
                this.sourceNodesBuildStage = 1;
            }
            return this.sourceNodes;
        }

        void sourceNodes(List<Long> sourceNodes) {
            this.sourceNodes = sourceNodes;
            this.sourceNodesBuildStage = 1;
        }

        int walkLength() {
            if (this.walkLengthBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkLengthBuildStage == 0) {
                this.walkLengthBuildStage = (byte)-1;
                this.walkLength = ImmutableRandomWalkStatsConfig.this.walkLengthInitialize();
                this.walkLengthBuildStage = 1;
            }
            return this.walkLength;
        }

        void walkLength(int walkLength) {
            this.walkLength = walkLength;
            this.walkLengthBuildStage = 1;
        }

        int walksPerNode() {
            if (this.walksPerNodeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walksPerNodeBuildStage == 0) {
                this.walksPerNodeBuildStage = (byte)-1;
                this.walksPerNode = ImmutableRandomWalkStatsConfig.this.walksPerNodeInitialize();
                this.walksPerNodeBuildStage = 1;
            }
            return this.walksPerNode;
        }

        void walksPerNode(int walksPerNode) {
            this.walksPerNode = walksPerNode;
            this.walksPerNodeBuildStage = 1;
        }

        int walkBufferSize() {
            if (this.walkBufferSizeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.walkBufferSizeBuildStage == 0) {
                this.walkBufferSizeBuildStage = (byte)-1;
                this.walkBufferSize = ImmutableRandomWalkStatsConfig.this.walkBufferSizeInitialize();
                this.walkBufferSizeBuildStage = 1;
            }
            return this.walkBufferSize;
        }

        void walkBufferSize(int walkBufferSize) {
            this.walkBufferSize = walkBufferSize;
            this.walkBufferSizeBuildStage = 1;
        }

        double inOutFactor() {
            if (this.inOutFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.inOutFactorBuildStage == 0) {
                this.inOutFactorBuildStage = (byte)-1;
                this.inOutFactor = ImmutableRandomWalkStatsConfig.this.inOutFactorInitialize();
                this.inOutFactorBuildStage = 1;
            }
            return this.inOutFactor;
        }

        void inOutFactor(double inOutFactor) {
            this.inOutFactor = inOutFactor;
            this.inOutFactorBuildStage = 1;
        }

        double returnFactor() {
            if (this.returnFactorBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.returnFactorBuildStage == 0) {
                this.returnFactorBuildStage = (byte)-1;
                this.returnFactor = ImmutableRandomWalkStatsConfig.this.returnFactorInitialize();
                this.returnFactorBuildStage = 1;
            }
            return this.returnFactor;
        }

        void returnFactor(double returnFactor) {
            this.returnFactor = returnFactor;
            this.returnFactorBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.sudoBuildStage == -1) {
                attributes.add("sudo");
            }
            if (this.logProgressBuildStage == -1) {
                attributes.add("logProgress");
            }
            if (this.configKeysBuildStage == -1) {
                attributes.add("configKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.concurrencyBuildStage == -1) {
                attributes.add("concurrency");
            }
            if (this.minBatchSizeBuildStage == -1) {
                attributes.add("minBatchSize");
            }
            if (this.jobIdBuildStage == -1) {
                attributes.add("jobId");
            }
            if (this.relationshipTypesBuildStage == -1) {
                attributes.add("relationshipTypes");
            }
            if (this.nodeLabelsBuildStage == -1) {
                attributes.add("nodeLabels");
            }
            if (this.hasRelationshipWeightPropertyBuildStage == -1) {
                attributes.add("hasRelationshipWeightProperty");
            }
            if (this.sourceNodesBuildStage == -1) {
                attributes.add("sourceNodes");
            }
            if (this.walkLengthBuildStage == -1) {
                attributes.add("walkLength");
            }
            if (this.walksPerNodeBuildStage == -1) {
                attributes.add("walksPerNode");
            }
            if (this.walkBufferSizeBuildStage == -1) {
                attributes.add("walkBufferSize");
            }
            if (this.inOutFactorBuildStage == -1) {
                attributes.add("inOutFactor");
            }
            if (this.returnFactorBuildStage == -1) {
                attributes.add("returnFactor");
            }
            return "Cannot build RandomWalkStatsConfig, attribute initializers form cycle " + attributes;
        }
    }
}

