/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.triangle.IntersectingTriangleCount;
import org.neo4j.gds.triangle.TriangleCountBaseConfig;

public class IntersectingTriangleCountFactory<CONFIG extends TriangleCountBaseConfig>
extends GraphAlgorithmFactory<IntersectingTriangleCount, CONFIG> {
    private static final String INTERSECTING_TRIANGLE_COUNT_TASK_NAME = IntersectingTriangleCount.class.getSimpleName();

    public String taskName() {
        return INTERSECTING_TRIANGLE_COUNT_TASK_NAME;
    }

    public IntersectingTriangleCount build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return IntersectingTriangleCount.create(graph, configuration, Pools.DEFAULT, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        return MemoryEstimations.builder(IntersectingTriangleCount.class).perNode("triangle-counts", HugeAtomicLongArray::memoryEstimation).build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return IntersectingTriangleCountFactory.triangleCountProgressTask(graph);
    }

    @NotNull
    public static Task triangleCountProgressTask(Graph graph) {
        return Tasks.leaf((String)INTERSECTING_TRIANGLE_COUNT_TASK_NAME, (long)graph.nodeCount());
    }
}

