/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.Optional;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.function.LongToDoubleFunction;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.paged.HugeAtomicLongArray;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.triangle.ImmutableResult;
import org.neo4j.gds.triangle.IntersectingTriangleCount;
import org.neo4j.gds.triangle.IntersectingTriangleCountFactory;
import org.neo4j.gds.triangle.LocalClusteringCoefficientBaseConfig;
import org.neo4j.gds.triangle.LocalClusteringCoefficientFactory;
import org.neo4j.gds.triangle.TriangleCountStatsConfig;
import org.neo4j.gds.utils.CloseableThreadLocal;

public class LocalClusteringCoefficient
extends Algorithm<Result> {
    private final int concurrency;
    private final NodePropertyValues triangleCountProperty;
    private final LocalClusteringCoefficientBaseConfig configuration;
    private Graph graph;
    private HugeDoubleArray localClusteringCoefficients;
    private double averageClusteringCoefficient;

    LocalClusteringCoefficient(Graph graph, LocalClusteringCoefficientBaseConfig configuration, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.configuration = configuration;
        this.concurrency = configuration.concurrency();
        this.triangleCountProperty = Optional.ofNullable(configuration.seedProperty()).map(arg_0 -> ((Graph)graph).nodeProperties(arg_0)).orElse(null);
    }

    public Result compute() {
        this.progressTracker.beginSubTask();
        if (null == this.triangleCountProperty) {
            HugeAtomicLongArray triangleCounts = this.computeTriangleCounts();
            this.calculateCoefficients(arg_0 -> ((HugeAtomicLongArray)triangleCounts).get(arg_0));
        } else {
            this.calculateCoefficients(arg_0 -> ((NodePropertyValues)this.triangleCountProperty).doubleValue(arg_0));
        }
        this.progressTracker.endSubTask();
        return Result.of(this.localClusteringCoefficients, this.averageClusteringCoefficient);
    }

    private void calculateCoefficients(LongToDoubleFunction propertyValueFunction) {
        this.progressTracker.beginSubTask();
        long nodeCount = this.graph.nodeCount();
        this.localClusteringCoefficients = HugeDoubleArray.newArray((long)nodeCount);
        DoubleAdder localClusteringCoefficientSum = new DoubleAdder();
        try (CloseableThreadLocal concurrentGraphCopy = CloseableThreadLocal.withInitial(() -> this.graph.concurrentCopy());){
            ParallelUtil.parallelForEachNode((Graph)this.graph, (int)this.concurrency, nodeId -> {
                double localClusteringCoefficient = this.calculateCoefficient(propertyValueFunction.applyAsDouble(nodeId), this.graph.isMultiGraph() ? ((Graph)concurrentGraphCopy.get()).degreeWithoutParallelRelationships(nodeId) : this.graph.degree(nodeId));
                this.localClusteringCoefficients.set(nodeId, localClusteringCoefficient);
                localClusteringCoefficientSum.add(localClusteringCoefficient);
                this.progressTracker.logProgress();
            });
        }
        this.averageClusteringCoefficient = localClusteringCoefficientSum.doubleValue() / (double)nodeCount;
        this.progressTracker.endSubTask();
    }

    private HugeAtomicLongArray computeTriangleCounts() {
        IntersectingTriangleCount intersectingTriangleCount = new IntersectingTriangleCountFactory<TriangleCountStatsConfig>().build(this.graph, LocalClusteringCoefficientFactory.createTriangleCountConfig(this.configuration), this.progressTracker);
        return intersectingTriangleCount.compute().localTriangles();
    }

    private double calculateCoefficient(double triangles, int degree) {
        if (Double.isNaN(triangles) || triangles == -1.0) {
            return Double.NaN;
        }
        if (triangles == 0.0) {
            return 0.0;
        }
        return triangles * 2.0 / (double)(degree * (degree - 1));
    }

    public void release() {
        this.localClusteringCoefficients = null;
        this.graph = null;
    }

    @ValueClass
    static interface Result {
        public HugeDoubleArray localClusteringCoefficients();

        public double averageClusteringCoefficient();

        public static Result of(HugeDoubleArray localClusteringCoefficients, double averageClusteringCoefficient) {
            return ImmutableResult.builder().localClusteringCoefficients(localClusteringCoefficients).averageClusteringCoefficient(averageClusteringCoefficient).build();
        }

        default public NodePropertyValues asNodeProperties() {
            return this.localClusteringCoefficients().asNodeProperties();
        }
    }
}

