/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.ConfigurableSeedConfig;
import org.neo4j.gds.core.StringIdentifierValidations;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Configuration
public interface LocalClusteringCoefficientBaseConfig
extends AlgoBaseConfig,
ConfigurableSeedConfig {
    @Value.Default
    @Configuration.Key(value="triangleCountProperty")
    @Configuration.ConvertWith(method="validateProperty")
    @Nullable
    default public String seedProperty() {
        return null;
    }

    @Configuration.Ignore
    default public String propertyNameOverride() {
        return "triangleCountProperty";
    }

    @Nullable
    public static String validateProperty(String input) {
        return StringIdentifierValidations.validateNoWhiteCharacter((String)input, (String)"triangleCountProperty");
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateUndirectedGraph(GraphStore graphStore, Collection<NodeLabel> ignored, Collection<RelationshipType> selectedRelationshipTypes) {
        if (!graphStore.schema().filterRelationshipTypes(Set.copyOf(selectedRelationshipTypes)).isUndirected()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"LocalClusteringCoefficient requires relationship projections to be UNDIRECTED. Selected relationships `%s` are not all undirected.", (Object[])new Object[]{selectedRelationshipTypes.stream().map(ElementIdentifier::name).collect(Collectors.toSet())}));
        }
    }
}

