/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.ArrayList;
import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.HugeDoubleArray;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.triangle.ImmutableTriangleCountStatsConfig;
import org.neo4j.gds.triangle.IntersectingTriangleCountFactory;
import org.neo4j.gds.triangle.LocalClusteringCoefficient;
import org.neo4j.gds.triangle.LocalClusteringCoefficientBaseConfig;
import org.neo4j.gds.triangle.TriangleCountStatsConfig;

public class LocalClusteringCoefficientFactory<CONFIG extends LocalClusteringCoefficientBaseConfig>
extends GraphAlgorithmFactory<LocalClusteringCoefficient, CONFIG> {
    public String taskName() {
        return "LocalClusteringCoefficient";
    }

    public LocalClusteringCoefficient build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        return new LocalClusteringCoefficient(graph, (LocalClusteringCoefficientBaseConfig)configuration, progressTracker);
    }

    public MemoryEstimation memoryEstimation(CONFIG configuration) {
        MemoryEstimations.Builder builder = MemoryEstimations.builder(LocalClusteringCoefficient.class).perNode("local-clustering-coefficient", HugeDoubleArray::memoryEstimation);
        if (null == configuration.seedProperty()) {
            builder.add("computed-triangle-counts", new IntersectingTriangleCountFactory<TriangleCountStatsConfig>().memoryEstimation(LocalClusteringCoefficientFactory.createTriangleCountConfig(configuration)));
        }
        return builder.build();
    }

    static TriangleCountStatsConfig createTriangleCountConfig(LocalClusteringCoefficientBaseConfig configuration) {
        return ImmutableTriangleCountStatsConfig.builder().concurrency(configuration.concurrency()).build();
    }

    public Task progressTask(Graph graph, CONFIG config) {
        ArrayList<Object> tasks = new ArrayList<Object>();
        if (config.seedProperty() == null) {
            tasks.add(IntersectingTriangleCountFactory.triangleCountProgressTask(graph));
        }
        tasks.add(Tasks.leaf((String)"Calculate Local Clustering Coefficient", (long)graph.nodeCount()));
        return Tasks.task((String)this.taskName(), tasks);
    }
}

