/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle;

import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import org.immutables.value.Value;
import org.neo4j.gds.ElementIdentifier;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapAccess;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.triangle.TriangleCountBaseConfigImpl;
import org.neo4j.gds.utils.StringFormatting;

@ValueClass
@Configuration
public interface TriangleCountBaseConfig
extends AlgoBaseConfig {
    @Value.Default
    default public long maxDegree() {
        return Long.MAX_VALUE;
    }

    @Value.Check
    default public void validateMaxDegree() {
        if (this.maxDegree() < 2L) {
            throw new IllegalArgumentException("The 'maxDegree' parameter must be set to a value greater than 1.");
        }
    }

    @Configuration.GraphStoreValidationCheck
    default public void validateTargetRelIsUndirected(GraphStore graphStore, Collection<NodeLabel> ignored, Collection<RelationshipType> selectedRelationshipTypes) {
        if (!graphStore.schema().filterRelationshipTypes(Set.copyOf(selectedRelationshipTypes)).isUndirected()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"TriangleCount requires relationship projections to be UNDIRECTED. Selected relationships `%s` are not all undirected.", (Object[])new Object[]{selectedRelationshipTypes.stream().map(ElementIdentifier::name).collect(Collectors.toSet())}));
        }
    }

    public static TriangleCountBaseConfig of(CypherMapWrapper userInput) {
        return new TriangleCountBaseConfigImpl((CypherMapAccess)userInput);
    }
}

