/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle.intersect;

import java.util.function.IntPredicate;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.IntersectionConsumer;
import org.neo4j.gds.api.RelationshipIntersect;

public abstract class GraphIntersect<CURSOR extends AdjacencyCursor>
implements RelationshipIntersect {
    private CURSOR cache;
    private CURSOR cacheA;
    private CURSOR cacheB;
    private final IntPredicate degreeFilter;

    protected GraphIntersect(long maxDegree) {
        this.degreeFilter = maxDegree < Long.MAX_VALUE ? degree -> (long)degree <= maxDegree : ignore -> true;
    }

    public void intersectAll(long nodeA, IntersectionConsumer consumer) {
        CURSOR neighboursAMain;
        int degreeA = this.degree(nodeA);
        if (!this.degreeFilter.test(degreeA)) {
            return;
        }
        this.cache = neighboursAMain = this.cursorForNode(this.cache, nodeA, degreeA);
        long nodeB = neighboursAMain.skipUntil(nodeA);
        if (nodeB == -1L) {
            return;
        }
        CURSOR neighboursA = this.cacheA;
        long nodeCFromA = -1L;
        CURSOR neighboursB = this.cacheB;
        while (neighboursAMain.hasNextVLong()) {
            long nodeCFromB;
            long triangleC = -1L;
            int degreeB = this.degree(nodeB);
            if (this.degreeFilter.test(degreeB) && (nodeCFromB = (neighboursB = this.cursorForNode(neighboursB, nodeB, degreeB)).skipUntil(nodeB)) != -1L) {
                int degreeCFromB;
                neighboursA = this.copyCursor(neighboursAMain, neighboursA);
                if (this.degreeFilter.test(this.degree(nodeCFromB))) {
                    nodeCFromA = neighboursA.advance(nodeCFromB);
                    triangleC = this.checkForAndEmitTriangle(consumer, nodeA, nodeB, nodeCFromA, nodeCFromB, triangleC);
                }
                while (neighboursA.hasNextVLong() && neighboursB.hasNextVLong()) {
                    nodeCFromB = neighboursB.nextVLong();
                    if (!this.degreeFilter.test(this.degree(nodeCFromB))) continue;
                    if (nodeCFromB > nodeCFromA) {
                        nodeCFromA = neighboursA.advance(nodeCFromB);
                    }
                    triangleC = this.checkForAndEmitTriangle(consumer, nodeA, nodeB, nodeCFromA, nodeCFromB, triangleC);
                }
                if (neighboursB.hasNextVLong() && (nodeCFromB = neighboursB.advance(nodeCFromA)) != -1L && this.degreeFilter.test(degreeCFromB = this.degree(nodeCFromB))) {
                    this.checkForAndEmitTriangle(consumer, nodeA, nodeB, nodeCFromA, nodeCFromB, triangleC);
                }
            }
            if ((nodeB = neighboursAMain.skipUntil(nodeB)) != -1L) continue;
            return;
        }
        this.cacheA = neighboursA;
        this.cacheB = neighboursB;
    }

    private long checkForAndEmitTriangle(IntersectionConsumer consumer, long nodeA, long nodeB, long nodeCa, long nodeCb, long triangleC) {
        if (nodeCa == nodeCb && nodeCa > triangleC) {
            consumer.accept(nodeA, nodeB, nodeCa);
            return nodeCa;
        }
        return triangleC;
    }

    @NotNull
    private CURSOR copyCursor(@NotNull CURSOR source, @Nullable CURSOR destination) {
        return this.checkCursorInstance(source.shallowCopy(destination));
    }

    protected abstract CURSOR checkCursorInstance(AdjacencyCursor var1);

    protected abstract CURSOR cursorForNode(@Nullable CURSOR var1, long var2, int var4);

    protected abstract int degree(long var1);
}

