/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.triangle.intersect;

import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.AdjacencyCursor;
import org.neo4j.gds.api.AdjacencyList;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipIntersect;
import org.neo4j.gds.core.huge.HugeGraph;
import org.neo4j.gds.triangle.intersect.GraphIntersect;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectConfig;
import org.neo4j.gds.triangle.intersect.RelationshipIntersectFactory;

public final class HugeGraphIntersect
extends GraphIntersect<AdjacencyCursor> {
    private final AdjacencyList adjacencyList;

    private HugeGraphIntersect(AdjacencyList adjacency, long maxDegree) {
        super(maxDegree);
        this.adjacencyList = adjacency;
    }

    @Override
    protected int degree(long node) {
        return this.adjacencyList.degree(node);
    }

    @Override
    protected AdjacencyCursor checkCursorInstance(AdjacencyCursor cursor) {
        return cursor;
    }

    @Override
    protected AdjacencyCursor cursorForNode(@Nullable AdjacencyCursor reuse, long node, int degree) {
        return this.adjacencyList.adjacencyCursor(reuse, node);
    }

    public static final class HugeGraphIntersectFactory
    implements RelationshipIntersectFactory {
        @Override
        public boolean canLoad(Graph graph) {
            return graph instanceof HugeGraph;
        }

        @Override
        public RelationshipIntersect load(Graph graph, RelationshipIntersectConfig config) {
            assert (graph instanceof HugeGraph);
            HugeGraph hugeGraph = (HugeGraph)graph;
            AdjacencyList topology = hugeGraph.relationshipTopology().adjacencyList();
            return new HugeGraphIntersect(topology, config.maxDegree());
        }
    }
}

