/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.wcc;

import java.util.ArrayList;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.immutables.builder.Builder;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.RelationshipConsumer;
import org.neo4j.gds.api.RelationshipWithPropertyConsumer;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.dss.DisjointSetStruct;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.wcc.Wcc;

final class UnsampledStrategy {
    private final Graph graph;
    private final DisjointSetStruct disjointSetStruct;
    private final long batchSize;
    private final int threadSize;
    private final Optional<Double> threshold;
    private final TerminationFlag terminationFlag;
    private final ProgressTracker progressTracker;
    private final ExecutorService executorService;

    @Builder.Constructor
    UnsampledStrategy(Graph graph, DisjointSetStruct disjointSetStruct, long batchSize, Optional<Double> threshold, TerminationFlag terminationFlag, ProgressTracker progressTracker, ExecutorService executorService) {
        this.graph = graph;
        this.disjointSetStruct = disjointSetStruct;
        this.batchSize = batchSize;
        this.threadSize = (int)ParallelUtil.threadCount((long)batchSize, (long)graph.nodeCount());
        this.threshold = threshold;
        this.terminationFlag = terminationFlag;
        this.progressTracker = progressTracker;
        this.executorService = executorService;
    }

    void compute() {
        ArrayList<UnionTask> tasks = new ArrayList<UnionTask>(this.threadSize);
        for (long offset = 0L; offset < this.graph.nodeCount(); offset += this.batchSize) {
            UnionTask unionTask = this.threshold.isEmpty() ? new UnionTask(this.graph, this.disjointSetStruct, offset, this.batchSize, this.terminationFlag, this.progressTracker) : new UnionWithThresholdTask(this.graph, this.disjointSetStruct, this.threshold.get(), offset, this.batchSize, this.terminationFlag, this.progressTracker);
            tasks.add(unionTask);
        }
        ParallelUtil.run(tasks, (ExecutorService)this.executorService);
    }

    static class UnionWithThresholdTask
    extends UnionTask
    implements RelationshipWithPropertyConsumer {
        private final double threshold;

        UnionWithThresholdTask(Graph graph, DisjointSetStruct struct, double threshold, long offset, long batchSize, TerminationFlag terminationFlag, ProgressTracker progressTracker) {
            super(graph, struct, offset, batchSize, terminationFlag, progressTracker);
            this.threshold = threshold;
        }

        @Override
        void compute(long node) {
            this.graph.forEachRelationship(node, Wcc.defaultWeight(this.threshold), (RelationshipWithPropertyConsumer)this);
        }

        public boolean accept(long sourceNodeId, long targetNodeId, double property) {
            if (property > this.threshold) {
                this.struct.union(sourceNodeId, targetNodeId);
            }
            return true;
        }
    }

    static class UnionTask
    implements Runnable,
    RelationshipConsumer {
        final Graph graph;
        final DisjointSetStruct struct;
        private final long offset;
        private final ProgressTracker progressTracker;
        private final long end;
        private final TerminationFlag terminationFlag;

        UnionTask(Graph graph, DisjointSetStruct disjointSetStruct, long offset, long batchSize, TerminationFlag terminationFlag, ProgressTracker progressTracker) {
            this.graph = graph.concurrentCopy();
            this.struct = disjointSetStruct;
            this.offset = offset;
            this.terminationFlag = terminationFlag;
            this.progressTracker = progressTracker;
            this.end = Math.min(offset + batchSize, graph.nodeCount());
        }

        @Override
        public void run() {
            for (long node = this.offset; node < this.end; ++node) {
                this.compute(node);
                if (node % 10000L == 0L) {
                    this.terminationFlag.assertRunning();
                }
                this.progressTracker.logProgress((long)this.graph.degree(node));
            }
        }

        void compute(long node) {
            this.graph.forEachRelationship(node, (RelationshipConsumer)this);
        }

        public boolean accept(long sourceNodeId, long targetNodeId) {
            this.struct.union(sourceNodeId, targetNodeId);
            return true;
        }
    }
}

