/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.wcc;

import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.immutables.value.Generated;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.utils.TerminationFlag;
import org.neo4j.gds.core.utils.paged.dss.DisjointSetStruct;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.wcc.UnsampledStrategy;

@Generated(from="org.neo4j.gds.wcc.UnsampledStrategy", generator="Immutables")
public final class UnsampledStrategyBuilder {
    private static final long INIT_BIT_GRAPH = 1L;
    private static final long INIT_BIT_DISJOINT_SET_STRUCT = 2L;
    private static final long INIT_BIT_BATCH_SIZE = 4L;
    private static final long INIT_BIT_TERMINATION_FLAG = 8L;
    private static final long INIT_BIT_PROGRESS_TRACKER = 16L;
    private static final long INIT_BIT_EXECUTOR_SERVICE = 32L;
    private long initBits = 63L;
    private Graph graph;
    private DisjointSetStruct disjointSetStruct;
    private long batchSize;
    private Optional<Double> threshold = Optional.empty();
    private TerminationFlag terminationFlag;
    private ProgressTracker progressTracker;
    private ExecutorService executorService;

    public final UnsampledStrategyBuilder graph(Graph graph) {
        this.graph = Objects.requireNonNull(graph, "graph");
        this.initBits &= 0xFFFFFFFFFFFFFFFEL;
        return this;
    }

    public final UnsampledStrategyBuilder disjointSetStruct(DisjointSetStruct disjointSetStruct) {
        this.disjointSetStruct = Objects.requireNonNull(disjointSetStruct, "disjointSetStruct");
        this.initBits &= 0xFFFFFFFFFFFFFFFDL;
        return this;
    }

    public final UnsampledStrategyBuilder batchSize(long batchSize) {
        this.batchSize = batchSize;
        this.initBits &= 0xFFFFFFFFFFFFFFFBL;
        return this;
    }

    public final UnsampledStrategyBuilder threshold(double threshold) {
        this.threshold = Optional.of(threshold);
        return this;
    }

    public final UnsampledStrategyBuilder threshold(Optional<Double> threshold) {
        this.threshold = Objects.requireNonNull(threshold, "threshold");
        return this;
    }

    public final UnsampledStrategyBuilder terminationFlag(TerminationFlag terminationFlag) {
        this.terminationFlag = Objects.requireNonNull(terminationFlag, "terminationFlag");
        this.initBits &= 0xFFFFFFFFFFFFFFF7L;
        return this;
    }

    public final UnsampledStrategyBuilder progressTracker(ProgressTracker progressTracker) {
        this.progressTracker = Objects.requireNonNull(progressTracker, "progressTracker");
        this.initBits &= 0xFFFFFFFFFFFFFFEFL;
        return this;
    }

    public final UnsampledStrategyBuilder executorService(ExecutorService executorService) {
        this.executorService = Objects.requireNonNull(executorService, "executorService");
        this.initBits &= 0xFFFFFFFFFFFFFFDFL;
        return this;
    }

    public UnsampledStrategy build() {
        this.checkRequiredAttributes();
        return new UnsampledStrategy(this.graph, this.disjointSetStruct, this.batchSize, this.threshold, this.terminationFlag, this.progressTracker, this.executorService);
    }

    private boolean graphIsSet() {
        return (this.initBits & 1L) == 0L;
    }

    private boolean disjointSetStructIsSet() {
        return (this.initBits & 2L) == 0L;
    }

    private boolean batchSizeIsSet() {
        return (this.initBits & 4L) == 0L;
    }

    private boolean terminationFlagIsSet() {
        return (this.initBits & 8L) == 0L;
    }

    private boolean progressTrackerIsSet() {
        return (this.initBits & 0x10L) == 0L;
    }

    private boolean executorServiceIsSet() {
        return (this.initBits & 0x20L) == 0L;
    }

    private void checkRequiredAttributes() {
        if (this.initBits != 0L) {
            throw new IllegalStateException(this.formatRequiredAttributesMessage());
        }
    }

    private String formatRequiredAttributesMessage() {
        ArrayList<String> attributes = new ArrayList<String>();
        if (!this.graphIsSet()) {
            attributes.add("graph");
        }
        if (!this.disjointSetStructIsSet()) {
            attributes.add("disjointSetStruct");
        }
        if (!this.batchSizeIsSet()) {
            attributes.add("batchSize");
        }
        if (!this.terminationFlagIsSet()) {
            attributes.add("terminationFlag");
        }
        if (!this.progressTrackerIsSet()) {
            attributes.add("progressTracker");
        }
        if (!this.executorServiceIsSet()) {
            attributes.add("executorService");
        }
        return "Cannot build UnsampledStrategy, some of required attributes are not set " + attributes;
    }
}

