/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.wcc;

import java.util.Optional;
import java.util.concurrent.ExecutorService;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.properties.nodes.NodePropertyValues;
import org.neo4j.gds.core.concurrency.ParallelUtil;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.mem.MemoryEstimations;
import org.neo4j.gds.core.utils.paged.dss.DisjointSetStruct;
import org.neo4j.gds.core.utils.paged.dss.HugeAtomicDisjointSetStruct;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.wcc.SampledStrategyBuilder;
import org.neo4j.gds.wcc.UnsampledStrategyBuilder;
import org.neo4j.gds.wcc.WccBaseConfig;

public class Wcc
extends Algorithm<DisjointSetStruct> {
    private final WccBaseConfig config;
    private final NodePropertyValues initialComponents;
    private final ExecutorService executorService;
    private final long batchSize;
    private Graph graph;

    public static MemoryEstimation memoryEstimation(boolean incremental) {
        return MemoryEstimations.builder((String)Wcc.class.getSimpleName()).add("dss", HugeAtomicDisjointSetStruct.memoryEstimation((boolean)incremental)).build();
    }

    public Wcc(Graph graph, ExecutorService executor, int minBatchSize, WccBaseConfig config, ProgressTracker progressTracker) {
        super(progressTracker);
        this.graph = graph;
        this.config = config;
        this.initialComponents = config.isIncremental() ? graph.nodeProperties(config.seedProperty()) : null;
        this.executorService = executor;
        this.batchSize = ParallelUtil.adjustedBatchSize((long)graph.nodeCount(), (int)config.concurrency(), (long)minBatchSize, (long)Integer.MAX_VALUE);
        if (ParallelUtil.threadCount((long)this.batchSize, (long)graph.nodeCount()) > Integer.MAX_VALUE) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Too many nodes (%d) to run WCC with the given concurrency (%d) and batchSize (%d)", (Object[])new Object[]{graph.nodeCount(), config.concurrency(), this.batchSize}));
        }
    }

    public DisjointSetStruct compute() {
        HugeAtomicDisjointSetStruct disjointSetStruct;
        this.progressTracker.beginSubTask();
        long nodeCount = this.graph.nodeCount();
        HugeAtomicDisjointSetStruct hugeAtomicDisjointSetStruct = disjointSetStruct = this.config.isIncremental() ? new HugeAtomicDisjointSetStruct(nodeCount, this.initialComponents, this.config.concurrency()) : new HugeAtomicDisjointSetStruct(nodeCount, this.config.concurrency());
        if (this.graph.characteristics().isUndirected() || this.graph.characteristics().isInverseIndexed()) {
            new SampledStrategyBuilder().graph(this.graph).disjointSetStruct((DisjointSetStruct)disjointSetStruct).threshold(this.threshold()).concurrency(this.config.concurrency()).terminationFlag(this.terminationFlag).progressTracker(this.progressTracker).executorService(this.executorService).build().compute();
        } else {
            new UnsampledStrategyBuilder().graph(this.graph).disjointSetStruct((DisjointSetStruct)disjointSetStruct).threshold(this.threshold()).batchSize(this.batchSize).terminationFlag(this.terminationFlag).progressTracker(this.progressTracker).executorService(this.executorService).build().compute();
        }
        this.progressTracker.endSubTask();
        return disjointSetStruct;
    }

    public void release() {
        this.graph = null;
    }

    static double defaultWeight(double threshold) {
        return threshold + 1.0;
    }

    private Optional<Double> threshold() {
        return this.config.hasThreshold() ? Optional.of(this.config.threshold()) : Optional.empty();
    }
}

