/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.wcc;

import org.neo4j.gds.GraphAlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.core.concurrency.Pools;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.core.utils.progress.tasks.ProgressTracker;
import org.neo4j.gds.core.utils.progress.tasks.Task;
import org.neo4j.gds.core.utils.progress.tasks.Tasks;
import org.neo4j.gds.wcc.Wcc;
import org.neo4j.gds.wcc.WccBaseConfig;

public final class WccAlgorithmFactory<CONFIG extends WccBaseConfig>
extends GraphAlgorithmFactory<Wcc, CONFIG> {
    public String taskName() {
        return "WCC";
    }

    public Wcc build(Graph graph, CONFIG configuration, ProgressTracker progressTracker) {
        if (configuration.hasRelationshipWeightProperty() && configuration.threshold() == 0.0) {
            progressTracker.logWarning("Specifying a `relationshipWeightProperty` has no effect unless `threshold` is also set.");
        }
        return new Wcc(graph, Pools.DEFAULT, 10000, (WccBaseConfig)configuration, progressTracker);
    }

    public Task progressTask(Graph graph, CONFIG config) {
        return Tasks.leaf((String)this.taskName(), (long)graph.relationshipCount());
    }

    public MemoryEstimation memoryEstimation(CONFIG config) {
        return Wcc.memoryEstimation(config.isIncremental());
    }
}

