/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.core.ImmutableStringAndScore;
import org.neo4j.gds.core.MissingParameterExceptions;
import org.neo4j.gds.core.StringSimilarity;

public final class CypherMapWrapper {
    private final Map<String, Object> config;

    private CypherMapWrapper(Map<String, Object> config) {
        this.config = config;
    }

    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    public boolean isEmpty() {
        return this.config.isEmpty();
    }

    public Optional<String> getString(String key) {
        return Optional.ofNullable(this.getChecked(key, null, String.class));
    }

    public String requireString(String key) {
        return this.requireChecked(key, String.class);
    }

    public Map<String, Object> getMap(String key) {
        return this.getChecked(key, Map.of(), Map.class);
    }

    public List<String> getList(String key) {
        return this.getChecked(key, List.of(), List.class);
    }

    public <E> Optional<E> getOptional(String key, Class<E> clazz) {
        return Optional.ofNullable(this.getChecked(key, null, clazz));
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    public String getString(String key, @Nullable String defaultValue) {
        return this.getChecked(key, defaultValue, String.class);
    }

    @Contract(value="_, _, !null -> !null")
    @Nullable
    public String getString(String key, String oldKey, @Nullable String defaultValue) {
        String value = this.getChecked(key, null, String.class);
        if (value != null) {
            return value;
        }
        return this.getChecked(oldKey, defaultValue, String.class);
    }

    public boolean getBool(String key, boolean defaultValue) {
        return this.getChecked(key, defaultValue, Boolean.class);
    }

    public boolean requireBool(String key) {
        return this.requireChecked(key, Boolean.class);
    }

    public Number getNumber(String key, Number defaultValue) {
        return this.getChecked(key, defaultValue, Number.class);
    }

    public Number requireNumber(String key) {
        return this.requireChecked(key, Number.class);
    }

    public Number getNumber(String key, String oldKey, Number defaultValue) {
        Number value = this.getChecked(key, null, Number.class);
        if (value != null) {
            return value;
        }
        return this.getChecked(oldKey, defaultValue, Number.class);
    }

    public long getLong(String key, long defaultValue) {
        return this.getChecked(key, defaultValue, Long.class);
    }

    public long requireLong(String key) {
        return this.requireChecked(key, Long.class);
    }

    public int getInt(String key, int defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        return this.getLongAsInt(key);
    }

    public int requireInt(String key) {
        if (!this.containsKey(key)) {
            throw this.missingValueFor(key);
        }
        return this.getLongAsInt(key);
    }

    private int getLongAsInt(String key) {
        Object value = this.config.get(key);
        if (value instanceof Long) {
            value = Math.toIntExact((Long)value);
        }
        return CypherMapWrapper.typedValue(key, Integer.class, value);
    }

    public double getDouble(String key, double defaultValue) {
        return this.getChecked(key, defaultValue, Double.class);
    }

    public Map<String, Object> toMap() {
        return new HashMap<String, Object>(this.config);
    }

    public double requireDouble(String key) {
        return this.requireChecked(key, Double.class);
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    public <V> V getChecked(String key, @Nullable V defaultValue, Class<V> expectedType) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        return CypherMapWrapper.typedValue(key, expectedType, this.config.get(key));
    }

    public <V> V requireChecked(String key, Class<V> expectedType) {
        if (!this.containsKey(key)) {
            throw this.missingValueFor(key);
        }
        return CypherMapWrapper.typedValue(key, expectedType, this.config.get(key));
    }

    public void requireOnlyKeysFrom(Collection<String> allowedKeys) {
        ConfigKeyValidation.requireOnlyKeysFrom(allowedKeys, this.config.keySet());
    }

    public static <T> T failOnNull(String key, T value) {
        if (value == null) {
            throw MissingParameterExceptions.missingValueFor(key, Collections.emptySet());
        }
        return value;
    }

    @NotNull
    public static String failOnBlank(String key, @Nullable String value) {
        if (value == null || value.trim().isEmpty()) {
            throw CypherMapWrapper.blankValueFor(key, value);
        }
        return value;
    }

    public static int validateIntegerRange(String key, int value, int min, int max, boolean minInclusive, boolean maxInclusive) {
        boolean meetsUpperBound;
        boolean meetsLowerBound;
        boolean bl = minInclusive ? value >= min : (meetsLowerBound = value > min);
        boolean bl2 = maxInclusive ? value <= max : (meetsUpperBound = value < max);
        if (!meetsLowerBound || !meetsUpperBound) {
            throw CypherMapWrapper.outOfRangeError(key, value, Integer.toString(min), Integer.toString(max), minInclusive, maxInclusive);
        }
        return value;
    }

    public static long validateLongRange(String key, long value, long min, long max, boolean minInclusive, boolean maxInclusive) {
        boolean meetsUpperBound;
        boolean meetsLowerBound;
        boolean bl = minInclusive ? value >= min : (meetsLowerBound = value > min);
        boolean bl2 = maxInclusive ? value <= max : (meetsUpperBound = value < max);
        if (!meetsLowerBound || !meetsUpperBound) {
            throw CypherMapWrapper.outOfRangeError(key, value, Long.toString(min), Long.toString(max), minInclusive, maxInclusive);
        }
        return value;
    }

    public static double validateDoubleRange(String key, double value, double min, double max, boolean minInclusive, boolean maxInclusive) {
        boolean meetsUpperBound;
        boolean meetsLowerBound;
        boolean bl = minInclusive ? value >= min : (meetsLowerBound = value > min);
        boolean bl2 = maxInclusive ? value <= max : (meetsUpperBound = value < max);
        if (!meetsLowerBound || !meetsUpperBound) {
            throw CypherMapWrapper.outOfRangeError(key, value, String.format(Locale.ENGLISH, "%.2f", min), String.format(Locale.ENGLISH, "%.2f", max), minInclusive, maxInclusive);
        }
        return value;
    }

    private static <V> V typedValue(String key, Class<V> expectedType, @Nullable Object value) {
        if (Double.class.isAssignableFrom(expectedType) && value instanceof Number) {
            return expectedType.cast(((Number)value).doubleValue());
        }
        if (expectedType.equals(Integer.class) && value instanceof Long) {
            return expectedType.cast(Math.toIntExact((Long)value));
        }
        if (!expectedType.isInstance(value)) {
            String message = String.format(Locale.ENGLISH, "The value of `%s` must be of type `%s` but was `%s`.", key, expectedType.getSimpleName(), value == null ? "null" : value.getClass().getSimpleName());
            throw new IllegalArgumentException(message);
        }
        return expectedType.cast(value);
    }

    private IllegalArgumentException missingValueFor(String key) {
        return MissingParameterExceptions.missingValueFor(key, this.config.keySet());
    }

    public PairResult verifyMutuallyExclusivePairs(String firstPairKeyOne, String firstPairKeyTwo, String secondPairKeyOne, String secondPairKeyTwo, String errorPrefix) throws IllegalArgumentException {
        boolean isValidFirstPair = this.checkMutuallyExclusivePairs(firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
        if (isValidFirstPair) {
            return PairResult.FIRST_PAIR;
        }
        boolean isValidSecondPair = this.checkMutuallyExclusivePairs(secondPairKeyOne, secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo);
        if (isValidSecondPair) {
            return PairResult.SECOND_PAIR;
        }
        String message = this.missingMutuallyExclusivePairMessage(firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s %s", errorPrefix, message));
    }

    private boolean checkMutuallyExclusivePairs(String firstPairKeyOne, String firstPairKeyTwo, String secondPairKeyOne, String secondPairKeyTwo) throws IllegalArgumentException {
        if (this.config.containsKey(firstPairKeyOne) && this.config.containsKey(firstPairKeyTwo)) {
            boolean secondOneExists = this.config.containsKey(secondPairKeyOne);
            boolean secondTwoExists = this.config.containsKey(secondPairKeyTwo);
            if (secondOneExists && secondTwoExists) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid keys: [%s, %s]. Those keys cannot be used together with `%s` and `%s`.", secondPairKeyOne, secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo));
            }
            if (secondOneExists || secondTwoExists) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid key: [%s]. This key cannot be used together with `%s` and `%s`.", secondOneExists ? secondPairKeyOne : secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo));
            }
            return true;
        }
        return false;
    }

    private String missingMutuallyExclusivePairMessage(String firstPairKeyOne, String firstPairKeyTwo, String secondPairKeyOne, String secondPairKeyTwo) {
        ConfigKeyValidation.StringAndScore firstMessage = this.missingMutuallyExclusivePairs(firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
        ConfigKeyValidation.StringAndScore secondMessage = this.missingMutuallyExclusivePairs(secondPairKeyOne, secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo);
        if (firstMessage != null && firstMessage.isBetterThan(secondMessage)) {
            return firstMessage.string();
        }
        if (secondMessage != null && secondMessage.isBetterThan(firstMessage)) {
            return secondMessage.string();
        }
        return String.format(Locale.ENGLISH, "Specify either `%s` and `%s` or `%s` and `%s`.", firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
    }

    @Nullable
    private ConfigKeyValidation.StringAndScore missingMutuallyExclusivePairs(String keyOne, String keyTwo, String ... forbiddenSuggestions) {
        String message;
        double score;
        ArrayList missingAndCandidates = new ArrayList();
        ArrayList<String> missingWithoutCandidates = new ArrayList<String>();
        boolean hasAtLastOneKey = false;
        for (String key : List.of(keyOne, keyTwo)) {
            if (this.config.containsKey(key)) {
                hasAtLastOneKey = true;
                continue;
            }
            List<String> candidates = StringSimilarity.similarStringsIgnoreCase(key, this.config.keySet());
            candidates.removeAll(List.of(forbiddenSuggestions));
            String message2 = MissingParameterExceptions.missingValueMessage(key, candidates);
            (candidates.isEmpty() ? missingWithoutCandidates : missingAndCandidates).add(message2);
        }
        double d = hasAtLastOneKey ? 1.0 : (score = !missingAndCandidates.isEmpty() ? 0.5 : 0.0);
        if (!missingAndCandidates.isEmpty()) {
            missingAndCandidates.addAll(missingWithoutCandidates);
            message = String.join((CharSequence)". ", missingAndCandidates);
            return ImmutableStringAndScore.of(message, score);
        }
        if (hasAtLastOneKey && !missingWithoutCandidates.isEmpty()) {
            message = String.join((CharSequence)". ", missingWithoutCandidates);
            return ImmutableStringAndScore.of(message, score);
        }
        return null;
    }

    private static IllegalArgumentException blankValueFor(String key, @Nullable String value) {
        return new IllegalArgumentException(String.format(Locale.ENGLISH, "`%s` can not be null or blank, but it was `%s`", key, value));
    }

    private static IllegalArgumentException outOfRangeError(String key, Number value, String min, String max, boolean minInclusive, boolean maxInclusive) {
        return new IllegalArgumentException(String.format(Locale.ENGLISH, "Value for `%s` was `%s`, but must be within the range %s%s, %s%s.", key, value, minInclusive ? "[" : "(", min, max, maxInclusive ? "]" : ")"));
    }

    public static CypherMapWrapper create(Map<String, Object> config) {
        if (config == null) {
            return CypherMapWrapper.empty();
        }
        TreeMap<String, Object> configMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        config.forEach((key, value) -> {
            if (value != null) {
                configMap.put((String)key, value);
            }
        });
        return new CypherMapWrapper(configMap);
    }

    public static CypherMapWrapper empty() {
        return new CypherMapWrapper(Map.of());
    }

    public CypherMapWrapper withString(String key, String value) {
        return this.withEntry(key, value);
    }

    public CypherMapWrapper withNumber(String key, Number value) {
        return this.withEntry(key, value);
    }

    public CypherMapWrapper withBoolean(String key, Boolean value) {
        return this.withEntry(key, value);
    }

    public CypherMapWrapper withEntry(String key, Object value) {
        Map<String, Object> newMap = this.copyValues();
        newMap.put(key, value);
        return new CypherMapWrapper(newMap);
    }

    public CypherMapWrapper withoutEntry(String key) {
        if (!this.containsKey(key)) {
            return this;
        }
        Map<String, Object> newMap = this.copyValues();
        newMap.remove(key);
        return new CypherMapWrapper(newMap);
    }

    public CypherMapWrapper withoutAny(Collection<String> keys) {
        Map<String, Object> newMap = this.copyValues();
        newMap.keySet().removeAll(keys);
        return new CypherMapWrapper(newMap);
    }

    private Map<String, Object> copyValues() {
        TreeMap<String, Object> copiedMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        copiedMap.putAll(this.config);
        return copiedMap;
    }

    public static enum PairResult {
        FIRST_PAIR,
        SECOND_PAIR;

    }
}

