/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.core.ImmutableStringAndScore;
import org.neo4j.gds.core.MissingParameterExceptions;
import org.neo4j.gds.core.StringSimilarity;

public interface CypherMapAccess {
    public static <T> T failOnNull(String key, T value) {
        if (value == null) {
            throw MissingParameterExceptions.missingValueFor(key, Collections.emptySet());
        }
        return value;
    }

    @NotNull
    public static String failOnBlank(String key, @Nullable String value) {
        if (value == null || value.trim().isEmpty()) {
            throw CypherMapAccess.blankValueFor(key, value);
        }
        return value;
    }

    private static IllegalArgumentException blankValueFor(String key, @Nullable String value) {
        return new IllegalArgumentException(String.format(Locale.ENGLISH, "`%s` can not be null or blank, but it was `%s`", key, value));
    }

    private static IllegalArgumentException outOfRangeError(String key, Number value, String min, String max, boolean minInclusive, boolean maxInclusive) {
        return new IllegalArgumentException(String.format(Locale.ENGLISH, "Value for `%s` was `%s`, but must be within the range %s%s, %s%s.", key, value, minInclusive ? "[" : "(", min, max, maxInclusive ? "]" : ")"));
    }

    public static int validateIntegerRange(String key, int value, int min, int max, boolean minInclusive, boolean maxInclusive) {
        boolean meetsUpperBound;
        boolean meetsLowerBound;
        boolean bl = minInclusive ? value >= min : (meetsLowerBound = value > min);
        boolean bl2 = maxInclusive ? value <= max : (meetsUpperBound = value < max);
        if (!meetsLowerBound || !meetsUpperBound) {
            throw CypherMapAccess.outOfRangeError(key, value, Integer.toString(min), Integer.toString(max), minInclusive, maxInclusive);
        }
        return value;
    }

    public static long validateLongRange(String key, long value, long min, long max, boolean minInclusive, boolean maxInclusive) {
        boolean meetsUpperBound;
        boolean meetsLowerBound;
        boolean bl = minInclusive ? value >= min : (meetsLowerBound = value > min);
        boolean bl2 = maxInclusive ? value <= max : (meetsUpperBound = value < max);
        if (!meetsLowerBound || !meetsUpperBound) {
            throw CypherMapAccess.outOfRangeError(key, value, Long.toString(min), Long.toString(max), minInclusive, maxInclusive);
        }
        return value;
    }

    public static double validateDoubleRange(String key, double value, double min, double max, boolean minInclusive, boolean maxInclusive) {
        boolean meetsUpperBound;
        boolean meetsLowerBound;
        boolean bl = minInclusive ? value >= min : (meetsLowerBound = value > min);
        boolean bl2 = maxInclusive ? value <= max : (meetsUpperBound = value < max);
        if (!meetsLowerBound || !meetsUpperBound) {
            throw CypherMapAccess.outOfRangeError(key, value, String.format(Locale.ENGLISH, "%.2f", min), String.format(Locale.ENGLISH, "%.2f", max), minInclusive, maxInclusive);
        }
        return value;
    }

    default public IllegalArgumentException missingValueFor(String key) {
        return MissingParameterExceptions.missingValueFor(key, this.keySet());
    }

    default public void requireOnlyKeysFrom(Collection<String> allowedKeys) {
        ConfigKeyValidation.requireOnlyKeysFrom(allowedKeys, this.keySet());
    }

    public boolean containsKey(String var1);

    public Collection<String> keySet();

    default public Optional<String> getString(String key) {
        return Optional.ofNullable(this.getChecked(key, null, String.class));
    }

    default public String requireString(String key) {
        return this.requireChecked(key, String.class);
    }

    default public <E> Optional<E> getOptional(String key, Class<E> clazz) {
        return Optional.ofNullable(this.getChecked(key, null, clazz));
    }

    @Contract(value="_, !null -> !null")
    @Nullable
    default public String getString(String key, @Nullable String defaultValue) {
        return this.getChecked(key, defaultValue, String.class);
    }

    default public boolean getBool(String key, boolean defaultValue) {
        return this.getChecked(key, defaultValue, Boolean.class);
    }

    default public boolean requireBool(String key) {
        return this.requireChecked(key, Boolean.class);
    }

    default public Number getNumber(String key, Number defaultValue) {
        return this.getChecked(key, defaultValue, Number.class);
    }

    default public Number requireNumber(String key) {
        return this.requireChecked(key, Number.class);
    }

    default public long getLong(String key, long defaultValue) {
        return this.getChecked(key, defaultValue, Long.class);
    }

    default public long requireLong(String key) {
        return this.requireChecked(key, Long.class);
    }

    default public int getInt(String key, int defaultValue) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        return this.getLongAsInt(key);
    }

    default public int requireInt(String key) {
        if (!this.containsKey(key)) {
            throw this.missingValueFor(key);
        }
        return this.getLongAsInt(key);
    }

    public int getLongAsInt(String var1);

    default public double getDouble(String key, double defaultValue) {
        return this.getChecked(key, defaultValue, Double.class);
    }

    default public double requireDouble(String key) {
        return this.requireChecked(key, Double.class);
    }

    @Contract(value="_, !null, _ -> !null")
    @Nullable
    default public <V> V getChecked(String key, @Nullable V defaultValue, Class<V> expectedType) {
        if (!this.containsKey(key)) {
            return defaultValue;
        }
        return this.typedValue(key, expectedType);
    }

    default public <V> V requireChecked(String key, Class<V> expectedType) {
        if (!this.containsKey(key)) {
            throw this.missingValueFor(key);
        }
        return this.typedValue(key, expectedType);
    }

    @NotNull
    public <V> V typedValue(String var1, Class<V> var2);

    public Map<String, Object> toMap();

    default public PairResult verifyMutuallyExclusivePairs(String firstPairKeyOne, String firstPairKeyTwo, String secondPairKeyOne, String secondPairKeyTwo, String errorPrefix) throws IllegalArgumentException {
        boolean isValidFirstPair = this.checkMutuallyExclusivePairs(firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
        if (isValidFirstPair) {
            return PairResult.FIRST_PAIR;
        }
        boolean isValidSecondPair = this.checkMutuallyExclusivePairs(secondPairKeyOne, secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo);
        if (isValidSecondPair) {
            return PairResult.SECOND_PAIR;
        }
        String message = this.missingMutuallyExclusivePairMessage(firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
        throw new IllegalArgumentException(String.format(Locale.ENGLISH, "%s %s", errorPrefix, message));
    }

    private boolean checkMutuallyExclusivePairs(String firstPairKeyOne, String firstPairKeyTwo, String secondPairKeyOne, String secondPairKeyTwo) throws IllegalArgumentException {
        if (this.containsKey(firstPairKeyOne) && this.containsKey(firstPairKeyTwo)) {
            boolean secondOneExists = this.containsKey(secondPairKeyOne);
            boolean secondTwoExists = this.containsKey(secondPairKeyTwo);
            if (secondOneExists && secondTwoExists) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid keys: [%s, %s]. Those keys cannot be used together with `%s` and `%s`.", secondPairKeyOne, secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo));
            }
            if (secondOneExists || secondTwoExists) {
                throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Invalid key: [%s]. This key cannot be used together with `%s` and `%s`.", secondOneExists ? secondPairKeyOne : secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo));
            }
            return true;
        }
        return false;
    }

    private String missingMutuallyExclusivePairMessage(String firstPairKeyOne, String firstPairKeyTwo, String secondPairKeyOne, String secondPairKeyTwo) {
        ConfigKeyValidation.StringAndScore firstMessage = this.missingMutuallyExclusivePairs(firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
        ConfigKeyValidation.StringAndScore secondMessage = this.missingMutuallyExclusivePairs(secondPairKeyOne, secondPairKeyTwo, firstPairKeyOne, firstPairKeyTwo);
        if (firstMessage != null && firstMessage.isBetterThan(secondMessage)) {
            return firstMessage.string();
        }
        if (secondMessage != null && secondMessage.isBetterThan(firstMessage)) {
            return secondMessage.string();
        }
        return String.format(Locale.ENGLISH, "Specify either `%s` and `%s` or `%s` and `%s`.", firstPairKeyOne, firstPairKeyTwo, secondPairKeyOne, secondPairKeyTwo);
    }

    @Nullable
    private ConfigKeyValidation.StringAndScore missingMutuallyExclusivePairs(String keyOne, String keyTwo, String ... forbiddenSuggestions) {
        String message;
        double score;
        ArrayList missingAndCandidates = new ArrayList();
        ArrayList<String> missingWithoutCandidates = new ArrayList<String>();
        boolean hasAtLastOneKey = false;
        for (String key : List.of(keyOne, keyTwo)) {
            if (this.containsKey(key)) {
                hasAtLastOneKey = true;
                continue;
            }
            List<String> candidates = StringSimilarity.similarStringsIgnoreCase(key, this.keySet());
            candidates.removeAll(List.of(forbiddenSuggestions));
            String message2 = MissingParameterExceptions.missingValueMessage(key, candidates);
            (candidates.isEmpty() ? missingWithoutCandidates : missingAndCandidates).add(message2);
        }
        double d = hasAtLastOneKey ? 1.0 : (score = !missingAndCandidates.isEmpty() ? 0.5 : 0.0);
        if (!missingAndCandidates.isEmpty()) {
            missingAndCandidates.addAll(missingWithoutCandidates);
            message = String.join((CharSequence)". ", missingAndCandidates);
            return ImmutableStringAndScore.of(message, score);
        }
        if (hasAtLastOneKey && !missingWithoutCandidates.isEmpty()) {
            message = String.join((CharSequence)". ", missingWithoutCandidates);
            return ImmutableStringAndScore.of(message, score);
        }
        return null;
    }

    public static enum PairResult {
        FIRST_PAIR,
        SECOND_PAIR;

    }
}

