/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.core;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.core.CypherMapAccess;

public final class CypherMapWrapper
implements CypherMapAccess {
    private final Map<String, Object> config;

    public static CypherMapWrapper create(@Nullable Map<String, Object> config) {
        if (config == null) {
            return CypherMapWrapper.empty();
        }
        TreeMap<String, Object> configMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        config.forEach((key, value) -> {
            if (value != null) {
                configMap.put((String)key, value);
            }
        });
        return new CypherMapWrapper(configMap);
    }

    public static CypherMapWrapper empty() {
        return new CypherMapWrapper(Map.of());
    }

    private CypherMapWrapper(Map<String, Object> config) {
        this.config = config;
    }

    @Override
    public boolean containsKey(String key) {
        return this.config.containsKey(key);
    }

    @Override
    public Collection<String> keySet() {
        return Collections.unmodifiableSet(this.config.keySet());
    }

    @Override
    public int getLongAsInt(String key) {
        Object value = this.config.get(key);
        if (value instanceof Long) {
            value = Math.toIntExact((Long)value);
        }
        return CypherMapWrapper.typedValue(key, Integer.class, value);
    }

    @Override
    @NotNull
    public <V> V typedValue(String key, Class<V> expectedType) {
        return CypherMapWrapper.typedValue(key, expectedType, this.config.get(key));
    }

    private static <V> V typedValue(String key, Class<V> expectedType, @Nullable Object value) {
        if (Double.class.isAssignableFrom(expectedType) && value instanceof Number) {
            return expectedType.cast(((Number)value).doubleValue());
        }
        if (expectedType.equals(Integer.class) && value instanceof Long) {
            return expectedType.cast(Math.toIntExact((Long)value));
        }
        if (!expectedType.isInstance(value)) {
            String message = String.format(Locale.ENGLISH, "The value of `%s` must be of type `%s` but was `%s`.", key, expectedType.getSimpleName(), value == null ? "null" : value.getClass().getSimpleName());
            throw new IllegalArgumentException(message);
        }
        return expectedType.cast(value);
    }

    @Override
    public Map<String, Object> toMap() {
        return new HashMap<String, Object>(this.config);
    }

    public CypherMapWrapper withString(String key, String value) {
        return this.withEntry(key, value);
    }

    public CypherMapWrapper withNumber(String key, Number value) {
        return this.withEntry(key, value);
    }

    public CypherMapWrapper withBoolean(String key, Boolean value) {
        return this.withEntry(key, value);
    }

    public CypherMapWrapper withEntry(String key, Object value) {
        Map<String, Object> newMap = this.copyValues();
        newMap.put(key, value);
        return new CypherMapWrapper(newMap);
    }

    public CypherMapWrapper withoutEntry(String key) {
        if (!this.containsKey(key)) {
            return this;
        }
        Map<String, Object> newMap = this.copyValues();
        newMap.remove(key);
        return new CypherMapWrapper(newMap);
    }

    public CypherMapWrapper withoutAny(Collection<String> keys) {
        Map<String, Object> newMap = this.copyValues();
        newMap.keySet().removeAll(keys);
        return new CypherMapWrapper(newMap);
    }

    private Map<String, Object> copyValues() {
        TreeMap<String, Object> copiedMap = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        copiedMap.putAll(this.config);
        return copiedMap;
    }
}

