/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.util.Arrays;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseByteArrayList;
import org.neo4j.gds.collections.LongByteArrayConsumer;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseByteArrayListSon
implements HugeSparseByteArrayList {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private byte[][][] pages;
    private final byte[] defaultValue;

    HugeSparseByteArrayListSon(byte[] defaultValue, long initialCapacity) {
        int numPages = PageUtil.pageIndex(initialCapacity, 12);
        this.pages = new byte[numPages][][];
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        int numPages = this.pages.length;
        return (long)numPages << 12;
    }

    @Override
    public byte[] get(long index) {
        byte[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            byte[] value = page[indexInPage];
            return value == null ? this.defaultValue : value;
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        byte[][] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != null && !Arrays.equals(page[indexInPage], this.defaultValue);
        }
        return false;
    }

    @Override
    public DrainingIterator<byte[][]> drainingIterator() {
        return new DrainingIterator<byte[][]>((PAGE[])this.pages, 4096);
    }

    @Override
    public void forAll(LongByteArrayConsumer consumer) {
        byte[][][] pages = this.pages;
        for (int pageIndex = 0; pageIndex < pages.length; ++pageIndex) {
            byte[][] page = pages[pageIndex];
            if (page == null) continue;
            for (int indexInPage = 0; indexInPage < page.length; ++indexInPage) {
                byte[] value = page[indexInPage];
                if (value != null && Arrays.equals(value, this.defaultValue)) continue;
                long index = (long)pageIndex << 12 | (long)indexInPage;
                consumer.consume(index, value);
            }
        }
    }

    @Override
    public void set(long index, byte[] value) {
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        this.getPage((int)pageIndex)[indexInPage] = value;
    }

    private byte[][] getPage(int pageIndex) {
        byte[][] page;
        if (pageIndex >= this.pages.length) {
            this.grow(pageIndex + 1);
        }
        if ((page = this.pages[pageIndex]) == null) {
            page = this.allocateNewPage(pageIndex);
        }
        return page;
    }

    private void grow(int minNewSize) {
        if (minNewSize <= this.pages.length) {
            return;
        }
        int newSize = HugeArrays.oversizeInt(minNewSize, MemoryUsage.BYTES_OBJECT_REF);
        this.pages = (byte[][][])Arrays.copyOf(this.pages, newSize);
    }

    private byte[][] allocateNewPage(int pageIndex) {
        byte[][] page = new byte[4096][];
        Arrays.fill((Object[])page, this.defaultValue);
        this.pages[pageIndex] = page;
        return page;
    }
}

