/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseDoubleArray;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseDoubleArraySon
implements HugeSparseDoubleArray {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private final long capacity;
    private final double[][] pages;
    private final double defaultValue;

    private HugeSparseDoubleArraySon(long capacity, double[][] pages, double defaultValue) {
        this.capacity = capacity;
        this.pages = pages;
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public double get(long index) {
        double[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            return page[indexInPage];
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        double[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return Double.compare(page[indexInPage], this.defaultValue) != 0;
        }
        return false;
    }

    @Override
    public DrainingIterator<double[]> drainingIterator() {
        return new DrainingIterator<double[]>((PAGE[])this.pages, 4096);
    }

    public static final class GrowingBuilder
    implements HugeSparseDoubleArray.Builder {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(double[].class);
        private final ReentrantLock newPageLock;
        private final double defaultValue;
        private AtomicReferenceArray<double[]> pages;

        GrowingBuilder(double defaultValue, long initialCapacity) {
            int pageCount = PageUtil.pageIndex(initialCapacity, 12);
            this.pages = new AtomicReferenceArray(pageCount);
            this.defaultValue = defaultValue;
            this.newPageLock = new ReentrantLock(true);
        }

        @Override
        public void set(long index, double value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            ARRAY_HANDLE.setVolatile(this.getPage(pageIndex), indexInPage, value);
        }

        @Override
        public HugeSparseDoubleArray build() {
            int numPages = this.pages.length();
            long capacity = (long)numPages << 12;
            double[][] newPages = new double[numPages][];
            Arrays.setAll(newPages, this.pages::get);
            return new HugeSparseDoubleArraySon(capacity, newPages, this.defaultValue);
        }

        @Override
        public boolean setIfAbsent(long index, double value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            double storedValue = ARRAY_HANDLE.compareAndExchange(this.getPage(pageIndex), indexInPage, this.defaultValue, value);
            return Double.compare(storedValue, this.defaultValue) == 0;
        }

        @Override
        public void addTo(long index, double value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            double[] page = this.getPage(pageIndex);
            double expectedCurrentValue = ARRAY_HANDLE.getAcquire(page, indexInPage);
            double newValueToStore;
            double actualCurrentValue;
            while ((actualCurrentValue = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, expectedCurrentValue, newValueToStore = expectedCurrentValue + value)) != expectedCurrentValue) {
                expectedCurrentValue = actualCurrentValue;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow(int newSize) {
            this.newPageLock.lock();
            try {
                if (newSize <= this.pages.length()) {
                    return;
                }
                AtomicReferenceArray<double[]> newPages = new AtomicReferenceArray<double[]>(HugeArrays.oversizeInt(newSize, MemoryUsage.BYTES_OBJECT_REF));
                for (int pageIndex = 0; pageIndex < this.pages.length(); ++pageIndex) {
                    double[] page = this.pages.get(pageIndex);
                    if (page == null) continue;
                    newPages.set(pageIndex, page);
                }
                this.pages = newPages;
            }
            finally {
                this.newPageLock.unlock();
            }
        }

        private double[] getPage(int pageIndex) {
            double[] page;
            if (pageIndex >= this.pages.length()) {
                this.grow(pageIndex + 1);
            }
            if ((page = this.pages.get(pageIndex)) == null) {
                page = this.allocateNewPage(pageIndex);
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private double[] allocateNewPage(int pageIndex) {
            this.newPageLock.lock();
            try {
                double[] page = this.pages.get(pageIndex);
                if (page != null) {
                    double[] dArray = page;
                    return dArray;
                }
                page = new double[4096];
                if (Double.compare(this.defaultValue, 0.0) != 0) {
                    Arrays.fill(page, this.defaultValue);
                }
                this.pages.set(pageIndex, page);
                double[] dArray = page;
                return dArray;
            }
            finally {
                this.newPageLock.unlock();
            }
        }
    }
}

