/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.util.Arrays;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseIntList;
import org.neo4j.gds.collections.LongIntConsumer;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseIntListSon
implements HugeSparseIntList {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private int[][] pages;
    private final int defaultValue;

    HugeSparseIntListSon(int defaultValue, long initialCapacity) {
        int numPages = PageUtil.pageIndex(initialCapacity, 12);
        this.pages = new int[numPages][];
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        int numPages = this.pages.length;
        return (long)numPages << 12;
    }

    @Override
    public int get(long index) {
        int[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            return page[indexInPage];
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        int[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != this.defaultValue;
        }
        return false;
    }

    @Override
    public DrainingIterator<int[]> drainingIterator() {
        return new DrainingIterator<int[]>((PAGE[])this.pages, 4096);
    }

    @Override
    public void forAll(LongIntConsumer consumer) {
        int[][] pages = this.pages;
        for (int pageIndex = 0; pageIndex < pages.length; ++pageIndex) {
            int[] page = pages[pageIndex];
            if (page == null) continue;
            for (int indexInPage = 0; indexInPage < page.length; ++indexInPage) {
                int value = page[indexInPage];
                if (value == this.defaultValue) continue;
                long index = (long)pageIndex << 12 | (long)indexInPage;
                consumer.consume(index, value);
            }
        }
    }

    @Override
    public void set(long index, int value) {
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        this.getPage((int)pageIndex)[indexInPage] = value;
    }

    @Override
    public boolean setIfAbsent(long index, int value) {
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        int[] page = this.getPage(pageIndex);
        int currentValue = page[indexInPage];
        if (currentValue == this.defaultValue) {
            page[indexInPage] = value;
            return true;
        }
        return false;
    }

    @Override
    public void addTo(long index, int value) {
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        int[] page = this.getPage(pageIndex);
        int n = indexInPage;
        page[n] = page[n] + value;
    }

    private int[] getPage(int pageIndex) {
        int[] page;
        if (pageIndex >= this.pages.length) {
            this.grow(pageIndex + 1);
        }
        if ((page = this.pages[pageIndex]) == null) {
            page = this.allocateNewPage(pageIndex);
        }
        return page;
    }

    private void grow(int minNewSize) {
        if (minNewSize <= this.pages.length) {
            return;
        }
        int newSize = HugeArrays.oversizeInt(minNewSize, MemoryUsage.BYTES_OBJECT_REF);
        this.pages = (int[][])Arrays.copyOf(this.pages, newSize);
    }

    private int[] allocateNewPage(int pageIndex) {
        int[] page = new int[4096];
        if (this.defaultValue != 0) {
            Arrays.fill(page, this.defaultValue);
        }
        this.pages[pageIndex] = page;
        return page;
    }
}

