/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseLongArray;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseLongArraySon
implements HugeSparseLongArray {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private final long capacity;
    private final long[][] pages;
    private final long defaultValue;

    private HugeSparseLongArraySon(long capacity, long[][] pages, long defaultValue) {
        this.capacity = capacity;
        this.pages = pages;
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public long get(long index) {
        long[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            return page[indexInPage];
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        long[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != this.defaultValue;
        }
        return false;
    }

    @Override
    public DrainingIterator<long[]> drainingIterator() {
        return new DrainingIterator<long[]>((PAGE[])this.pages, 4096);
    }

    public static final class GrowingBuilder
    implements HugeSparseLongArray.Builder {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(long[].class);
        private final ReentrantLock newPageLock;
        private final long defaultValue;
        private AtomicReferenceArray<long[]> pages;

        GrowingBuilder(long defaultValue, long initialCapacity) {
            int pageCount = PageUtil.pageIndex(initialCapacity, 12);
            this.pages = new AtomicReferenceArray(pageCount);
            this.defaultValue = defaultValue;
            this.newPageLock = new ReentrantLock(true);
        }

        @Override
        public void set(long index, long value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            ARRAY_HANDLE.setVolatile(this.getPage(pageIndex), indexInPage, value);
        }

        @Override
        public HugeSparseLongArray build() {
            int numPages = this.pages.length();
            long capacity = (long)numPages << 12;
            long[][] newPages = new long[numPages][];
            Arrays.setAll(newPages, this.pages::get);
            return new HugeSparseLongArraySon(capacity, newPages, this.defaultValue);
        }

        @Override
        public boolean setIfAbsent(long index, long value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            long storedValue = ARRAY_HANDLE.compareAndExchange(this.getPage(pageIndex), indexInPage, this.defaultValue, value);
            return storedValue == this.defaultValue;
        }

        @Override
        public void addTo(long index, long value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            long[] page = this.getPage(pageIndex);
            long expectedCurrentValue = ARRAY_HANDLE.getAcquire(page, indexInPage);
            long newValueToStore;
            long actualCurrentValue;
            while ((actualCurrentValue = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, expectedCurrentValue, newValueToStore = expectedCurrentValue + value)) != expectedCurrentValue) {
                expectedCurrentValue = actualCurrentValue;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow(int newSize) {
            this.newPageLock.lock();
            try {
                if (newSize <= this.pages.length()) {
                    return;
                }
                AtomicReferenceArray<long[]> newPages = new AtomicReferenceArray<long[]>(HugeArrays.oversizeInt(newSize, MemoryUsage.BYTES_OBJECT_REF));
                for (int pageIndex = 0; pageIndex < this.pages.length(); ++pageIndex) {
                    long[] page = this.pages.get(pageIndex);
                    if (page == null) continue;
                    newPages.set(pageIndex, page);
                }
                this.pages = newPages;
            }
            finally {
                this.newPageLock.unlock();
            }
        }

        private long[] getPage(int pageIndex) {
            long[] page;
            if (pageIndex >= this.pages.length()) {
                this.grow(pageIndex + 1);
            }
            if ((page = this.pages.get(pageIndex)) == null) {
                page = this.allocateNewPage(pageIndex);
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private long[] allocateNewPage(int pageIndex) {
            this.newPageLock.lock();
            try {
                long[] page = this.pages.get(pageIndex);
                if (page != null) {
                    long[] lArray = page;
                    return lArray;
                }
                page = new long[4096];
                if (this.defaultValue != 0L) {
                    Arrays.fill(page, this.defaultValue);
                }
                this.pages.set(pageIndex, page);
                long[] lArray = page;
                return lArray;
            }
            finally {
                this.newPageLock.unlock();
            }
        }
    }
}

