/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.util.Arrays;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseLongList;
import org.neo4j.gds.collections.LongLongConsumer;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseLongListSon
implements HugeSparseLongList {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private long[][] pages;
    private final long defaultValue;

    HugeSparseLongListSon(long defaultValue, long initialCapacity) {
        int numPages = PageUtil.pageIndex(initialCapacity, 12);
        this.pages = new long[numPages][];
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        int numPages = this.pages.length;
        return (long)numPages << 12;
    }

    @Override
    public long get(long index) {
        long[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            return page[indexInPage];
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        long[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != this.defaultValue;
        }
        return false;
    }

    @Override
    public DrainingIterator<long[]> drainingIterator() {
        return new DrainingIterator<long[]>((PAGE[])this.pages, 4096);
    }

    @Override
    public void forAll(LongLongConsumer consumer) {
        long[][] pages = this.pages;
        for (int pageIndex = 0; pageIndex < pages.length; ++pageIndex) {
            long[] page = pages[pageIndex];
            if (page == null) continue;
            for (int indexInPage = 0; indexInPage < page.length; ++indexInPage) {
                long value = page[indexInPage];
                if (value == this.defaultValue) continue;
                long index = (long)pageIndex << 12 | (long)indexInPage;
                consumer.consume(index, value);
            }
        }
    }

    @Override
    public void set(long index, long value) {
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        this.getPage((int)pageIndex)[indexInPage] = value;
    }

    @Override
    public boolean setIfAbsent(long index, long value) {
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        long[] page = this.getPage(pageIndex);
        long currentValue = page[indexInPage];
        if (currentValue == this.defaultValue) {
            page[indexInPage] = value;
            return true;
        }
        return false;
    }

    @Override
    public void addTo(long index, long value) {
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        long[] page = this.getPage(pageIndex);
        int n = indexInPage;
        page[n] = page[n] + value;
    }

    private long[] getPage(int pageIndex) {
        long[] page;
        if (pageIndex >= this.pages.length) {
            this.grow(pageIndex + 1);
        }
        if ((page = this.pages[pageIndex]) == null) {
            page = this.allocateNewPage(pageIndex);
        }
        return page;
    }

    private void grow(int minNewSize) {
        if (minNewSize <= this.pages.length) {
            return;
        }
        int newSize = HugeArrays.oversizeInt(minNewSize, MemoryUsage.BYTES_OBJECT_REF);
        this.pages = (long[][])Arrays.copyOf(this.pages, newSize);
    }

    private long[] allocateNewPage(int pageIndex) {
        long[] page = new long[4096];
        if (this.defaultValue != 0L) {
            Arrays.fill(page, this.defaultValue);
        }
        this.pages[pageIndex] = page;
        return page;
    }
}

