/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.collections;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.util.Arrays;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;
import org.neo4j.gds.collections.DrainingIterator;
import org.neo4j.gds.collections.HugeSparseShortArray;
import org.neo4j.gds.collections.PageUtil;
import org.neo4j.gds.mem.HugeArrays;
import org.neo4j.gds.mem.MemoryUsage;

final class HugeSparseShortArraySon
implements HugeSparseShortArray {
    private static final int PAGE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final int PAGE_MASK = 4095;
    private static final long PAGE_SIZE_IN_BYTES = MemoryUsage.sizeOfLongArray((long)4096L);
    private final long capacity;
    private final short[][] pages;
    private final short defaultValue;

    private HugeSparseShortArraySon(long capacity, short[][] pages, short defaultValue) {
        this.capacity = capacity;
        this.pages = pages;
        this.defaultValue = defaultValue;
    }

    @Override
    public long capacity() {
        return this.capacity;
    }

    @Override
    public short get(long index) {
        short[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        int indexInPage = PageUtil.indexInPage(index, 4095);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            return page[indexInPage];
        }
        return this.defaultValue;
    }

    @Override
    public boolean contains(long index) {
        short[] page;
        int pageIndex = PageUtil.pageIndex(index, 12);
        if (pageIndex < this.pages.length && (page = this.pages[pageIndex]) != null) {
            int indexInPage = PageUtil.indexInPage(index, 4095);
            return page[indexInPage] != this.defaultValue;
        }
        return false;
    }

    @Override
    public DrainingIterator<short[]> drainingIterator() {
        return new DrainingIterator<short[]>((PAGE[])this.pages, 4096);
    }

    public static final class GrowingBuilder
    implements HugeSparseShortArray.Builder {
        private static final VarHandle ARRAY_HANDLE = MethodHandles.arrayElementVarHandle(short[].class);
        private final ReentrantLock newPageLock;
        private final short defaultValue;
        private AtomicReferenceArray<short[]> pages;

        GrowingBuilder(short defaultValue, long initialCapacity) {
            int pageCount = PageUtil.pageIndex(initialCapacity, 12);
            this.pages = new AtomicReferenceArray(pageCount);
            this.defaultValue = defaultValue;
            this.newPageLock = new ReentrantLock(true);
        }

        @Override
        public void set(long index, short value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            ARRAY_HANDLE.setVolatile(this.getPage(pageIndex), indexInPage, value);
        }

        @Override
        public HugeSparseShortArray build() {
            int numPages = this.pages.length();
            long capacity = (long)numPages << 12;
            short[][] newPages = new short[numPages][];
            Arrays.setAll(newPages, this.pages::get);
            return new HugeSparseShortArraySon(capacity, newPages, this.defaultValue);
        }

        @Override
        public boolean setIfAbsent(long index, short value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            short storedValue = ARRAY_HANDLE.compareAndExchange(this.getPage(pageIndex), indexInPage, this.defaultValue, value);
            return storedValue == this.defaultValue;
        }

        @Override
        public void addTo(long index, short value) {
            int pageIndex = PageUtil.pageIndex(index, 12);
            int indexInPage = PageUtil.indexInPage(index, 4095);
            short[] page = this.getPage(pageIndex);
            short expectedCurrentValue = ARRAY_HANDLE.getAcquire(page, indexInPage);
            short newValueToStore;
            short actualCurrentValue;
            while ((actualCurrentValue = ARRAY_HANDLE.compareAndExchangeRelease(page, indexInPage, expectedCurrentValue, newValueToStore = (short)(expectedCurrentValue + value))) != expectedCurrentValue) {
                expectedCurrentValue = actualCurrentValue;
            }
            return;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void grow(int newSize) {
            this.newPageLock.lock();
            try {
                if (newSize <= this.pages.length()) {
                    return;
                }
                AtomicReferenceArray<short[]> newPages = new AtomicReferenceArray<short[]>(HugeArrays.oversizeInt(newSize, MemoryUsage.BYTES_OBJECT_REF));
                for (int pageIndex = 0; pageIndex < this.pages.length(); ++pageIndex) {
                    short[] page = this.pages.get(pageIndex);
                    if (page == null) continue;
                    newPages.set(pageIndex, page);
                }
                this.pages = newPages;
            }
            finally {
                this.newPageLock.unlock();
            }
        }

        private short[] getPage(int pageIndex) {
            short[] page;
            if (pageIndex >= this.pages.length()) {
                this.grow(pageIndex + 1);
            }
            if ((page = this.pages.get(pageIndex)) == null) {
                page = this.allocateNewPage(pageIndex);
            }
            return page;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private short[] allocateNewPage(int pageIndex) {
            this.newPageLock.lock();
            try {
                short[] page = this.pages.get(pageIndex);
                if (page != null) {
                    short[] sArray = page;
                    return sArray;
                }
                page = new short[4096];
                if (this.defaultValue != 0) {
                    Arrays.fill(page, this.defaultValue);
                }
                this.pages.set(pageIndex, page);
                short[] sArray = page;
                return sArray;
            }
            finally {
                this.newPageLock.unlock();
            }
        }
    }
}

