/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.TypeName;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.immutables.value.Value;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.proc.ImmutableMember;
import org.neo4j.gds.proc.ImmutableSpec;

final class ConfigParser {
    private final Messager messager;
    private final Elements elementUtils;
    private final Types typeUtils;

    ConfigParser(Messager messager, Elements elementUtils, Types typeUtils) {
        this.messager = messager;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
    }

    Spec process(TypeMirror configType) {
        TypeElement configElement = MoreTypes.asTypeElement((TypeMirror)configType);
        ImmutableSpec.Builder config = ImmutableSpec.builder().root(configElement).rootType(configType);
        this.process(config, new HashSet<String>(), configElement, configElement);
        return config.build();
    }

    private void process(ImmutableSpec.Builder output, Set<String> seen, TypeElement configElement, TypeElement root) {
        List<Member> members = ElementFilter.methodsIn(configElement.getEnclosedElements()).stream().map(m -> this.validateMember((Collection<String>)seen, root, (ExecutableElement)m)).flatMap(Optional::stream).map(this::validateParameters).flatMap(Optional::stream).collect(Collectors.toList());
        if (members.stream().filter(Member::graphStoreValidation).count() > 1L) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ConfigParser]: Only one GraphStoreValidation-annotated method allowed");
            return;
        }
        members.forEach(output::addMember);
        for (TypeMirror typeMirror : configElement.getInterfaces()) {
            this.process(output, seen, MoreTypes.asTypeElement((TypeMirror)typeMirror), root);
        }
    }

    private Optional<Member> validateParameters(Member member) {
        ExecutableElement method = member.method();
        if (member.graphStoreValidation() || member.graphStoreValidationCheck()) {
            if (method.getParameters().size() != 3) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "[ConfigParser]: GraphStoreValidation and Checks must accept 3 parameters", method);
                return Optional.empty();
            }
        } else if (!method.getParameters().isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ConfigParser]: Method may not have any parameters", method);
            return Optional.empty();
        }
        return Optional.of(member);
    }

    private Optional<Member> validateMember(Collection<String> seen, TypeElement root, ExecutableElement method) {
        if (MoreElements.isAnnotationPresent((Element)method, Configuration.Ignore.class)) {
            seen.add(method.getSimpleName().toString());
            return Optional.empty();
        }
        if (!seen.add(method.getSimpleName().toString()) || method.getModifiers().contains((Object)Modifier.STATIC)) {
            return Optional.empty();
        }
        if (!method.getTypeParameters().isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method may not have any type parameters", method);
            return Optional.empty();
        }
        if (!method.getThrownTypes().isEmpty()) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Method may not declare any exceptions to be thrown", method);
            return Optional.empty();
        }
        ImmutableMember.Builder memberBuilder = ImmutableMember.builder().owner(root).method(method);
        this.validateCollectKeys(method, memberBuilder);
        this.validateToMap(method, memberBuilder);
        memberBuilder.validatesIntegerRange(MoreElements.isAnnotationPresent((Element)method, Configuration.IntegerRange.class));
        memberBuilder.validatesLongRange(MoreElements.isAnnotationPresent((Element)method, Configuration.LongRange.class));
        memberBuilder.validatesDoubleRange(MoreElements.isAnnotationPresent((Element)method, Configuration.DoubleRange.class));
        this.validateValueCheck(method, memberBuilder);
        this.validateGraphStoreValidationAndChecks(method, memberBuilder);
        Configuration.Key key = method.getAnnotation(Configuration.Key.class);
        if (key != null) {
            if (MoreElements.isAnnotationPresent((Element)method, Configuration.Parameter.class)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(Locale.ENGLISH, "The `@%s` annotation cannot be used together with the `@%s` annotation", Configuration.Parameter.class.getSimpleName(), Configuration.Key.class.getSimpleName()), method);
                return Optional.empty();
            }
            memberBuilder.lookupKey(key.value());
        }
        try {
            return Optional.of(memberBuilder.build());
        }
        catch (InvalidMemberException invalid) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, invalid.getMessage(), method);
            return Optional.empty();
        }
    }

    private void validateToMap(ExecutableElement method, ImmutableMember.Builder memberBuilder) {
        if (MoreElements.isAnnotationPresent((Element)method, Configuration.ToMap.class)) {
            TypeElement mapType = this.elementUtils.getTypeElement(Map.class.getTypeName());
            TypeMirror stringType = this.elementUtils.getTypeElement(String.class.getTypeName()).asType();
            TypeMirror objectType = this.elementUtils.getTypeElement(Object.class.getTypeName()).asType();
            DeclaredType mapOfStringToObjectType = this.typeUtils.getDeclaredType(mapType, stringType, objectType);
            if (!this.typeUtils.isSameType(method.getReturnType(), mapOfStringToObjectType)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Method must return Map<String, Object>", method);
            }
            memberBuilder.toMap(true);
        }
    }

    private void validateCollectKeys(ExecutableElement method, ImmutableMember.Builder memberBuilder) {
        if (MoreElements.isAnnotationPresent((Element)method, Configuration.CollectKeys.class)) {
            TypeElement collectionType = this.elementUtils.getTypeElement(Collection.class.getTypeName());
            TypeMirror stringType = this.elementUtils.getTypeElement(String.class.getTypeName()).asType();
            DeclaredType collectionOfStringType = this.typeUtils.getDeclaredType(collectionType, stringType);
            if (!this.typeUtils.isSameType(method.getReturnType(), collectionOfStringType)) {
                this.messager.printMessage(Diagnostic.Kind.ERROR, "Method must return Collection<String>", method);
            }
            memberBuilder.collectsKeys(true);
        }
    }

    private void validateGraphStoreValidationAndChecks(ExecutableElement method, ImmutableMember.Builder memberBuilder) {
        if (MoreElements.isAnnotationPresent((Element)method, Configuration.GraphStoreValidation.class)) {
            this.requireVoidReturnType(method);
            this.requireDefaultModifier(method);
            memberBuilder.graphStoreValidation(true);
        }
        if (MoreElements.isAnnotationPresent((Element)method, Configuration.GraphStoreValidationCheck.class)) {
            this.requireVoidReturnType(method);
            this.requireDefaultModifier(method);
            memberBuilder.graphStoreValidationCheck(true);
        }
    }

    private void requireVoidReturnType(ExecutableElement method) {
        if (!this.typeUtils.isSameType(method.getReturnType(), this.typeUtils.getNoType(TypeKind.VOID))) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ConfigParser]: GraphStoreValidation and Checks must return void", method);
        }
    }

    private void requireDefaultModifier(ExecutableElement method) {
        if (!method.getModifiers().contains((Object)Modifier.DEFAULT)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "[ConfigParser]: GraphStoreValidation and Checks must be declared default (cannot be abstract)", method);
        }
    }

    private void validateValueCheck(ExecutableElement method, ImmutableMember.Builder memberBuilder) {
        if (MoreElements.isAnnotationPresent((Element)method, Value.Check.class)) {
            if (method.getReturnType().getKind() == TypeKind.VOID) {
                memberBuilder.validates(true);
            } else {
                memberBuilder.normalizes(true);
            }
        }
    }

    private static final class InvalidMemberException
    extends RuntimeException {
        InvalidMemberException(String message) {
            super(message);
        }
    }

    @ValueClass
    static abstract class Member {
        Member() {
        }

        public abstract TypeElement owner();

        public abstract ExecutableElement method();

        @Value.Default
        public String lookupKey() {
            return this.methodName();
        }

        @Value.Default
        public boolean collectsKeys() {
            return false;
        }

        @Value.Default
        public boolean toMap() {
            return false;
        }

        @Value.Default
        public boolean validatesIntegerRange() {
            return false;
        }

        @Value.Default
        public boolean validatesLongRange() {
            return false;
        }

        @Value.Default
        public boolean validatesDoubleRange() {
            return false;
        }

        @Value.Default
        public boolean validates() {
            return false;
        }

        @Value.Default
        public boolean graphStoreValidation() {
            return false;
        }

        @Value.Default
        public boolean graphStoreValidationCheck() {
            return false;
        }

        @Value.Default
        public boolean normalizes() {
            return false;
        }

        final boolean isConfigValue() {
            return !this.collectsKeys() && !this.toMap() && !this.validates() && !this.normalizes() && !this.graphStoreValidation() && !this.graphStoreValidationCheck();
        }

        final boolean isConfigMapEntry() {
            return this.isConfigValue() && !MoreElements.isAnnotationPresent((Element)this.method(), Configuration.Parameter.class);
        }

        final boolean isConfigParameter() {
            return this.isConfigValue() && MoreElements.isAnnotationPresent((Element)this.method(), Configuration.Parameter.class);
        }

        @Value.Derived
        public String methodName() {
            return this.method().getSimpleName().toString();
        }

        public Set<AnnotationMirror> annotations(Class<? extends Annotation> annotationType) {
            return Stream.concat(this.method().getReturnType().getAnnotationMirrors().stream(), this.method().getAnnotationMirrors().stream()).filter(am -> MoreElements.asType((Element)am.getAnnotationType().asElement()).getQualifiedName().contentEquals(annotationType.getName())).collect(Collectors.toCollection(() -> new TreeSet<AnnotationMirror>(Comparator.comparing(am -> MoreElements.asType((Element)am.getAnnotationType().asElement()).getQualifiedName().toString()))));
        }

        public TypeName typeSpecWithAnnotation(Class<? extends Annotation> annotationType) {
            Set<AnnotationMirror> annotations = this.annotations(annotationType);
            TypeName typeName = TypeName.get((TypeMirror)this.method().getReturnType());
            List annotationsToAddToType = annotations.stream().map(AnnotationSpec::get).collect(Collectors.toList());
            return typeName.annotated(annotationsToAddToType);
        }

        @Value.Check
        final Member normalize() {
            String trimmedKey = this.lookupKey().trim();
            if (trimmedKey.isEmpty()) {
                throw new InvalidMemberException("The key must not be empty");
            }
            if (this.collectsKeys() && (this.validates() || this.normalizes())) {
                throw new InvalidMemberException(String.format(Locale.ENGLISH, "Cannot combine @%s with @%s", Configuration.CollectKeys.class.getSimpleName(), Value.Check.class.getSimpleName()));
            }
            if (this.toMap() && (this.validates() || this.normalizes())) {
                throw new InvalidMemberException(String.format(Locale.ENGLISH, "Cannot combine @%s with @%s", Configuration.ToMap.class.getSimpleName(), Value.Check.class.getSimpleName()));
            }
            if (trimmedKey.equals(this.lookupKey())) {
                return this;
            }
            return ((ImmutableMember)this).withLookupKey(trimmedKey);
        }
    }

    @ValueClass
    static interface Spec {
        public TypeElement root();

        public TypeMirror rootType();

        public List<Member> members();
    }
}

