/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.auto.common.BasicAnnotationProcessor;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.squareup.javapoet.JavaFile;
import java.io.IOException;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Name;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.proc.ConfigParser;
import org.neo4j.gds.proc.GenerateConfiguration;

public final class ConfigurationProcessingStep
implements BasicAnnotationProcessor.Step {
    private static final Class<Configuration> ANNOTATION_CLASS = Configuration.class;
    private static final String CONFIG_CLASS_SUFFIX = "Impl";
    private final Messager messager;
    private final Filer filer;
    private final ConfigParser configParser;
    private final GenerateConfiguration generateConfiguration;

    ConfigurationProcessingStep(Messager messager, Filer filer, ConfigParser configParser, GenerateConfiguration generateConfiguration) {
        this.messager = messager;
        this.filer = filer;
        this.configParser = configParser;
        this.generateConfiguration = generateConfiguration;
    }

    public Set<String> annotations() {
        return Set.of(ANNOTATION_CLASS.getCanonicalName());
    }

    public Set<? extends Element> process(ImmutableSetMultimap<String, Element> elementsByAnnotation) {
        ImmutableSet elements = elementsByAnnotation.get((Object)ANNOTATION_CLASS.getCanonicalName());
        ImmutableSet.Builder elementsToRetry = ImmutableSet.builder();
        for (Element element : elements) {
            ProcessResult result = this.process(element);
            if (result != ProcessResult.RETRY) continue;
            elementsToRetry.add((Object)element);
        }
        return elementsToRetry.build();
    }

    private ProcessResult process(Element element) {
        if (element.getKind() != ElementKind.INTERFACE) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "The annotated configuration must be an interface.", element);
            return ProcessResult.INVALID;
        }
        ConfigParser.Spec configSpec = this.configParser.process(element.asType());
        if (!this.validClassName(element, configSpec)) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Name of generated class must be different from name of annotated class.", element);
            return ProcessResult.INVALID;
        }
        JavaFile generatedConfig = this.generateConfiguration.generateConfig(configSpec, this.configClassName(element, configSpec));
        try {
            generatedConfig.writeTo(this.filer);
            return ProcessResult.PROCESSED;
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Could not write config file: " + e.getMessage(), element);
            return ProcessResult.RETRY;
        }
    }

    private boolean validClassName(Element element, ConfigParser.Spec configSpec) {
        String nameOfClassToGenerate = element.getAnnotation(ANNOTATION_CLASS).value();
        Name nameOfAnnotatedClass = configSpec.root().getSimpleName();
        return !nameOfAnnotatedClass.contentEquals(nameOfClassToGenerate);
    }

    @NotNull
    private String configClassName(Element element, ConfigParser.Spec configSpec) {
        Name nameOfAnnotatedClass = configSpec.root().getSimpleName();
        Configuration configuration = element.getAnnotation(ANNOTATION_CLASS);
        return configuration.value().isBlank() ? nameOfAnnotatedClass + CONFIG_CLASS_SUFFIX : configuration.value();
    }

    static enum ProcessResult {
        PROCESSED,
        INVALID,
        RETRY;

    }
}

