/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.auto.common.GeneratedAnnotationSpecs;
import com.google.auto.common.MoreElements;
import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.processing.Messager;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.proc.ConfigParser;
import org.neo4j.gds.proc.ConfigurationProcessor;
import org.neo4j.gds.proc.GenerateConfigurationBuilder;
import org.neo4j.gds.proc.GenerateConfigurationMethods;
import org.neo4j.gds.proc.ImmutableFieldDefinitions;
import org.neo4j.gds.proc.ImmutableInvalidCandidate;
import org.neo4j.gds.proc.ImmutableMemberDefinition;

final class GenerateConfiguration {
    private static final String CONFIG_VAR = "config";
    private static final String INSTANCE_VAR = "instance";
    private static final AnnotationSpec NULLABLE = AnnotationSpec.builder(Nullable.class).build();
    private static final AnnotationSpec NOT_NULL = AnnotationSpec.builder(NotNull.class).build();
    private final Messager messager;
    private final Elements elementUtils;
    private final Types typeUtils;
    private final SourceVersion sourceVersion;

    GenerateConfiguration(Messager messager, Elements elementUtils, Types typeUtils, SourceVersion sourceVersion) {
        this.messager = messager;
        this.elementUtils = elementUtils;
        this.typeUtils = typeUtils;
        this.sourceVersion = sourceVersion;
    }

    JavaFile generateConfig(ConfigParser.Spec config, String className) {
        PackageElement rootPackage = this.elementUtils.getPackageOf(config.root());
        String packageName = rootPackage.getQualifiedName().toString();
        TypeSpec typeSpec = this.process(config, packageName, className);
        return JavaFile.builder((String)packageName, (TypeSpec)typeSpec).indent("    ").skipJavaLangImports(true).build();
    }

    private TypeSpec process(ConfigParser.Spec config, String packageName, String generatedClassName) {
        TypeSpec.Builder builder = this.classBuilder(config, packageName, generatedClassName);
        FieldDefinitions fieldDefinitions = GenerateConfiguration.defineFields(config);
        builder.addFields(fieldDefinitions.fields());
        String configParameterName = fieldDefinitions.names().newName(CONFIG_VAR, (Object)CONFIG_VAR);
        List<MemberDefinition> implMembers = config.members().stream().flatMap(parserMember -> this.memberDefinition(fieldDefinitions.names(), (ConfigParser.Member)parserMember).stream()).collect(Collectors.toList());
        Stream<String> validationMethods = config.members().stream().filter(ConfigParser.Member::validates).map(ConfigParser.Member::methodName);
        MethodSpec constructor = this.defineConstructor(implMembers, validationMethods, fieldDefinitions.names());
        Optional<MethodSpec> factory = this.defineFactory(config, generatedClassName, constructor, fieldDefinitions.names());
        if (factory.isPresent()) {
            MethodSpec privateConstructor = MethodSpec.constructorBuilder().addAnnotations((Iterable)constructor.annotations).addParameters((Iterable)constructor.parameters).addCode(constructor.code).addModifiers(new Modifier[]{Modifier.PRIVATE}).build();
            builder.addMethod(privateConstructor);
            builder.addMethod(factory.get());
        } else {
            builder.addMethod(constructor);
        }
        ClassName builderClassName = ClassName.get((String)packageName, (String)(generatedClassName + ".Builder"), (String[])new String[0]);
        TypeSpec configBuilderClass = GenerateConfigurationBuilder.defineConfigBuilder(TypeName.get((TypeMirror)config.rootType()), implMembers, builderClassName, generatedClassName, constructor.parameters, configParameterName, factory);
        MethodSpec builderFactoryMethod = MethodSpec.methodBuilder((String)"builder").addModifiers(new Modifier[]{Modifier.STATIC, Modifier.PUBLIC}).addStatement("return new $T()", new Object[]{builderClassName}).returns((TypeName)builderClassName).build();
        return builder.addMethods(GenerateConfigurationMethods.defineMemberMethods(config, fieldDefinitions.names())).addMethod(builderFactoryMethod).addType(configBuilderClass).build();
    }

    private TypeSpec.Builder classBuilder(ConfigParser.Spec config, String packageName, String generatedClassName) {
        TypeSpec.Builder classBuilder = TypeSpec.classBuilder((ClassName)ClassName.get((String)packageName, (String)generatedClassName, (String[])new String[0])).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.FINAL}).addOriginatingElement((Element)config.root()).addSuperinterface(TypeName.get((TypeMirror)config.rootType()));
        GeneratedAnnotationSpecs.generatedAnnotationSpec((Elements)this.elementUtils, (SourceVersion)this.sourceVersion, ConfigurationProcessor.class).ifPresent(arg_0 -> ((TypeSpec.Builder)classBuilder).addAnnotation(arg_0));
        return classBuilder;
    }

    private static FieldDefinitions defineFields(ConfigParser.Spec config) {
        NameAllocator names = new NameAllocator();
        ImmutableFieldDefinitions.Builder builder = ImmutableFieldDefinitions.builder().names(names);
        config.members().stream().filter(ConfigParser.Member::isConfigValue).map(member -> FieldSpec.builder((TypeName)member.typeSpecWithAnnotation(Nullable.class), (String)names.newName(member.methodName(), member), (Modifier[])new Modifier[]{Modifier.PRIVATE}).build()).forEach(builder::addField);
        return builder.build();
    }

    private MethodSpec defineConstructor(List<MemberDefinition> implMembers, Stream<String> validationMethods, NameAllocator names) {
        MethodSpec.Builder constructorMethodBuilder = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC});
        boolean requiredMapParameter = false;
        String errorsVarName = names.newName("errors");
        if (!implMembers.isEmpty()) {
            constructorMethodBuilder.addStatement("$1T<$2T> $3N = new $1T<>()", new Object[]{ArrayList.class, IllegalArgumentException.class, errorsVarName});
        }
        for (MemberDefinition implMember : implMembers) {
            ConfigParser.Member parsedMember = implMember.member();
            if (parsedMember.isConfigMapEntry()) {
                requiredMapParameter = true;
                this.addConfigFieldToConstructor(constructorMethodBuilder, implMember, errorsVarName);
                continue;
            }
            this.addParameterToConstructor(constructorMethodBuilder, implMember, errorsVarName);
        }
        validationMethods.forEach(method -> this.catchValidationError(constructorMethodBuilder, errorsVarName, builder -> builder.addStatement("$N()", new Object[]{method})));
        if (!implMembers.isEmpty()) {
            this.combineCollectedErrors(names, constructorMethodBuilder, errorsVarName);
        }
        if (requiredMapParameter) {
            constructorMethodBuilder.addParameter(TypeName.get(CypherMapWrapper.class).annotated(new AnnotationSpec[]{NOT_NULL}), names.get((Object)CONFIG_VAR), new Modifier[0]);
        }
        return constructorMethodBuilder.build();
    }

    private void combineCollectedErrors(NameAllocator names, MethodSpec.Builder configMapConstructor, String errorsVarName) {
        String combinedErrorMsgVarName = names.newName("combinedErrorMsg");
        String combinedErrorVarName = names.newName("combinedError");
        configMapConstructor.beginControlFlow("if(!$N.isEmpty())", new Object[]{errorsVarName}).beginControlFlow("if($N.size() == $L)", new Object[]{errorsVarName, 1}).addStatement("throw $N.get($L)", new Object[]{errorsVarName, 0}).nextControlFlow("else", new Object[0]).addStatement("$1T $2N = $3N.stream().map($4T::getMessage).collect($5T.joining(System.lineSeparator() + $6S, $7S + System.lineSeparator() + $6S, $8S))", new Object[]{String.class, combinedErrorMsgVarName, errorsVarName, IllegalArgumentException.class, Collectors.class, "\t\t\t\t", "Multiple errors in configuration arguments:", ""}).addStatement("$1T $2N = new $1T($3N)", new Object[]{IllegalArgumentException.class, combinedErrorVarName, combinedErrorMsgVarName}).addStatement("$1N.forEach($2N -> $3N.addSuppressed($2N))", new Object[]{errorsVarName, names.newName("error"), combinedErrorVarName}).addStatement("throw $N", new Object[]{combinedErrorVarName}).endControlFlow().endControlFlow();
    }

    private void catchAndPropagateIllegalArgumentError(MethodSpec.Builder builder, String errorVarName, UnaryOperator<MethodSpec.Builder> statementFunc) {
        builder.beginControlFlow("try", new Object[0]);
        statementFunc.apply(builder);
        builder.nextControlFlow("catch ($T e)", new Object[]{IllegalArgumentException.class}).addStatement("$N.add(e)", new Object[]{errorVarName}).endControlFlow();
    }

    private void catchValidationError(MethodSpec.Builder builder, String errorVarName, UnaryOperator<MethodSpec.Builder> statementFunc) {
        builder.beginControlFlow("try", new Object[0]);
        statementFunc.apply(builder);
        builder.nextControlFlow("catch ($T e)", new Object[]{IllegalArgumentException.class}).addStatement("$N.add(e)", new Object[]{errorVarName}).nextControlFlow("catch ($T e)", new Object[]{NullPointerException.class}).endControlFlow();
    }

    private Optional<MethodSpec> defineFactory(ConfigParser.Spec config, String generatedClassName, MethodSpec constructor, NameAllocator names) {
        List normalizers = config.members().stream().filter(ConfigParser.Member::normalizes).collect(Collectors.toList());
        if (normalizers.isEmpty()) {
            return Optional.empty();
        }
        CodeBlock constructorArgs = (CodeBlock)constructor.parameters.stream().map(param -> CodeBlock.of((String)"$N", (Object[])new Object[]{param})).collect(CodeBlock.joining((String)", "));
        String instanceVarName = names.newName(INSTANCE_VAR, (Object)INSTANCE_VAR);
        TypeName interfaceType = TypeName.get((TypeMirror)config.rootType());
        MethodSpec.Builder factory = MethodSpec.methodBuilder((String)"of").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns(interfaceType).addParameters((Iterable)constructor.parameters).addStatement("$T $N = new $L($L)", new Object[]{interfaceType, instanceVarName, generatedClassName, constructorArgs});
        for (ConfigParser.Member member : normalizers) {
            factory.addStatement("$1N = $1N.$2N()", new Object[]{instanceVarName, member.methodName()});
        }
        return Optional.of(factory.addStatement("return $N", new Object[]{instanceVarName}).build());
    }

    private void addConfigFieldToConstructor(MethodSpec.Builder constructor, MemberDefinition definition, String errorsVarName) {
        CodeBlock.Builder code = CodeBlock.builder().add("$N.$L$L($S", new Object[]{definition.configParamName(), definition.methodPrefix(), definition.methodName(), definition.configKey()});
        definition.defaultProvider().ifPresent(d -> code.add(", $L", new Object[]{d}));
        definition.expectedType().ifPresent(t -> code.add(", $L", new Object[]{t}));
        CodeBlock codeBlock = code.add(")", new Object[0]).build();
        for (UnaryOperator<CodeBlock> converter : definition.converters()) {
            codeBlock = (CodeBlock)converter.apply(codeBlock);
        }
        TypeMirror fieldType = definition.fieldType();
        if (fieldType.getKind() == TypeKind.DECLARED) {
            boolean isNullable;
            boolean bl = isNullable = !definition.member().annotations(Nullable.class).isEmpty();
            if (!isNullable) {
                codeBlock = CodeBlock.of((String)"$T.failOnNull($S, $L)", (Object[])new Object[]{CypherMapWrapper.class, definition.configKey(), codeBlock});
            }
        }
        CodeBlock.Builder fieldCodeBuilder = CodeBlock.builder().addStatement("this.$N = $L", new Object[]{definition.fieldName(), codeBlock});
        this.addValidationCode(definition, fieldCodeBuilder);
        this.catchAndPropagateIllegalArgumentError(constructor, errorsVarName, builder -> builder.addCode(fieldCodeBuilder.build()));
    }

    private void addValidationCode(MemberDefinition definition, CodeBlock.Builder fieldCodeBuilder) {
        Configuration.IntegerRange range;
        Consumer<CodeBlock> validationConsumer = arg_0 -> ((CodeBlock.Builder)fieldCodeBuilder).addStatement(arg_0);
        if (MoreTypes.isTypeOf(Optional.class, (TypeMirror)definition.fieldType())) {
            validationConsumer = validatorCode -> fieldCodeBuilder.addStatement("$1L.ifPresent($1L -> $2L)", new Object[]{definition.fieldName(), validatorCode});
        } else if (MoreTypes.isTypeOf(List.class, (TypeMirror)definition.fieldType())) {
            validationConsumer = validatorCode -> fieldCodeBuilder.addStatement("this.$1N.forEach($1N -> $2L)", new Object[]{definition.fieldName(), validatorCode});
        }
        if (definition.member().validatesIntegerRange()) {
            range = definition.member().method().getAnnotation(Configuration.IntegerRange.class);
            validationConsumer.accept(CodeBlock.of((String)"$T.validateIntegerRange($S, $L, $L, $L, $L, $L)", (Object[])new Object[]{CypherMapWrapper.class, definition.configKey(), definition.fieldName(), this.elementUtils.getConstantExpression(range.min()), this.elementUtils.getConstantExpression(range.max()), this.elementUtils.getConstantExpression(range.minInclusive()), this.elementUtils.getConstantExpression(range.maxInclusive())}));
        }
        if (definition.member().validatesLongRange()) {
            range = definition.member().method().getAnnotation(Configuration.LongRange.class);
            validationConsumer.accept(CodeBlock.of((String)"$T.validateLongRange($S, $L, $L, $L, $L, $L)", (Object[])new Object[]{CypherMapWrapper.class, definition.configKey(), definition.fieldName(), this.elementUtils.getConstantExpression(range.min()), this.elementUtils.getConstantExpression(range.max()), this.elementUtils.getConstantExpression(range.minInclusive()), this.elementUtils.getConstantExpression(range.maxInclusive())}));
        }
        if (definition.member().validatesDoubleRange()) {
            range = definition.member().method().getAnnotation(Configuration.DoubleRange.class);
            validationConsumer.accept(CodeBlock.of((String)"$T.validateDoubleRange($S, $L, $L, $L, $L, $L)", (Object[])new Object[]{CypherMapWrapper.class, definition.configKey(), definition.fieldName(), this.elementUtils.getConstantExpression(range.min()), this.elementUtils.getConstantExpression(range.max()), this.elementUtils.getConstantExpression(range.minInclusive()), this.elementUtils.getConstantExpression(range.maxInclusive())}));
        }
    }

    private void addParameterToConstructor(MethodSpec.Builder constructor, MemberDefinition definition, String errorsVarName) {
        CodeBlock valueProducer;
        TypeName paramType = TypeName.get((TypeMirror)definition.parameterType());
        if (definition.parameterType().getKind() == TypeKind.DECLARED) {
            if (definition.member().method().getAnnotation(Configuration.Parameter.class).acceptNull()) {
                paramType = paramType.annotated(new AnnotationSpec[]{NULLABLE});
                valueProducer = CodeBlock.of((String)"$N", (Object[])new Object[]{definition.fieldName()});
            } else {
                paramType = paramType.annotated(new AnnotationSpec[]{NOT_NULL});
                valueProducer = CodeBlock.of((String)"$T.failOnNull($S, $N)", (Object[])new Object[]{CypherMapWrapper.class, definition.configKey(), definition.fieldName()});
            }
        } else {
            valueProducer = CodeBlock.of((String)"$N", (Object[])new Object[]{definition.fieldName()});
        }
        for (UnaryOperator<CodeBlock> converter : definition.converters()) {
            valueProducer = (CodeBlock)converter.apply(valueProducer);
        }
        CodeBlock finalValueProducer = valueProducer;
        constructor.addParameter(paramType, definition.fieldName(), new Modifier[0]);
        this.catchAndPropagateIllegalArgumentError(constructor, errorsVarName, builder -> builder.addStatement("this.$N = $L", new Object[]{definition.fieldName(), finalValueProducer}));
    }

    private Optional<MemberDefinition> memberDefinition(NameAllocator names, ConfigParser.Member member) {
        if (!member.isConfigValue()) {
            return Optional.empty();
        }
        ExecutableElement method = member.method();
        TypeMirror targetType = method.getReturnType();
        Configuration.ConvertWith convertWith = method.getAnnotation(Configuration.ConvertWith.class);
        if (convertWith == null) {
            return this.memberDefinition(names, member, targetType);
        }
        String converter = convertWith.value().trim();
        if (converter.isEmpty()) {
            return this.converterError(method, "Empty conversion method is not allowed.", new Object[0]);
        }
        if (!converter.contains("#")) {
            return this.memberDefinition(names, member, targetType, MoreElements.asType((Element)method.getEnclosingElement()), converter, true);
        }
        String[] nameParts = converter.split(Pattern.quote("#"), 2);
        String methodName = nameParts[1];
        if (methodName.isEmpty() || methodName.contains("#")) {
            return this.converterError(method, "[%s] is not a valid fully qualified method name: it must start with a fully qualified class name followed by a '#' and then the method name.", converter);
        }
        String className = nameParts[0];
        TypeElement classElement = this.elementUtils.getTypeElement(className);
        if (classElement == null) {
            return this.converterError(method, "[%s] is not a valid fully qualified method name: The class [%s] cannot be found.", converter, className);
        }
        return this.memberDefinition(names, member, targetType, classElement, methodName, false);
    }

    private Optional<MemberDefinition> memberDefinition(NameAllocator names, ConfigParser.Member member, TypeMirror targetType, TypeElement classElement, CharSequence methodName, boolean scanInheritance) {
        String converter = member.method().getAnnotation(Configuration.ConvertWith.class).value();
        ArrayList<ExecutableElement> validCandidates = new ArrayList<ExecutableElement>();
        ArrayList<InvalidCandidate> invalidCandidates = new ArrayList<InvalidCandidate>();
        ArrayDeque<TypeElement> classesToSearch = new ArrayDeque<TypeElement>();
        classesToSearch.addLast(classElement);
        do {
            TypeElement currentClass;
            if ((currentClass = (TypeElement)classesToSearch.pollFirst()) == null) {
                return this.converterError(classElement, "Inherited interface was null, this could be a bug in the JDK.", new Object[0]);
            }
            validCandidates.clear();
            for (ExecutableElement executableElement : ElementFilter.methodsIn(currentClass.getEnclosedElements())) {
                if (!executableElement.getSimpleName().contentEquals(methodName)) continue;
                int sizeBeforeValidation = invalidCandidates.size();
                this.validateCandidateModifiers(targetType, invalidCandidates, executableElement, executableElement.getModifiers());
                if (invalidCandidates.size() != sizeBeforeValidation) continue;
                validCandidates.add(executableElement);
            }
            if (validCandidates.size() > 1) {
                for (ExecutableElement executableElement : validCandidates) {
                    this.error(String.format(Locale.ENGLISH, "Method is ambiguous and a possible candidate for [%s].", converter), executableElement);
                }
                return this.converterError(member.method(), "Multiple possible candidates found: %s.", validCandidates);
            }
            if (validCandidates.size() == 1) {
                ExecutableElement candidate = (ExecutableElement)validCandidates.get(0);
                VariableElement variableElement = candidate.getParameters().get(0);
                TypeMirror currentType = currentClass.asType();
                return this.memberDefinition(names, member, variableElement.asType()).map(d -> ImmutableMemberDefinition.builder().from((MemberDefinition)d).addConverter(c -> CodeBlock.of((String)"$T.$N($L)", (Object[])new Object[]{currentType, candidate.getSimpleName().toString(), c})).build());
            }
            if (!scanInheritance) continue;
            for (TypeMirror typeMirror : currentClass.getInterfaces()) {
                classesToSearch.addLast(MoreTypes.asTypeElement((TypeMirror)typeMirror));
            }
        } while (!classesToSearch.isEmpty());
        for (InvalidCandidate invalidCandidate : invalidCandidates) {
            this.error(String.format(Locale.ENGLISH, invalidCandidate.message(), invalidCandidate.args()), invalidCandidate.element());
        }
        return this.converterError(member.method(), "No suitable method found that matches [%s]. Make sure that the method is static, public, unary, not generic, does not declare any exception and returns [%s].", converter, targetType);
    }

    private void validateCandidateModifiers(TypeMirror targetType, Collection<InvalidCandidate> invalidCandidates, ExecutableElement candidate, Set<Modifier> modifiers) {
        if (!modifiers.contains((Object)Modifier.STATIC)) {
            invalidCandidates.add(InvalidCandidate.of(candidate, "Must be static", new Object[0]));
        }
        if (!modifiers.contains((Object)Modifier.PUBLIC)) {
            invalidCandidates.add(InvalidCandidate.of(candidate, "Must be public", new Object[0]));
        }
        if (!candidate.getTypeParameters().isEmpty()) {
            invalidCandidates.add(InvalidCandidate.of(candidate, "May not be generic", new Object[0]));
        }
        if (!candidate.getThrownTypes().isEmpty()) {
            invalidCandidates.add(InvalidCandidate.of(candidate, "May not declare any exceptions", new Object[0]));
        }
        if (candidate.getParameters().size() != 1) {
            invalidCandidates.add(InvalidCandidate.of(candidate, "May only accept one parameter", new Object[0]));
        }
        if (!this.typeUtils.isAssignable(candidate.getReturnType(), targetType)) {
            invalidCandidates.add(InvalidCandidate.of(candidate, "Must return a type that is assignable to %s", targetType));
        }
    }

    private Optional<MemberDefinition> memberDefinition(NameAllocator names, ConfigParser.Member member, TypeMirror targetType) {
        ImmutableMemberDefinition.Builder builder = ImmutableMemberDefinition.builder().member(member).fieldName(names.get((Object)member)).configParamName(names.get((Object)CONFIG_VAR)).configKey(member.lookupKey()).fieldType(member.method().getReturnType()).parameterType(targetType).methodPrefix("require");
        switch (targetType.getKind()) {
            case BOOLEAN: {
                builder.methodName("Bool");
                break;
            }
            case INT: {
                builder.methodName("Int");
                break;
            }
            case LONG: {
                builder.methodName("Long");
                break;
            }
            case DOUBLE: {
                builder.methodName("Double");
                break;
            }
            case BYTE: 
            case SHORT: 
            case FLOAT: {
                builder.methodName("Number").addConverter(c -> CodeBlock.of((String)"$L.$LValue()", (Object[])new Object[]{c, targetType}));
                break;
            }
            case DECLARED: {
                if (MoreTypes.isTypeOf(String.class, (TypeMirror)targetType)) {
                    builder.methodName("String");
                    break;
                }
                if (MoreTypes.isTypeOf(Number.class, (TypeMirror)targetType)) {
                    builder.methodName("Number");
                    break;
                }
                if (MoreTypes.isTypeOf(Optional.class, (TypeMirror)targetType)) {
                    List<? extends TypeMirror> typeArguments;
                    Optional<Object> maybeInnerType = member.method().isDefault() ? this.error("Optional fields can not to be declared default (Optional.empty is the default).", member.method()) : ((typeArguments = ((DeclaredType)targetType).getTypeArguments()).isEmpty() ? this.error("Optional must have a Cypher-supported type as type argument, but found none.", member.method()) : Optional.of(ClassName.get((TypeElement)MoreTypes.asTypeElement((TypeMirror)typeArguments.get(0)))));
                    if (maybeInnerType.isPresent()) {
                        builder.methodPrefix("get").methodName("Optional").expectedType(CodeBlock.of((String)"$T.class", (Object[])new Object[]{maybeInnerType.get()}));
                        break;
                    }
                    return Optional.empty();
                }
                builder.methodName("Checked").expectedType(CodeBlock.of((String)"$T.class", (Object[])new Object[]{ClassName.get((TypeElement)MoreTypes.asTypeElement((TypeMirror)targetType))}));
                break;
            }
            default: {
                return this.error("Unsupported return type: " + targetType, member.method());
            }
        }
        if (member.method().isDefault()) {
            builder.methodPrefix("get").defaultProvider(CodeBlock.of((String)"$T.super.$N()", (Object[])new Object[]{member.owner().asType(), member.methodName()}));
        }
        return Optional.of(builder.build());
    }

    private <T> Optional<T> error(CharSequence message, Element element) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, message, element);
        return Optional.empty();
    }

    private <T> Optional<T> converterError(Element element, String message, Object ... args) {
        this.messager.printMessage(Diagnostic.Kind.ERROR, String.format(Locale.ENGLISH, message, args), element, (AnnotationMirror)MoreElements.getAnnotationMirror((Element)element, Configuration.ConvertWith.class).orNull());
        return Optional.empty();
    }

    @ValueClass
    static interface InvalidCandidate {
        public Element element();

        public String message();

        public Object[] args();

        public static InvalidCandidate of(Element element, String format, Object ... args) {
            return ImmutableInvalidCandidate.builder().element(element).message(format).args(args).build();
        }
    }

    @ValueClass
    static interface MemberDefinition {
        public ConfigParser.Member member();

        public TypeMirror fieldType();

        public TypeMirror parameterType();

        public String fieldName();

        public String configParamName();

        public String methodPrefix();

        public String methodName();

        public String configKey();

        public Optional<CodeBlock> defaultProvider();

        public Optional<CodeBlock> expectedType();

        public List<UnaryOperator<CodeBlock>> converters();
    }

    @ValueClass
    static interface FieldDefinitions {
        public List<FieldSpec> fields();

        public NameAllocator names();
    }
}

