/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.proc.GenerateConfiguration;

final class GenerateConfigurationBuilder {
    private GenerateConfigurationBuilder() {
    }

    static TypeSpec defineConfigBuilder(TypeName configInterfaceType, List<GenerateConfiguration.MemberDefinition> configImplMembers, ClassName builderClassName, String generatedClassName, List<ParameterSpec> constructorParameters, String configMapParameterName, Optional<MethodSpec> maybeFactoryFunction) {
        TypeSpec.Builder configBuilderClass = TypeSpec.classBuilder((String)"Builder").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC, Modifier.FINAL});
        configBuilderClass.addField((TypeName)ParameterizedTypeName.get(Map.class, (Type[])new Type[]{String.class, Object.class}), configMapParameterName, new Modifier[]{Modifier.FINAL, Modifier.PRIVATE});
        configBuilderClass.addMethod(MethodSpec.constructorBuilder().addStatement("this.$N = new $T<>()", new Object[]{configMapParameterName, HashMap.class}).addModifiers(new Modifier[]{Modifier.PUBLIC}).build());
        constructorParameters.stream().filter(p -> !p.name.equals(configMapParameterName)).forEach(parameter -> configBuilderClass.addField(parameter.type, parameter.name, new Modifier[]{Modifier.PRIVATE}));
        return configBuilderClass.addMethods(GenerateConfigurationBuilder.defineConfigParameterSetters(configImplMembers, builderClassName)).addMethods(GenerateConfigurationBuilder.defineConfigMapEntrySetters(configImplMembers, configMapParameterName, builderClassName)).addMethod(GenerateConfigurationBuilder.defineBuildMethod(configInterfaceType, generatedClassName, constructorParameters, configMapParameterName, maybeFactoryFunction)).build();
    }

    private static List<MethodSpec> defineConfigParameterSetters(List<GenerateConfiguration.MemberDefinition> implMembers, ClassName builderClassName) {
        return implMembers.stream().filter(implMember -> implMember.member().isConfigParameter()).map(implMember -> MethodSpec.methodBuilder((String)implMember.member().methodName()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)implMember.parameterType()), implMember.member().methodName(), new Modifier[0]).returns((TypeName)builderClassName).addCode(CodeBlock.builder().addStatement("this.$1N = $1N", new Object[]{implMember.member().methodName()}).addStatement("return this", new Object[0]).build()).build()).collect(Collectors.toList());
    }

    private static List<MethodSpec> defineConfigMapEntrySetters(List<GenerateConfiguration.MemberDefinition> implMembers, String builderConfigMapFieldName, ClassName builderClassName) {
        return implMembers.stream().filter(implMember -> implMember.member().isConfigMapEntry()).flatMap(implMember -> {
            Stream.Builder<MethodSpec> setterMethods = Stream.builder();
            String configKeyName = implMember.member().methodName();
            MethodSpec.Builder setMethodBuilder = MethodSpec.methodBuilder((String)configKeyName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(GenerateConfigurationBuilder.unpackedType(implMember.parameterType()), configKeyName, new Modifier[0]).returns((TypeName)builderClassName).addCode(CodeBlock.builder().addStatement("this.$N.put(\"$L\", $N)", new Object[]{builderConfigMapFieldName, implMember.member().lookupKey(), configKeyName}).addStatement("return this", new Object[0]).build());
            setterMethods.add(setMethodBuilder.build());
            if (MoreTypes.isTypeOf(Optional.class, (TypeMirror)implMember.parameterType())) {
                String lambdaVarName = "actual" + configKeyName;
                MethodSpec.Builder optionalSetterBuilder = MethodSpec.methodBuilder((String)configKeyName).addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TypeName.get((TypeMirror)implMember.parameterType()), configKeyName, new Modifier[0]).returns((TypeName)builderClassName).addStatement("$1N.ifPresent($2N -> this.$3N.put(\"$4L\", $2N))", new Object[]{configKeyName, lambdaVarName, builderConfigMapFieldName, implMember.member().lookupKey()}).addStatement("return this", new Object[0]);
                setterMethods.add(optionalSetterBuilder.build());
            }
            return setterMethods.build();
        }).collect(Collectors.toList());
    }

    private static MethodSpec defineBuildMethod(TypeName configInterfaceType, String generatedClassName, List<ParameterSpec> constructorParameters, String configMapParameterName, Optional<MethodSpec> maybeFactoryFunction) {
        String constructorParameterString = constructorParameters.stream().map(param -> param.name).collect(Collectors.joining(", "));
        CodeBlock configCreateStatement = maybeFactoryFunction.map(factoryFunc -> CodeBlock.of((String)"return $L.$L($L)", (Object[])new Object[]{generatedClassName, factoryFunc.name, constructorParameterString})).orElse(CodeBlock.of((String)"return new $L($L)", (Object[])new Object[]{generatedClassName, constructorParameterString}));
        return MethodSpec.methodBuilder((String)"build").addModifiers(new Modifier[]{Modifier.PUBLIC}).addCode(CodeBlock.builder().addStatement("$1T $2N = $1T.create(this.$3N)", new Object[]{CypherMapWrapper.class, configMapParameterName, configMapParameterName}).addStatement(configCreateStatement).build()).returns(configInterfaceType).build();
    }

    private static TypeName unpackedType(TypeMirror returnType) {
        List<? extends TypeMirror> typeArguments;
        if (MoreTypes.isTypeOf(Optional.class, (TypeMirror)returnType) && !(typeArguments = ((DeclaredType)returnType).getTypeArguments()).isEmpty()) {
            return ClassName.get((TypeElement)MoreTypes.asTypeElement((TypeMirror)typeArguments.get(0)));
        }
        return TypeName.get((TypeMirror)returnType);
    }
}

