/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.auto.common.MoreTypes;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.NameAllocator;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.Configuration;
import org.neo4j.gds.proc.ConfigParser;

final class GenerateConfigurationMethods {
    private GenerateConfigurationMethods() {
    }

    static Iterable<MethodSpec> defineMemberMethods(ConfigParser.Spec config, NameAllocator names) {
        return config.members().stream().map(member -> GenerateConfigurationMethods.generateMethodCode(config, names, member)).flatMap(Optional::stream).collect(Collectors.toList());
    }

    private static Optional<MethodSpec> generateMethodCode(ConfigParser.Spec config, NameAllocator names, ConfigParser.Member member) {
        MethodSpec.Builder builder = MethodSpec.overriding((ExecutableElement)member.method()).returns(member.typeSpecWithAnnotation(Nullable.class));
        if (member.collectsKeys()) {
            builder.addStatement(GenerateConfigurationMethods.collectKeysCode(config));
        } else if (member.toMap()) {
            GenerateConfigurationMethods.injectToMapCode(config, builder);
        } else if (member.graphStoreValidation()) {
            GenerateConfigurationMethods.graphStoreValidationCode(member, config).forEach(arg_0 -> ((MethodSpec.Builder)builder).addStatement(arg_0));
        } else if (member.isConfigValue()) {
            builder.addStatement("return this.$N", new Object[]{names.get((Object)member)});
        } else {
            return Optional.empty();
        }
        return Optional.of(builder.build());
    }

    private static void injectToMapCode(ConfigParser.Spec config, MethodSpec.Builder builder) {
        List<ConfigParser.Member> configMembers = config.members().stream().filter(ConfigParser.Member::isConfigMapEntry).collect(Collectors.toList());
        switch (configMembers.size()) {
            case 0: {
                builder.addStatement("return $T.emptyMap()", new Object[]{Collections.class});
                break;
            }
            case 1: {
                ConfigParser.Member singleConfigMember = (ConfigParser.Member)configMembers.get(0);
                String parameter = singleConfigMember.lookupKey();
                builder.addStatement("return $T.singletonMap($S, $L)", new Object[]{Collections.class, parameter, GenerateConfigurationMethods.getMapValueCode(singleConfigMember)});
                break;
            }
            default: {
                builder.addStatement("$T<$T, Object> map = new $T<>()", new Object[]{Map.class, String.class, LinkedHashMap.class});
                configMembers.forEach(configMember -> {
                    if (MoreTypes.isTypeOf(Optional.class, (TypeMirror)configMember.method().getReturnType())) {
                        builder.addStatement(GenerateConfigurationMethods.getMapPutOptionalCode(configMember));
                    } else {
                        builder.addStatement("map.put($S, $L)", new Object[]{configMember.lookupKey(), GenerateConfigurationMethods.getMapValueCode(configMember)});
                    }
                });
                builder.addStatement("return map", new Object[0]);
            }
        }
    }

    @NotNull
    private static CodeBlock getMapValueCode(ConfigParser.Member configMember) {
        String getter = configMember.methodName();
        Configuration.ToMapValue toMapValue = configMember.method().getAnnotation(Configuration.ToMapValue.class);
        return toMapValue == null ? CodeBlock.of((String)"$N()", (Object[])new Object[]{getter}) : CodeBlock.of((String)"$L($N())", (Object[])new Object[]{GenerateConfigurationMethods.getReference(toMapValue), getter});
    }

    @NotNull
    private static CodeBlock getMapPutOptionalCode(ConfigParser.Member configMember) {
        Configuration.ToMapValue toMapValue = configMember.method().getAnnotation(Configuration.ToMapValue.class);
        CodeBlock mapValue = toMapValue == null ? CodeBlock.of((String)"$L", (Object[])new Object[]{configMember.lookupKey()}) : CodeBlock.of((String)"$L($L)", (Object[])new Object[]{GenerateConfigurationMethods.getReference(toMapValue), configMember.lookupKey()});
        return CodeBlock.of((String)"$L.ifPresent($L -> map.put($S, $L))", (Object[])new Object[]{CodeBlock.of((String)"$N()", (Object[])new Object[]{configMember.methodName()}), configMember.lookupKey(), configMember.lookupKey(), mapValue});
    }

    private static String getReference(Configuration.ToMapValue toMapValue) {
        return toMapValue.value().replace('#', '.');
    }

    private static CodeBlock collectKeysCode(ConfigParser.Spec config) {
        Collection configKeys = config.members().stream().filter(ConfigParser.Member::isConfigMapEntry).map(ConfigParser.Member::lookupKey).collect(Collectors.toCollection(LinkedHashSet::new));
        switch (configKeys.size()) {
            case 0: {
                return CodeBlock.of((String)"return $T.emptyList()", (Object[])new Object[]{Collections.class});
            }
            case 1: {
                return CodeBlock.of((String)"return $T.singleton($S)", (Object[])new Object[]{Collections.class, configKeys.iterator().next()});
            }
        }
        CodeBlock keys = (CodeBlock)configKeys.stream().map(name -> CodeBlock.of((String)"$S", (Object[])new Object[]{name})).collect(CodeBlock.joining((String)", "));
        return CodeBlock.of((String)"return $T.asList($L)", (Object[])new Object[]{Arrays.class, keys});
    }

    private static Stream<CodeBlock> graphStoreValidationCode(ConfigParser.Member validationMethod, ConfigParser.Spec config) {
        List<? extends VariableElement> parameters = validationMethod.method().getParameters();
        return config.members().stream().filter(ConfigParser.Member::graphStoreValidationCheck).map(check -> CodeBlock.of((String)"$N($N, $N, $N)", (Object[])new Object[]{check.methodName(), ((VariableElement)parameters.get(0)).getSimpleName(), ((VariableElement)parameters.get(1)).getSimpleName(), ((VariableElement)parameters.get(2)).getSimpleName()}));
    }
}

