/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.NameAllocator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.proc.GenerateConfiguration;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenerateConfiguration.FieldDefinitions", generator="Immutables")
@Immutable
public final class ImmutableFieldDefinitions
implements GenerateConfiguration.FieldDefinitions {
    private final List<FieldSpec> fields;
    private final NameAllocator names;

    private ImmutableFieldDefinitions(Iterable<? extends FieldSpec> fields, NameAllocator names) {
        this.fields = ImmutableFieldDefinitions.createUnmodifiableList(false, ImmutableFieldDefinitions.createSafeList(fields, true, false));
        this.names = Objects.requireNonNull(names, "names");
    }

    private ImmutableFieldDefinitions(ImmutableFieldDefinitions original, List<FieldSpec> fields, NameAllocator names) {
        this.fields = fields;
        this.names = names;
    }

    @Override
    public List<FieldSpec> fields() {
        return this.fields;
    }

    @Override
    public NameAllocator names() {
        return this.names;
    }

    public final ImmutableFieldDefinitions withFields(FieldSpec ... elements) {
        List<FieldSpec> newValue = ImmutableFieldDefinitions.createUnmodifiableList(false, ImmutableFieldDefinitions.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableFieldDefinitions(this, newValue, this.names);
    }

    public final ImmutableFieldDefinitions withFields(Iterable<? extends FieldSpec> elements) {
        if (this.fields == elements) {
            return this;
        }
        List<FieldSpec> newValue = ImmutableFieldDefinitions.createUnmodifiableList(false, ImmutableFieldDefinitions.createSafeList(elements, true, false));
        return new ImmutableFieldDefinitions(this, newValue, this.names);
    }

    public final ImmutableFieldDefinitions withNames(NameAllocator value) {
        if (this.names == value) {
            return this;
        }
        NameAllocator newValue = Objects.requireNonNull(value, "names");
        return new ImmutableFieldDefinitions(this, this.fields, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableFieldDefinitions && this.equalTo((ImmutableFieldDefinitions)another);
    }

    private boolean equalTo(ImmutableFieldDefinitions another) {
        return this.fields.equals(another.fields) && this.names.equals(another.names);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.fields.hashCode();
        h += (h << 5) + this.names.hashCode();
        return h;
    }

    public String toString() {
        return "FieldDefinitions{fields=" + this.fields + ", names=" + this.names + "}";
    }

    public static GenerateConfiguration.FieldDefinitions of(List<FieldSpec> fields, NameAllocator names) {
        return ImmutableFieldDefinitions.of(fields, names);
    }

    public static GenerateConfiguration.FieldDefinitions of(Iterable<? extends FieldSpec> fields, NameAllocator names) {
        return new ImmutableFieldDefinitions(fields, names);
    }

    static GenerateConfiguration.FieldDefinitions copyOf(GenerateConfiguration.FieldDefinitions instance) {
        if (instance instanceof ImmutableFieldDefinitions) {
            return (ImmutableFieldDefinitions)instance;
        }
        return ImmutableFieldDefinitions.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GenerateConfiguration.FieldDefinitions", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_NAMES = 1L;
        private long initBits = 1L;
        private List<FieldSpec> fields = null;
        @Nullable
        private NameAllocator names;

        private Builder() {
        }

        public final Builder from(ImmutableFieldDefinitions instance) {
            return this.from((GenerateConfiguration.FieldDefinitions)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GenerateConfiguration.FieldDefinitions instance) {
            Objects.requireNonNull(instance, "instance");
            this.addAllFields(instance.fields());
            this.names(instance.names());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addField(FieldSpec element) {
            if (this.fields == null) {
                this.fields = new ArrayList<FieldSpec>();
            }
            this.fields.add(Objects.requireNonNull(element, "fields element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addFields(FieldSpec ... elements) {
            if (this.fields == null) {
                this.fields = new ArrayList<FieldSpec>();
            }
            for (FieldSpec element : elements) {
                this.fields.add(Objects.requireNonNull(element, "fields element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(Iterable<? extends FieldSpec> elements) {
            this.fields = new ArrayList<FieldSpec>();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<? extends FieldSpec> elements) {
            Objects.requireNonNull(elements, "fields element");
            if (this.fields == null) {
                this.fields = new ArrayList<FieldSpec>();
            }
            for (FieldSpec fieldSpec : elements) {
                this.fields.add(Objects.requireNonNull(fieldSpec, "fields element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder names(NameAllocator names) {
            this.names = Objects.requireNonNull(names, "names");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 1L;
            if (this.fields != null) {
                this.fields.clear();
            }
            this.names = null;
            return this;
        }

        public GenerateConfiguration.FieldDefinitions build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableFieldDefinitions(null, this.fields == null ? Collections.emptyList() : ImmutableFieldDefinitions.createUnmodifiableList(true, this.fields), this.names);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("names");
            }
            return "Cannot build FieldDefinitions, some of required attributes are not set " + attributes;
        }
    }
}

