/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.Element;
import org.immutables.value.Generated;
import org.neo4j.gds.proc.GenerateConfiguration;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenerateConfiguration.InvalidCandidate", generator="Immutables")
@Immutable
public final class ImmutableInvalidCandidate
implements GenerateConfiguration.InvalidCandidate {
    private final Element element;
    private final String message;
    private final Object[] args;

    private ImmutableInvalidCandidate(Element element, String message, Object[] args) {
        this.element = Objects.requireNonNull(element, "element");
        this.message = Objects.requireNonNull(message, "message");
        this.args = (Object[])args.clone();
    }

    private ImmutableInvalidCandidate(ImmutableInvalidCandidate original, Element element, String message, Object[] args) {
        this.element = element;
        this.message = message;
        this.args = args;
    }

    @Override
    public Element element() {
        return this.element;
    }

    @Override
    public String message() {
        return this.message;
    }

    @Override
    public Object[] args() {
        return (Object[])this.args.clone();
    }

    public final ImmutableInvalidCandidate withElement(Element value) {
        if (this.element == value) {
            return this;
        }
        Element newValue = Objects.requireNonNull(value, "element");
        return new ImmutableInvalidCandidate(this, newValue, this.message, this.args);
    }

    public final ImmutableInvalidCandidate withMessage(String value) {
        String newValue = Objects.requireNonNull(value, "message");
        if (this.message.equals(newValue)) {
            return this;
        }
        return new ImmutableInvalidCandidate(this, this.element, newValue, this.args);
    }

    public final ImmutableInvalidCandidate withArgs(Object ... elements) {
        Object[] newValue = (Object[])elements.clone();
        return new ImmutableInvalidCandidate(this, this.element, this.message, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableInvalidCandidate && this.equalTo((ImmutableInvalidCandidate)another);
    }

    private boolean equalTo(ImmutableInvalidCandidate another) {
        return this.element.equals(another.element) && this.message.equals(another.message) && Arrays.equals(this.args, another.args);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.element.hashCode();
        h += (h << 5) + this.message.hashCode();
        h += (h << 5) + Arrays.hashCode(this.args);
        return h;
    }

    public String toString() {
        return "InvalidCandidate{element=" + this.element + ", message=" + this.message + ", args=" + Arrays.toString(this.args) + "}";
    }

    public static GenerateConfiguration.InvalidCandidate of(Element element, String message, Object[] args) {
        return new ImmutableInvalidCandidate(element, message, args);
    }

    static GenerateConfiguration.InvalidCandidate copyOf(GenerateConfiguration.InvalidCandidate instance) {
        if (instance instanceof ImmutableInvalidCandidate) {
            return (ImmutableInvalidCandidate)instance;
        }
        return ImmutableInvalidCandidate.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GenerateConfiguration.InvalidCandidate", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_ELEMENT = 1L;
        private static final long INIT_BIT_MESSAGE = 2L;
        private static final long INIT_BIT_ARGS = 4L;
        private long initBits = 7L;
        @Nullable
        private Element element;
        @Nullable
        private String message;
        @Nullable
        private Object[] args;

        private Builder() {
        }

        public final Builder from(ImmutableInvalidCandidate instance) {
            return this.from((GenerateConfiguration.InvalidCandidate)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GenerateConfiguration.InvalidCandidate instance) {
            Objects.requireNonNull(instance, "instance");
            this.element(instance.element());
            this.message(instance.message());
            this.args(instance.args());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder element(Element element) {
            this.element = Objects.requireNonNull(element, "element");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder message(String message) {
            this.message = Objects.requireNonNull(message, "message");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder args(Object ... args) {
            this.args = (Object[])args.clone();
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 7L;
            this.element = null;
            this.message = null;
            this.args = null;
            return this;
        }

        public GenerateConfiguration.InvalidCandidate build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableInvalidCandidate(null, this.element, this.message, this.args);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("element");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("message");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("args");
            }
            return "Cannot build InvalidCandidate, some of required attributes are not set " + attributes;
        }
    }
}

