/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import org.immutables.value.Generated;
import org.neo4j.gds.proc.ConfigParser;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigParser.Member", generator="Immutables")
@Immutable
public final class ImmutableMember
extends ConfigParser.Member {
    private final TypeElement owner;
    private final ExecutableElement method;
    private final String lookupKey;
    private final boolean collectsKeys;
    private final boolean toMap;
    private final boolean validatesIntegerRange;
    private final boolean validatesLongRange;
    private final boolean validatesDoubleRange;
    private final boolean validates;
    private final boolean graphStoreValidation;
    private final boolean graphStoreValidationCheck;
    private final boolean normalizes;
    private final transient String methodName;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private ImmutableMember(TypeElement owner, ExecutableElement method, String lookupKey, boolean collectsKeys, boolean toMap, boolean validatesIntegerRange, boolean validatesLongRange, boolean validatesDoubleRange, boolean validates, boolean graphStoreValidation, boolean graphStoreValidationCheck, boolean normalizes) {
        this.owner = Objects.requireNonNull(owner, "owner");
        this.method = Objects.requireNonNull(method, "method");
        this.initShim.lookupKey(Objects.requireNonNull(lookupKey, "lookupKey"));
        this.initShim.collectsKeys(collectsKeys);
        this.initShim.toMap(toMap);
        this.initShim.validatesIntegerRange(validatesIntegerRange);
        this.initShim.validatesLongRange(validatesLongRange);
        this.initShim.validatesDoubleRange(validatesDoubleRange);
        this.initShim.validates(validates);
        this.initShim.graphStoreValidation(graphStoreValidation);
        this.initShim.graphStoreValidationCheck(graphStoreValidationCheck);
        this.initShim.normalizes(normalizes);
        this.lookupKey = this.initShim.lookupKey();
        this.collectsKeys = this.initShim.collectsKeys();
        this.toMap = this.initShim.toMap();
        this.validatesIntegerRange = this.initShim.validatesIntegerRange();
        this.validatesLongRange = this.initShim.validatesLongRange();
        this.validatesDoubleRange = this.initShim.validatesDoubleRange();
        this.validates = this.initShim.validates();
        this.graphStoreValidation = this.initShim.graphStoreValidation();
        this.graphStoreValidationCheck = this.initShim.graphStoreValidationCheck();
        this.normalizes = this.initShim.normalizes();
        this.methodName = this.initShim.methodName();
        this.initShim = null;
    }

    private ImmutableMember(Builder builder) {
        this.owner = builder.owner;
        this.method = builder.method;
        if (builder.lookupKey != null) {
            this.initShim.lookupKey(builder.lookupKey);
        }
        if (builder.collectsKeysIsSet()) {
            this.initShim.collectsKeys(builder.collectsKeys);
        }
        if (builder.toMapIsSet()) {
            this.initShim.toMap(builder.toMap);
        }
        if (builder.validatesIntegerRangeIsSet()) {
            this.initShim.validatesIntegerRange(builder.validatesIntegerRange);
        }
        if (builder.validatesLongRangeIsSet()) {
            this.initShim.validatesLongRange(builder.validatesLongRange);
        }
        if (builder.validatesDoubleRangeIsSet()) {
            this.initShim.validatesDoubleRange(builder.validatesDoubleRange);
        }
        if (builder.validatesIsSet()) {
            this.initShim.validates(builder.validates);
        }
        if (builder.graphStoreValidationIsSet()) {
            this.initShim.graphStoreValidation(builder.graphStoreValidation);
        }
        if (builder.graphStoreValidationCheckIsSet()) {
            this.initShim.graphStoreValidationCheck(builder.graphStoreValidationCheck);
        }
        if (builder.normalizesIsSet()) {
            this.initShim.normalizes(builder.normalizes);
        }
        this.lookupKey = this.initShim.lookupKey();
        this.collectsKeys = this.initShim.collectsKeys();
        this.toMap = this.initShim.toMap();
        this.validatesIntegerRange = this.initShim.validatesIntegerRange();
        this.validatesLongRange = this.initShim.validatesLongRange();
        this.validatesDoubleRange = this.initShim.validatesDoubleRange();
        this.validates = this.initShim.validates();
        this.graphStoreValidation = this.initShim.graphStoreValidation();
        this.graphStoreValidationCheck = this.initShim.graphStoreValidationCheck();
        this.normalizes = this.initShim.normalizes();
        this.methodName = this.initShim.methodName();
        this.initShim = null;
    }

    private ImmutableMember(ImmutableMember original, TypeElement owner, ExecutableElement method, String lookupKey, boolean collectsKeys, boolean toMap, boolean validatesIntegerRange, boolean validatesLongRange, boolean validatesDoubleRange, boolean validates, boolean graphStoreValidation, boolean graphStoreValidationCheck, boolean normalizes) {
        this.owner = owner;
        this.method = method;
        this.initShim.lookupKey(lookupKey);
        this.initShim.collectsKeys(collectsKeys);
        this.initShim.toMap(toMap);
        this.initShim.validatesIntegerRange(validatesIntegerRange);
        this.initShim.validatesLongRange(validatesLongRange);
        this.initShim.validatesDoubleRange(validatesDoubleRange);
        this.initShim.validates(validates);
        this.initShim.graphStoreValidation(graphStoreValidation);
        this.initShim.graphStoreValidationCheck(graphStoreValidationCheck);
        this.initShim.normalizes(normalizes);
        this.lookupKey = this.initShim.lookupKey();
        this.collectsKeys = this.initShim.collectsKeys();
        this.toMap = this.initShim.toMap();
        this.validatesIntegerRange = this.initShim.validatesIntegerRange();
        this.validatesLongRange = this.initShim.validatesLongRange();
        this.validatesDoubleRange = this.initShim.validatesDoubleRange();
        this.validates = this.initShim.validates();
        this.graphStoreValidation = this.initShim.graphStoreValidation();
        this.graphStoreValidationCheck = this.initShim.graphStoreValidationCheck();
        this.normalizes = this.initShim.normalizes();
        this.methodName = this.initShim.methodName();
        this.initShim = null;
    }

    @Override
    public TypeElement owner() {
        return this.owner;
    }

    @Override
    public ExecutableElement method() {
        return this.method;
    }

    @Override
    public String lookupKey() {
        InitShim shim = this.initShim;
        return shim != null ? shim.lookupKey() : this.lookupKey;
    }

    @Override
    public boolean collectsKeys() {
        InitShim shim = this.initShim;
        return shim != null ? shim.collectsKeys() : this.collectsKeys;
    }

    @Override
    public boolean toMap() {
        InitShim shim = this.initShim;
        return shim != null ? shim.toMap() : this.toMap;
    }

    @Override
    public boolean validatesIntegerRange() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validatesIntegerRange() : this.validatesIntegerRange;
    }

    @Override
    public boolean validatesLongRange() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validatesLongRange() : this.validatesLongRange;
    }

    @Override
    public boolean validatesDoubleRange() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validatesDoubleRange() : this.validatesDoubleRange;
    }

    @Override
    public boolean validates() {
        InitShim shim = this.initShim;
        return shim != null ? shim.validates() : this.validates;
    }

    @Override
    public boolean graphStoreValidation() {
        InitShim shim = this.initShim;
        return shim != null ? shim.graphStoreValidation() : this.graphStoreValidation;
    }

    @Override
    public boolean graphStoreValidationCheck() {
        InitShim shim = this.initShim;
        return shim != null ? shim.graphStoreValidationCheck() : this.graphStoreValidationCheck;
    }

    @Override
    public boolean normalizes() {
        InitShim shim = this.initShim;
        return shim != null ? shim.normalizes() : this.normalizes;
    }

    @Override
    public String methodName() {
        InitShim shim = this.initShim;
        return shim != null ? shim.methodName() : this.methodName;
    }

    public final ImmutableMember withOwner(TypeElement value) {
        if (this.owner == value) {
            return this;
        }
        TypeElement newValue = Objects.requireNonNull(value, "owner");
        return ImmutableMember.validate(new ImmutableMember(this, newValue, this.method, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withMethod(ExecutableElement value) {
        if (this.method == value) {
            return this;
        }
        ExecutableElement newValue = Objects.requireNonNull(value, "method");
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, newValue, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withLookupKey(String value) {
        String newValue = Objects.requireNonNull(value, "lookupKey");
        if (this.lookupKey.equals(newValue)) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, newValue, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withCollectsKeys(boolean value) {
        if (this.collectsKeys == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, value, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withToMap(boolean value) {
        if (this.toMap == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, value, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withValidatesIntegerRange(boolean value) {
        if (this.validatesIntegerRange == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, this.toMap, value, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withValidatesLongRange(boolean value) {
        if (this.validatesLongRange == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, value, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withValidatesDoubleRange(boolean value) {
        if (this.validatesDoubleRange == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, value, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withValidates(boolean value) {
        if (this.validates == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, value, this.graphStoreValidation, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withGraphStoreValidation(boolean value) {
        if (this.graphStoreValidation == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, value, this.graphStoreValidationCheck, this.normalizes));
    }

    public final ImmutableMember withGraphStoreValidationCheck(boolean value) {
        if (this.graphStoreValidationCheck == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, value, this.normalizes));
    }

    public final ImmutableMember withNormalizes(boolean value) {
        if (this.normalizes == value) {
            return this;
        }
        return ImmutableMember.validate(new ImmutableMember(this, this.owner, this.method, this.lookupKey, this.collectsKeys, this.toMap, this.validatesIntegerRange, this.validatesLongRange, this.validatesDoubleRange, this.validates, this.graphStoreValidation, this.graphStoreValidationCheck, value));
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMember && this.equalTo((ImmutableMember)another);
    }

    private boolean equalTo(ImmutableMember another) {
        return this.owner.equals(another.owner) && this.method.equals(another.method) && this.lookupKey.equals(another.lookupKey) && this.collectsKeys == another.collectsKeys && this.toMap == another.toMap && this.validatesIntegerRange == another.validatesIntegerRange && this.validatesLongRange == another.validatesLongRange && this.validatesDoubleRange == another.validatesDoubleRange && this.validates == another.validates && this.graphStoreValidation == another.graphStoreValidation && this.graphStoreValidationCheck == another.graphStoreValidationCheck && this.normalizes == another.normalizes && this.methodName.equals(another.methodName);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.owner.hashCode();
        h += (h << 5) + this.method.hashCode();
        h += (h << 5) + this.lookupKey.hashCode();
        h += (h << 5) + Boolean.hashCode(this.collectsKeys);
        h += (h << 5) + Boolean.hashCode(this.toMap);
        h += (h << 5) + Boolean.hashCode(this.validatesIntegerRange);
        h += (h << 5) + Boolean.hashCode(this.validatesLongRange);
        h += (h << 5) + Boolean.hashCode(this.validatesDoubleRange);
        h += (h << 5) + Boolean.hashCode(this.validates);
        h += (h << 5) + Boolean.hashCode(this.graphStoreValidation);
        h += (h << 5) + Boolean.hashCode(this.graphStoreValidationCheck);
        h += (h << 5) + Boolean.hashCode(this.normalizes);
        h += (h << 5) + this.methodName.hashCode();
        return h;
    }

    public String toString() {
        return "Member{owner=" + this.owner + ", method=" + this.method + ", lookupKey=" + this.lookupKey + ", collectsKeys=" + this.collectsKeys + ", toMap=" + this.toMap + ", validatesIntegerRange=" + this.validatesIntegerRange + ", validatesLongRange=" + this.validatesLongRange + ", validatesDoubleRange=" + this.validatesDoubleRange + ", validates=" + this.validates + ", graphStoreValidation=" + this.graphStoreValidation + ", graphStoreValidationCheck=" + this.graphStoreValidationCheck + ", normalizes=" + this.normalizes + ", methodName=" + this.methodName + "}";
    }

    public static ConfigParser.Member of(TypeElement owner, ExecutableElement method, String lookupKey, boolean collectsKeys, boolean toMap, boolean validatesIntegerRange, boolean validatesLongRange, boolean validatesDoubleRange, boolean validates, boolean graphStoreValidation, boolean graphStoreValidationCheck, boolean normalizes) {
        return ImmutableMember.validate(new ImmutableMember(owner, method, lookupKey, collectsKeys, toMap, validatesIntegerRange, validatesLongRange, validatesDoubleRange, validates, graphStoreValidation, graphStoreValidationCheck, normalizes));
    }

    private static ImmutableMember validate(ImmutableMember instance) {
        instance = (ImmutableMember)instance.normalize();
        return instance;
    }

    static ConfigParser.Member copyOf(ConfigParser.Member instance) {
        if (instance instanceof ImmutableMember) {
            return (ImmutableMember)instance;
        }
        return ImmutableMember.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ConfigParser.Member", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_OWNER = 1L;
        private static final long INIT_BIT_METHOD = 2L;
        private static final long OPT_BIT_COLLECTS_KEYS = 1L;
        private static final long OPT_BIT_TO_MAP = 2L;
        private static final long OPT_BIT_VALIDATES_INTEGER_RANGE = 4L;
        private static final long OPT_BIT_VALIDATES_LONG_RANGE = 8L;
        private static final long OPT_BIT_VALIDATES_DOUBLE_RANGE = 16L;
        private static final long OPT_BIT_VALIDATES = 32L;
        private static final long OPT_BIT_GRAPH_STORE_VALIDATION = 64L;
        private static final long OPT_BIT_GRAPH_STORE_VALIDATION_CHECK = 128L;
        private static final long OPT_BIT_NORMALIZES = 256L;
        private long initBits = 3L;
        private long optBits;
        @Nullable
        private TypeElement owner;
        @Nullable
        private ExecutableElement method;
        @Nullable
        private String lookupKey;
        private boolean collectsKeys;
        private boolean toMap;
        private boolean validatesIntegerRange;
        private boolean validatesLongRange;
        private boolean validatesDoubleRange;
        private boolean validates;
        private boolean graphStoreValidation;
        private boolean graphStoreValidationCheck;
        private boolean normalizes;

        private Builder() {
        }

        public final Builder from(ImmutableMember instance) {
            return this.from((ConfigParser.Member)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(ConfigParser.Member instance) {
            Objects.requireNonNull(instance, "instance");
            this.owner(instance.owner());
            this.method(instance.method());
            this.lookupKey(instance.lookupKey());
            this.collectsKeys(instance.collectsKeys());
            this.toMap(instance.toMap());
            this.validatesIntegerRange(instance.validatesIntegerRange());
            this.validatesLongRange(instance.validatesLongRange());
            this.validatesDoubleRange(instance.validatesDoubleRange());
            this.validates(instance.validates());
            this.graphStoreValidation(instance.graphStoreValidation());
            this.graphStoreValidationCheck(instance.graphStoreValidationCheck());
            this.normalizes(instance.normalizes());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder owner(TypeElement owner) {
            this.owner = Objects.requireNonNull(owner, "owner");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder method(ExecutableElement method) {
            this.method = Objects.requireNonNull(method, "method");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder lookupKey(String lookupKey) {
            this.lookupKey = Objects.requireNonNull(lookupKey, "lookupKey");
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder collectsKeys(boolean collectsKeys) {
            this.collectsKeys = collectsKeys;
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder toMap(boolean toMap) {
            this.toMap = toMap;
            this.optBits |= 2L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatesIntegerRange(boolean validatesIntegerRange) {
            this.validatesIntegerRange = validatesIntegerRange;
            this.optBits |= 4L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatesLongRange(boolean validatesLongRange) {
            this.validatesLongRange = validatesLongRange;
            this.optBits |= 8L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validatesDoubleRange(boolean validatesDoubleRange) {
            this.validatesDoubleRange = validatesDoubleRange;
            this.optBits |= 0x10L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder validates(boolean validates) {
            this.validates = validates;
            this.optBits |= 0x20L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder graphStoreValidation(boolean graphStoreValidation) {
            this.graphStoreValidation = graphStoreValidation;
            this.optBits |= 0x40L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder graphStoreValidationCheck(boolean graphStoreValidationCheck) {
            this.graphStoreValidationCheck = graphStoreValidationCheck;
            this.optBits |= 0x80L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder normalizes(boolean normalizes) {
            this.normalizes = normalizes;
            this.optBits |= 0x100L;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.optBits = 0L;
            this.owner = null;
            this.method = null;
            this.lookupKey = null;
            this.collectsKeys = false;
            this.toMap = false;
            this.validatesIntegerRange = false;
            this.validatesLongRange = false;
            this.validatesDoubleRange = false;
            this.validates = false;
            this.graphStoreValidation = false;
            this.graphStoreValidationCheck = false;
            this.normalizes = false;
            return this;
        }

        public ConfigParser.Member build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return ImmutableMember.validate(new ImmutableMember(this));
        }

        private boolean collectsKeysIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private boolean toMapIsSet() {
            return (this.optBits & 2L) != 0L;
        }

        private boolean validatesIntegerRangeIsSet() {
            return (this.optBits & 4L) != 0L;
        }

        private boolean validatesLongRangeIsSet() {
            return (this.optBits & 8L) != 0L;
        }

        private boolean validatesDoubleRangeIsSet() {
            return (this.optBits & 0x10L) != 0L;
        }

        private boolean validatesIsSet() {
            return (this.optBits & 0x20L) != 0L;
        }

        private boolean graphStoreValidationIsSet() {
            return (this.optBits & 0x40L) != 0L;
        }

        private boolean graphStoreValidationCheckIsSet() {
            return (this.optBits & 0x80L) != 0L;
        }

        private boolean normalizesIsSet() {
            return (this.optBits & 0x100L) != 0L;
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("owner");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("method");
            }
            return "Cannot build Member, some of required attributes are not set " + attributes;
        }
    }

    @Generated(from="ConfigParser.Member", generator="Immutables")
    private final class InitShim {
        private byte lookupKeyBuildStage = 0;
        private String lookupKey;
        private byte collectsKeysBuildStage = 0;
        private boolean collectsKeys;
        private byte toMapBuildStage = 0;
        private boolean toMap;
        private byte validatesIntegerRangeBuildStage = 0;
        private boolean validatesIntegerRange;
        private byte validatesLongRangeBuildStage = 0;
        private boolean validatesLongRange;
        private byte validatesDoubleRangeBuildStage = 0;
        private boolean validatesDoubleRange;
        private byte validatesBuildStage = 0;
        private boolean validates;
        private byte graphStoreValidationBuildStage = 0;
        private boolean graphStoreValidation;
        private byte graphStoreValidationCheckBuildStage = 0;
        private boolean graphStoreValidationCheck;
        private byte normalizesBuildStage = 0;
        private boolean normalizes;
        private byte methodNameBuildStage = 0;
        private String methodName;

        private InitShim() {
        }

        String lookupKey() {
            if (this.lookupKeyBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.lookupKeyBuildStage == 0) {
                this.lookupKeyBuildStage = (byte)-1;
                this.lookupKey = Objects.requireNonNull(ImmutableMember.super.lookupKey(), "lookupKey");
                this.lookupKeyBuildStage = 1;
            }
            return this.lookupKey;
        }

        void lookupKey(String lookupKey) {
            this.lookupKey = lookupKey;
            this.lookupKeyBuildStage = 1;
        }

        boolean collectsKeys() {
            if (this.collectsKeysBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.collectsKeysBuildStage == 0) {
                this.collectsKeysBuildStage = (byte)-1;
                this.collectsKeys = ImmutableMember.super.collectsKeys();
                this.collectsKeysBuildStage = 1;
            }
            return this.collectsKeys;
        }

        void collectsKeys(boolean collectsKeys) {
            this.collectsKeys = collectsKeys;
            this.collectsKeysBuildStage = 1;
        }

        boolean toMap() {
            if (this.toMapBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.toMapBuildStage == 0) {
                this.toMapBuildStage = (byte)-1;
                this.toMap = ImmutableMember.super.toMap();
                this.toMapBuildStage = 1;
            }
            return this.toMap;
        }

        void toMap(boolean toMap) {
            this.toMap = toMap;
            this.toMapBuildStage = 1;
        }

        boolean validatesIntegerRange() {
            if (this.validatesIntegerRangeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatesIntegerRangeBuildStage == 0) {
                this.validatesIntegerRangeBuildStage = (byte)-1;
                this.validatesIntegerRange = ImmutableMember.super.validatesIntegerRange();
                this.validatesIntegerRangeBuildStage = 1;
            }
            return this.validatesIntegerRange;
        }

        void validatesIntegerRange(boolean validatesIntegerRange) {
            this.validatesIntegerRange = validatesIntegerRange;
            this.validatesIntegerRangeBuildStage = 1;
        }

        boolean validatesLongRange() {
            if (this.validatesLongRangeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatesLongRangeBuildStage == 0) {
                this.validatesLongRangeBuildStage = (byte)-1;
                this.validatesLongRange = ImmutableMember.super.validatesLongRange();
                this.validatesLongRangeBuildStage = 1;
            }
            return this.validatesLongRange;
        }

        void validatesLongRange(boolean validatesLongRange) {
            this.validatesLongRange = validatesLongRange;
            this.validatesLongRangeBuildStage = 1;
        }

        boolean validatesDoubleRange() {
            if (this.validatesDoubleRangeBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatesDoubleRangeBuildStage == 0) {
                this.validatesDoubleRangeBuildStage = (byte)-1;
                this.validatesDoubleRange = ImmutableMember.super.validatesDoubleRange();
                this.validatesDoubleRangeBuildStage = 1;
            }
            return this.validatesDoubleRange;
        }

        void validatesDoubleRange(boolean validatesDoubleRange) {
            this.validatesDoubleRange = validatesDoubleRange;
            this.validatesDoubleRangeBuildStage = 1;
        }

        boolean validates() {
            if (this.validatesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.validatesBuildStage == 0) {
                this.validatesBuildStage = (byte)-1;
                this.validates = ImmutableMember.super.validates();
                this.validatesBuildStage = 1;
            }
            return this.validates;
        }

        void validates(boolean validates) {
            this.validates = validates;
            this.validatesBuildStage = 1;
        }

        boolean graphStoreValidation() {
            if (this.graphStoreValidationBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.graphStoreValidationBuildStage == 0) {
                this.graphStoreValidationBuildStage = (byte)-1;
                this.graphStoreValidation = ImmutableMember.super.graphStoreValidation();
                this.graphStoreValidationBuildStage = 1;
            }
            return this.graphStoreValidation;
        }

        void graphStoreValidation(boolean graphStoreValidation) {
            this.graphStoreValidation = graphStoreValidation;
            this.graphStoreValidationBuildStage = 1;
        }

        boolean graphStoreValidationCheck() {
            if (this.graphStoreValidationCheckBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.graphStoreValidationCheckBuildStage == 0) {
                this.graphStoreValidationCheckBuildStage = (byte)-1;
                this.graphStoreValidationCheck = ImmutableMember.super.graphStoreValidationCheck();
                this.graphStoreValidationCheckBuildStage = 1;
            }
            return this.graphStoreValidationCheck;
        }

        void graphStoreValidationCheck(boolean graphStoreValidationCheck) {
            this.graphStoreValidationCheck = graphStoreValidationCheck;
            this.graphStoreValidationCheckBuildStage = 1;
        }

        boolean normalizes() {
            if (this.normalizesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.normalizesBuildStage == 0) {
                this.normalizesBuildStage = (byte)-1;
                this.normalizes = ImmutableMember.super.normalizes();
                this.normalizesBuildStage = 1;
            }
            return this.normalizes;
        }

        void normalizes(boolean normalizes) {
            this.normalizes = normalizes;
            this.normalizesBuildStage = 1;
        }

        String methodName() {
            if (this.methodNameBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.methodNameBuildStage == 0) {
                this.methodNameBuildStage = (byte)-1;
                this.methodName = Objects.requireNonNull(ImmutableMember.super.methodName(), "methodName");
                this.methodNameBuildStage = 1;
            }
            return this.methodName;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.lookupKeyBuildStage == -1) {
                attributes.add("lookupKey");
            }
            if (this.collectsKeysBuildStage == -1) {
                attributes.add("collectsKeys");
            }
            if (this.toMapBuildStage == -1) {
                attributes.add("toMap");
            }
            if (this.validatesIntegerRangeBuildStage == -1) {
                attributes.add("validatesIntegerRange");
            }
            if (this.validatesLongRangeBuildStage == -1) {
                attributes.add("validatesLongRange");
            }
            if (this.validatesDoubleRangeBuildStage == -1) {
                attributes.add("validatesDoubleRange");
            }
            if (this.validatesBuildStage == -1) {
                attributes.add("validates");
            }
            if (this.graphStoreValidationBuildStage == -1) {
                attributes.add("graphStoreValidation");
            }
            if (this.graphStoreValidationCheckBuildStage == -1) {
                attributes.add("graphStoreValidationCheck");
            }
            if (this.normalizesBuildStage == -1) {
                attributes.add("normalizes");
            }
            if (this.methodNameBuildStage == -1) {
                attributes.add("methodName");
            }
            return "Cannot build Member, attribute initializers form cycle " + attributes;
        }
    }
}

