/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.squareup.javapoet.CodeBlock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.UnaryOperator;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;
import org.neo4j.gds.proc.ConfigParser;
import org.neo4j.gds.proc.GenerateConfiguration;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="GenerateConfiguration.MemberDefinition", generator="Immutables")
@Immutable
public final class ImmutableMemberDefinition
implements GenerateConfiguration.MemberDefinition {
    private final ConfigParser.Member member;
    private final TypeMirror fieldType;
    private final TypeMirror parameterType;
    private final String fieldName;
    private final String configParamName;
    private final String methodPrefix;
    private final String methodName;
    private final String configKey;
    @Nullable
    private final CodeBlock defaultProvider;
    @Nullable
    private final CodeBlock expectedType;
    private final List<UnaryOperator<CodeBlock>> converters;

    private ImmutableMemberDefinition(ConfigParser.Member member, TypeMirror fieldType, TypeMirror parameterType, String fieldName, String configParamName, String methodPrefix, String methodName, String configKey, Optional<? extends CodeBlock> defaultProvider, Optional<? extends CodeBlock> expectedType, Iterable<? extends UnaryOperator<CodeBlock>> converters) {
        this.member = Objects.requireNonNull(member, "member");
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType");
        this.parameterType = Objects.requireNonNull(parameterType, "parameterType");
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        this.configParamName = Objects.requireNonNull(configParamName, "configParamName");
        this.methodPrefix = Objects.requireNonNull(methodPrefix, "methodPrefix");
        this.methodName = Objects.requireNonNull(methodName, "methodName");
        this.configKey = Objects.requireNonNull(configKey, "configKey");
        this.defaultProvider = defaultProvider.orElse(null);
        this.expectedType = expectedType.orElse(null);
        this.converters = ImmutableMemberDefinition.createUnmodifiableList(false, ImmutableMemberDefinition.createSafeList(converters, true, false));
    }

    private ImmutableMemberDefinition(ConfigParser.Member member, TypeMirror fieldType, TypeMirror parameterType, String fieldName, String configParamName, String methodPrefix, String methodName, String configKey, @Nullable CodeBlock defaultProvider, @Nullable CodeBlock expectedType, Iterable<? extends UnaryOperator<CodeBlock>> converters) {
        this.member = Objects.requireNonNull(member, "member");
        this.fieldType = Objects.requireNonNull(fieldType, "fieldType");
        this.parameterType = Objects.requireNonNull(parameterType, "parameterType");
        this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
        this.configParamName = Objects.requireNonNull(configParamName, "configParamName");
        this.methodPrefix = Objects.requireNonNull(methodPrefix, "methodPrefix");
        this.methodName = Objects.requireNonNull(methodName, "methodName");
        this.configKey = Objects.requireNonNull(configKey, "configKey");
        this.defaultProvider = defaultProvider;
        this.expectedType = expectedType;
        this.converters = ImmutableMemberDefinition.createUnmodifiableList(false, ImmutableMemberDefinition.createSafeList(converters, true, false));
    }

    private ImmutableMemberDefinition(ImmutableMemberDefinition original, ConfigParser.Member member, TypeMirror fieldType, TypeMirror parameterType, String fieldName, String configParamName, String methodPrefix, String methodName, String configKey, @Nullable CodeBlock defaultProvider, @Nullable CodeBlock expectedType, List<UnaryOperator<CodeBlock>> converters) {
        this.member = member;
        this.fieldType = fieldType;
        this.parameterType = parameterType;
        this.fieldName = fieldName;
        this.configParamName = configParamName;
        this.methodPrefix = methodPrefix;
        this.methodName = methodName;
        this.configKey = configKey;
        this.defaultProvider = defaultProvider;
        this.expectedType = expectedType;
        this.converters = converters;
    }

    @Override
    public ConfigParser.Member member() {
        return this.member;
    }

    @Override
    public TypeMirror fieldType() {
        return this.fieldType;
    }

    @Override
    public TypeMirror parameterType() {
        return this.parameterType;
    }

    @Override
    public String fieldName() {
        return this.fieldName;
    }

    @Override
    public String configParamName() {
        return this.configParamName;
    }

    @Override
    public String methodPrefix() {
        return this.methodPrefix;
    }

    @Override
    public String methodName() {
        return this.methodName;
    }

    @Override
    public String configKey() {
        return this.configKey;
    }

    @Override
    public Optional<CodeBlock> defaultProvider() {
        return Optional.ofNullable(this.defaultProvider);
    }

    @Override
    public Optional<CodeBlock> expectedType() {
        return Optional.ofNullable(this.expectedType);
    }

    @Override
    public List<UnaryOperator<CodeBlock>> converters() {
        return this.converters;
    }

    public final ImmutableMemberDefinition withMember(ConfigParser.Member value) {
        if (this.member == value) {
            return this;
        }
        ConfigParser.Member newValue = Objects.requireNonNull(value, "member");
        return new ImmutableMemberDefinition(this, newValue, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withFieldType(TypeMirror value) {
        if (this.fieldType == value) {
            return this;
        }
        TypeMirror newValue = Objects.requireNonNull(value, "fieldType");
        return new ImmutableMemberDefinition(this, this.member, newValue, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withParameterType(TypeMirror value) {
        if (this.parameterType == value) {
            return this;
        }
        TypeMirror newValue = Objects.requireNonNull(value, "parameterType");
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, newValue, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withFieldName(String value) {
        String newValue = Objects.requireNonNull(value, "fieldName");
        if (this.fieldName.equals(newValue)) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, newValue, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withConfigParamName(String value) {
        String newValue = Objects.requireNonNull(value, "configParamName");
        if (this.configParamName.equals(newValue)) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, newValue, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withMethodPrefix(String value) {
        String newValue = Objects.requireNonNull(value, "methodPrefix");
        if (this.methodPrefix.equals(newValue)) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, newValue, this.methodName, this.configKey, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withMethodName(String value) {
        String newValue = Objects.requireNonNull(value, "methodName");
        if (this.methodName.equals(newValue)) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, newValue, this.configKey, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withConfigKey(String value) {
        String newValue = Objects.requireNonNull(value, "configKey");
        if (this.configKey.equals(newValue)) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, newValue, this.defaultProvider, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withDefaultProvider(@Nullable CodeBlock value) {
        CodeBlock newValue = value;
        if (this.defaultProvider == newValue) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, newValue, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withDefaultProvider(Optional<? extends CodeBlock> optional) {
        CodeBlock value = optional.orElse(null);
        if (this.defaultProvider == value) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, value, this.expectedType, this.converters);
    }

    public final ImmutableMemberDefinition withExpectedType(@Nullable CodeBlock value) {
        CodeBlock newValue = value;
        if (this.expectedType == newValue) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, newValue, this.converters);
    }

    public final ImmutableMemberDefinition withExpectedType(Optional<? extends CodeBlock> optional) {
        CodeBlock value = optional.orElse(null);
        if (this.expectedType == value) {
            return this;
        }
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, value, this.converters);
    }

    @SafeVarargs
    public final ImmutableMemberDefinition withConverters(UnaryOperator<CodeBlock> ... elements) {
        List<UnaryOperator<CodeBlock>> newValue = ImmutableMemberDefinition.createUnmodifiableList(false, ImmutableMemberDefinition.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, newValue);
    }

    public final ImmutableMemberDefinition withConverters(Iterable<? extends UnaryOperator<CodeBlock>> elements) {
        if (this.converters == elements) {
            return this;
        }
        List<UnaryOperator<CodeBlock>> newValue = ImmutableMemberDefinition.createUnmodifiableList(false, ImmutableMemberDefinition.createSafeList(elements, true, false));
        return new ImmutableMemberDefinition(this, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableMemberDefinition && this.equalTo((ImmutableMemberDefinition)another);
    }

    private boolean equalTo(ImmutableMemberDefinition another) {
        return this.member.equals(another.member) && this.fieldType.equals(another.fieldType) && this.parameterType.equals(another.parameterType) && this.fieldName.equals(another.fieldName) && this.configParamName.equals(another.configParamName) && this.methodPrefix.equals(another.methodPrefix) && this.methodName.equals(another.methodName) && this.configKey.equals(another.configKey) && Objects.equals(this.defaultProvider, another.defaultProvider) && Objects.equals(this.expectedType, another.expectedType) && this.converters.equals(another.converters);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.member.hashCode();
        h += (h << 5) + this.fieldType.hashCode();
        h += (h << 5) + this.parameterType.hashCode();
        h += (h << 5) + this.fieldName.hashCode();
        h += (h << 5) + this.configParamName.hashCode();
        h += (h << 5) + this.methodPrefix.hashCode();
        h += (h << 5) + this.methodName.hashCode();
        h += (h << 5) + this.configKey.hashCode();
        h += (h << 5) + Objects.hashCode(this.defaultProvider);
        h += (h << 5) + Objects.hashCode(this.expectedType);
        h += (h << 5) + this.converters.hashCode();
        return h;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("MemberDefinition{");
        builder.append("member=").append(this.member);
        builder.append(", ");
        builder.append("fieldType=").append(this.fieldType);
        builder.append(", ");
        builder.append("parameterType=").append(this.parameterType);
        builder.append(", ");
        builder.append("fieldName=").append(this.fieldName);
        builder.append(", ");
        builder.append("configParamName=").append(this.configParamName);
        builder.append(", ");
        builder.append("methodPrefix=").append(this.methodPrefix);
        builder.append(", ");
        builder.append("methodName=").append(this.methodName);
        builder.append(", ");
        builder.append("configKey=").append(this.configKey);
        if (this.defaultProvider != null) {
            builder.append(", ");
            builder.append("defaultProvider=").append(this.defaultProvider);
        }
        if (this.expectedType != null) {
            builder.append(", ");
            builder.append("expectedType=").append(this.expectedType);
        }
        builder.append(", ");
        builder.append("converters=").append(this.converters);
        return builder.append("}").toString();
    }

    public static GenerateConfiguration.MemberDefinition of(ConfigParser.Member member, TypeMirror fieldType, TypeMirror parameterType, String fieldName, String configParamName, String methodPrefix, String methodName, String configKey, Optional<CodeBlock> defaultProvider, Optional<CodeBlock> expectedType, List<UnaryOperator<CodeBlock>> converters) {
        return ImmutableMemberDefinition.of(member, fieldType, parameterType, fieldName, configParamName, methodPrefix, methodName, configKey, defaultProvider, expectedType, converters);
    }

    public static GenerateConfiguration.MemberDefinition of(ConfigParser.Member member, TypeMirror fieldType, TypeMirror parameterType, String fieldName, String configParamName, String methodPrefix, String methodName, String configKey, Optional<? extends CodeBlock> defaultProvider, Optional<? extends CodeBlock> expectedType, Iterable<? extends UnaryOperator<CodeBlock>> converters) {
        return new ImmutableMemberDefinition(member, fieldType, parameterType, fieldName, configParamName, methodPrefix, methodName, configKey, defaultProvider, expectedType, converters);
    }

    public static GenerateConfiguration.MemberDefinition of(ConfigParser.Member member, TypeMirror fieldType, TypeMirror parameterType, String fieldName, String configParamName, String methodPrefix, String methodName, String configKey, @Nullable CodeBlock defaultProvider, @Nullable CodeBlock expectedType, Iterable<? extends UnaryOperator<CodeBlock>> converters) {
        return new ImmutableMemberDefinition(member, fieldType, parameterType, fieldName, configParamName, methodPrefix, methodName, configKey, defaultProvider, expectedType, converters);
    }

    static GenerateConfiguration.MemberDefinition copyOf(GenerateConfiguration.MemberDefinition instance) {
        if (instance instanceof ImmutableMemberDefinition) {
            return (ImmutableMemberDefinition)instance;
        }
        return ImmutableMemberDefinition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GenerateConfiguration.MemberDefinition", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_MEMBER = 1L;
        private static final long INIT_BIT_FIELD_TYPE = 2L;
        private static final long INIT_BIT_PARAMETER_TYPE = 4L;
        private static final long INIT_BIT_FIELD_NAME = 8L;
        private static final long INIT_BIT_CONFIG_PARAM_NAME = 16L;
        private static final long INIT_BIT_METHOD_PREFIX = 32L;
        private static final long INIT_BIT_METHOD_NAME = 64L;
        private static final long INIT_BIT_CONFIG_KEY = 128L;
        private long initBits = 255L;
        @Nullable
        private ConfigParser.Member member;
        @Nullable
        private TypeMirror fieldType;
        @Nullable
        private TypeMirror parameterType;
        @Nullable
        private String fieldName;
        @Nullable
        private String configParamName;
        @Nullable
        private String methodPrefix;
        @Nullable
        private String methodName;
        @Nullable
        private String configKey;
        @Nullable
        private CodeBlock defaultProvider;
        @Nullable
        private CodeBlock expectedType;
        private List<UnaryOperator<CodeBlock>> converters = null;

        private Builder() {
        }

        public final Builder from(ImmutableMemberDefinition instance) {
            return this.from((GenerateConfiguration.MemberDefinition)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GenerateConfiguration.MemberDefinition instance) {
            Optional<CodeBlock> expectedTypeOptional;
            Objects.requireNonNull(instance, "instance");
            this.member(instance.member());
            this.fieldType(instance.fieldType());
            this.parameterType(instance.parameterType());
            this.fieldName(instance.fieldName());
            this.configParamName(instance.configParamName());
            this.methodPrefix(instance.methodPrefix());
            this.methodName(instance.methodName());
            this.configKey(instance.configKey());
            Optional<CodeBlock> defaultProviderOptional = instance.defaultProvider();
            if (defaultProviderOptional.isPresent()) {
                this.defaultProvider(defaultProviderOptional);
            }
            if ((expectedTypeOptional = instance.expectedType()).isPresent()) {
                this.expectedType(expectedTypeOptional);
            }
            this.addAllConverters(instance.converters());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder member(ConfigParser.Member member) {
            this.member = Objects.requireNonNull(member, "member");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fieldType(TypeMirror fieldType) {
            this.fieldType = Objects.requireNonNull(fieldType, "fieldType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder parameterType(TypeMirror parameterType) {
            this.parameterType = Objects.requireNonNull(parameterType, "parameterType");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fieldName(String fieldName) {
            this.fieldName = Objects.requireNonNull(fieldName, "fieldName");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configParamName(String configParamName) {
            this.configParamName = Objects.requireNonNull(configParamName, "configParamName");
            this.initBits &= 0xFFFFFFFFFFFFFFEFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methodPrefix(String methodPrefix) {
            this.methodPrefix = Objects.requireNonNull(methodPrefix, "methodPrefix");
            this.initBits &= 0xFFFFFFFFFFFFFFDFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder methodName(String methodName) {
            this.methodName = Objects.requireNonNull(methodName, "methodName");
            this.initBits &= 0xFFFFFFFFFFFFFFBFL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder configKey(String configKey) {
            this.configKey = Objects.requireNonNull(configKey, "configKey");
            this.initBits &= 0xFFFFFFFFFFFFFF7FL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultProvider(@Nullable CodeBlock defaultProvider) {
            this.defaultProvider = defaultProvider;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder defaultProvider(Optional<? extends CodeBlock> defaultProvider) {
            this.defaultProvider = defaultProvider.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedType(@Nullable CodeBlock expectedType) {
            this.expectedType = expectedType;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder expectedType(Optional<? extends CodeBlock> expectedType) {
            this.expectedType = expectedType.orElse(null);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addConverter(UnaryOperator<CodeBlock> element) {
            if (this.converters == null) {
                this.converters = new ArrayList<UnaryOperator<CodeBlock>>();
            }
            this.converters.add(Objects.requireNonNull(element, "converters element"));
            return this;
        }

        @SafeVarargs
        @CanIgnoreReturnValue
        public final Builder addConverters(UnaryOperator<CodeBlock> ... elements) {
            if (this.converters == null) {
                this.converters = new ArrayList<UnaryOperator<CodeBlock>>();
            }
            for (UnaryOperator<CodeBlock> element : elements) {
                this.converters.add(Objects.requireNonNull(element, "converters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder converters(Iterable<? extends UnaryOperator<CodeBlock>> elements) {
            this.converters = new ArrayList<UnaryOperator<CodeBlock>>();
            return this.addAllConverters(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllConverters(Iterable<? extends UnaryOperator<CodeBlock>> elements) {
            Objects.requireNonNull(elements, "converters element");
            if (this.converters == null) {
                this.converters = new ArrayList<UnaryOperator<CodeBlock>>();
            }
            for (UnaryOperator<CodeBlock> unaryOperator : elements) {
                this.converters.add(Objects.requireNonNull(unaryOperator, "converters element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 255L;
            this.member = null;
            this.fieldType = null;
            this.parameterType = null;
            this.fieldName = null;
            this.configParamName = null;
            this.methodPrefix = null;
            this.methodName = null;
            this.configKey = null;
            this.defaultProvider = null;
            this.expectedType = null;
            if (this.converters != null) {
                this.converters.clear();
            }
            return this;
        }

        public GenerateConfiguration.MemberDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableMemberDefinition(null, this.member, this.fieldType, this.parameterType, this.fieldName, this.configParamName, this.methodPrefix, this.methodName, this.configKey, this.defaultProvider, this.expectedType, this.converters == null ? Collections.emptyList() : ImmutableMemberDefinition.createUnmodifiableList(true, this.converters));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("member");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("fieldType");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("parameterType");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("fieldName");
            }
            if ((this.initBits & 0x10L) != 0L) {
                attributes.add("configParamName");
            }
            if ((this.initBits & 0x20L) != 0L) {
                attributes.add("methodPrefix");
            }
            if ((this.initBits & 0x40L) != 0L) {
                attributes.add("methodName");
            }
            if ((this.initBits & 0x80L) != 0L) {
                attributes.add("configKey");
            }
            return "Cannot build MemberDefinition, some of required attributes are not set " + attributes;
        }
    }
}

