/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.proc;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.TypeMirror;
import org.immutables.value.Generated;
import org.neo4j.gds.proc.ConfigParser;

@ParametersAreNonnullByDefault
@CheckReturnValue
@Generated(from="ConfigParser.Spec", generator="Immutables")
@Immutable
public final class ImmutableSpec
implements ConfigParser.Spec {
    private final TypeElement root;
    private final TypeMirror rootType;
    private final List<ConfigParser.Member> members;

    private ImmutableSpec(TypeElement root, TypeMirror rootType, Iterable<? extends ConfigParser.Member> members) {
        this.root = Objects.requireNonNull(root, "root");
        this.rootType = Objects.requireNonNull(rootType, "rootType");
        this.members = ImmutableSpec.createUnmodifiableList(false, ImmutableSpec.createSafeList(members, true, false));
    }

    private ImmutableSpec(ImmutableSpec original, TypeElement root, TypeMirror rootType, List<ConfigParser.Member> members) {
        this.root = root;
        this.rootType = rootType;
        this.members = members;
    }

    @Override
    public TypeElement root() {
        return this.root;
    }

    @Override
    public TypeMirror rootType() {
        return this.rootType;
    }

    @Override
    public List<ConfigParser.Member> members() {
        return this.members;
    }

    public final ImmutableSpec withRoot(TypeElement value) {
        if (this.root == value) {
            return this;
        }
        TypeElement newValue = Objects.requireNonNull(value, "root");
        return new ImmutableSpec(this, newValue, this.rootType, this.members);
    }

    public final ImmutableSpec withRootType(TypeMirror value) {
        if (this.rootType == value) {
            return this;
        }
        TypeMirror newValue = Objects.requireNonNull(value, "rootType");
        return new ImmutableSpec(this, this.root, newValue, this.members);
    }

    public final ImmutableSpec withMembers(ConfigParser.Member ... elements) {
        List<ConfigParser.Member> newValue = ImmutableSpec.createUnmodifiableList(false, ImmutableSpec.createSafeList(Arrays.asList(elements), true, false));
        return new ImmutableSpec(this, this.root, this.rootType, newValue);
    }

    public final ImmutableSpec withMembers(Iterable<? extends ConfigParser.Member> elements) {
        if (this.members == elements) {
            return this;
        }
        List<ConfigParser.Member> newValue = ImmutableSpec.createUnmodifiableList(false, ImmutableSpec.createSafeList(elements, true, false));
        return new ImmutableSpec(this, this.root, this.rootType, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableSpec && this.equalTo((ImmutableSpec)another);
    }

    private boolean equalTo(ImmutableSpec another) {
        return this.root.equals(another.root) && this.rootType.equals(another.rootType) && this.members.equals(another.members);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.root.hashCode();
        h += (h << 5) + this.rootType.hashCode();
        h += (h << 5) + this.members.hashCode();
        return h;
    }

    public String toString() {
        return "Spec{root=" + this.root + ", rootType=" + this.rootType + ", members=" + this.members + "}";
    }

    public static ConfigParser.Spec of(TypeElement root, TypeMirror rootType, List<ConfigParser.Member> members) {
        return ImmutableSpec.of(root, rootType, members);
    }

    public static ConfigParser.Spec of(TypeElement root, TypeMirror rootType, Iterable<? extends ConfigParser.Member> members) {
        return new ImmutableSpec(root, rootType, members);
    }

    static ConfigParser.Spec copyOf(ConfigParser.Spec instance) {
        if (instance instanceof ImmutableSpec) {
            return (ImmutableSpec)instance;
        }
        return ImmutableSpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="ConfigParser.Spec", generator="Immutables")
    @NotThreadSafe
    static final class Builder {
        private static final long INIT_BIT_ROOT = 1L;
        private static final long INIT_BIT_ROOT_TYPE = 2L;
        private long initBits = 3L;
        @Nullable
        private TypeElement root;
        @Nullable
        private TypeMirror rootType;
        private List<ConfigParser.Member> members = null;

        private Builder() {
        }

        public final Builder from(ImmutableSpec instance) {
            return this.from((ConfigParser.Spec)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(ConfigParser.Spec instance) {
            Objects.requireNonNull(instance, "instance");
            this.root(instance.root());
            this.rootType(instance.rootType());
            this.addAllMembers(instance.members());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder root(TypeElement root) {
            this.root = Objects.requireNonNull(root, "root");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder rootType(TypeMirror rootType) {
            this.rootType = Objects.requireNonNull(rootType, "rootType");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMember(ConfigParser.Member element) {
            if (this.members == null) {
                this.members = new ArrayList<ConfigParser.Member>();
            }
            this.members.add(Objects.requireNonNull(element, "members element"));
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addMembers(ConfigParser.Member ... elements) {
            if (this.members == null) {
                this.members = new ArrayList<ConfigParser.Member>();
            }
            for (ConfigParser.Member element : elements) {
                this.members.add(Objects.requireNonNull(element, "members element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder members(Iterable<? extends ConfigParser.Member> elements) {
            this.members = new ArrayList<ConfigParser.Member>();
            return this.addAllMembers(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllMembers(Iterable<? extends ConfigParser.Member> elements) {
            Objects.requireNonNull(elements, "members element");
            if (this.members == null) {
                this.members = new ArrayList<ConfigParser.Member>();
            }
            for (ConfigParser.Member member : elements) {
                this.members.add(Objects.requireNonNull(member, "members element"));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder clear() {
            this.initBits = 3L;
            this.root = null;
            this.rootType = null;
            if (this.members != null) {
                this.members.clear();
            }
            return this;
        }

        public ConfigParser.Spec build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableSpec(null, this.root, this.rootType, this.members == null ? Collections.emptyList() : ImmutableSpec.createUnmodifiableList(true, this.members));
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("root");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("rootType");
            }
            return "Cannot build Spec, some of required attributes are not set " + attributes;
        }
    }
}

