/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.annotation.CustomProcedure;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.IdMap;
import org.neo4j.gds.api.PartialIdMap;
import org.neo4j.gds.api.schema.ImmutableMutableGraphSchema;
import org.neo4j.gds.api.schema.MutableGraphSchema;
import org.neo4j.gds.api.schema.MutableNodeSchema;
import org.neo4j.gds.api.schema.MutableRelationshipSchema;
import org.neo4j.gds.compat.CompatUserAggregator;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.Aggregation;
import org.neo4j.gds.core.ConfigKeyValidation;
import org.neo4j.gds.core.compress.AdjacencyCompressor;
import org.neo4j.gds.core.loading.CSRGraphStore;
import org.neo4j.gds.core.loading.Capabilities;
import org.neo4j.gds.core.loading.GraphStoreBuilder;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.HighLimitIdMap;
import org.neo4j.gds.core.loading.ImmutableNodes;
import org.neo4j.gds.core.loading.ImmutableRelationshipImportResult;
import org.neo4j.gds.core.loading.ImmutableStaticCapabilities;
import org.neo4j.gds.core.loading.LazyIdMapBuilder;
import org.neo4j.gds.core.loading.Nodes;
import org.neo4j.gds.core.loading.ReadHelper;
import org.neo4j.gds.core.loading.RelationshipImportResult;
import org.neo4j.gds.core.loading.SingleTypeRelationships;
import org.neo4j.gds.core.loading.construction.GraphFactory;
import org.neo4j.gds.core.loading.construction.ImmutablePropertyConfig;
import org.neo4j.gds.core.loading.construction.NodeLabelToken;
import org.neo4j.gds.core.loading.construction.NodeLabelTokens;
import org.neo4j.gds.core.loading.construction.PropertyValues;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilder;
import org.neo4j.gds.core.loading.construction.RelationshipsBuilderBuilder;
import org.neo4j.gds.core.utils.ProgressTimer;
import org.neo4j.gds.projection.AggregationResult;
import org.neo4j.gds.projection.AggregationResultImpl;
import org.neo4j.gds.projection.CypherAggregation;
import org.neo4j.gds.projection.ExtractNodeId;
import org.neo4j.gds.projection.GraphProjectFromCypherAggregationConfig;
import org.neo4j.gds.projection.ReadNodeLabels;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.internal.kernel.api.exceptions.ProcedureException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.util.ValueUtils;
import org.neo4j.procedure.Name;
import org.neo4j.values.AnyValue;
import org.neo4j.values.ValueMapper;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.Values;
import org.neo4j.values.virtual.MapValue;
import org.neo4j.values.virtual.MapValueBuilder;

public class GraphAggregator
implements CompatUserAggregator {
    private final DatabaseId databaseId;
    private final String username;
    private final boolean canWriteToDatabase;
    private final ProgressTimer progressTimer;
    private final ConfigValidator configValidator;
    private final Lock lock;
    @Nullable
    private volatile GraphImporter importer;
    @Nullable
    private AggregationResult result;

    GraphAggregator(DatabaseId databaseId, String username, boolean canWriteToDatabase) {
        this.databaseId = databaseId;
        this.username = username;
        this.canWriteToDatabase = canWriteToDatabase;
        this.progressTimer = ProgressTimer.start();
        this.lock = new ReentrantLock();
        this.configValidator = new ConfigValidator();
    }

    @CustomProcedure(value="gds.alpha.graph.project")
    public AggregationResult procedureSyntax(@Name(value="graphName") TextValue graphName, @Name(value="sourceNode") AnyValue sourceNode, @Name(value="targetNode") AnyValue targetNode, @Name(value="nodesConfig") AnyValue nodesConfig, @Name(value="relationshipConfig") AnyValue relationshipConfig, @Name(value="configuration") AnyValue config) {
        throw new UnsupportedOperationException("This method is only used to document the procedure syntax.");
    }

    public void update(AnyValue[] input) throws ProcedureException {
        try {
            this.projectNextRelationship((TextValue)input[0], input[1], input[2], input[3], input[4], input[5]);
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to invoke function `%s`: Caused by: %s", new Object[]{CypherAggregation.FUNCTION_NAME, e});
        }
    }

    void projectNextRelationship(TextValue graphName, AnyValue sourceNode, AnyValue targetNode, AnyValue nodesConfig, AnyValue relationshipConfig, AnyValue config) {
        this.configValidator.validateConfigs(nodesConfig, relationshipConfig);
        GraphImporter data = this.initGraphData(graphName, config);
        MapValue sourceNodePropertyValues = null;
        MapValue targetNodePropertyValues = null;
        NodeLabelToken sourceNodeLabels = NodeLabelTokens.missing();
        NodeLabelToken targetNodeLabels = NodeLabelTokens.missing();
        this.configValidator.validateConfigs(nodesConfig, relationshipConfig);
        if (nodesConfig instanceof MapValue) {
            sourceNodePropertyValues = GraphImporter.propertiesConfig("sourceNodeProperties", (MapValue)nodesConfig);
            sourceNodeLabels = GraphAggregator.labelsConfig("sourceNodeLabels", (MapValue)nodesConfig);
            if (targetNode != NoValue.NO_VALUE) {
                targetNodePropertyValues = GraphImporter.propertiesConfig("targetNodeProperties", (MapValue)nodesConfig);
                targetNodeLabels = GraphAggregator.labelsConfig("targetNodeLabels", (MapValue)nodesConfig);
            }
        }
        data.update(sourceNode, targetNode, sourceNodePropertyValues, targetNodePropertyValues, sourceNodeLabels, targetNodeLabels, relationshipConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private GraphImporter initGraphData(TextValue graphName, AnyValue config) {
        GraphImporter data = this.importer;
        if (data != null) {
            return data;
        }
        this.lock.lock();
        try {
            data = this.importer;
            if (data == null) {
                this.importer = data = GraphImporter.of(graphName, this.username, this.databaseId, config, this.canWriteToDatabase);
            }
            GraphImporter graphImporter = data;
            return graphImporter;
        }
        finally {
            this.lock.unlock();
        }
    }

    private static NodeLabelToken labelsConfig(String nodeLabelKey, @NotNull MapValue nodesConfig) {
        AnyValue nodeLabelsEntry = nodesConfig.get(nodeLabelKey);
        return GraphAggregator.tryLabelsConfig(nodeLabelsEntry, nodeLabelKey);
    }

    private static NodeLabelToken tryLabelsConfig(AnyValue nodeLabels, String nodeLabelKey) {
        NodeLabelToken nodeLabelToken = (NodeLabelToken)nodeLabels.map((ValueMapper)ReadNodeLabels.INSTANCE);
        if (nodeLabelToken.isInvalid()) {
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `%s` must be either a `List of Strings`, a `String`, or a `Boolean`, but was `%s`.", (Object[])new Object[]{nodeLabelKey, nodeLabels.getTypeName()}));
        }
        return nodeLabelToken;
    }

    public AnyValue result() throws ProcedureException {
        AggregationResult result;
        try {
            result = this.buildGraph();
        }
        catch (Exception e) {
            throw new ProcedureException((Status)Status.Procedure.ProcedureCallFailed, (Throwable)e, "Failed to invoke function `%s`: Caused by: %s", new Object[]{CypherAggregation.FUNCTION_NAME, e});
        }
        if (result == null) {
            return Values.NO_VALUE;
        }
        MapValueBuilder builder = new MapValueBuilder(6);
        builder.add("graphName", (AnyValue)Values.stringValue((String)result.graphName()));
        builder.add("nodeCount", (AnyValue)Values.longValue((long)result.nodeCount()));
        builder.add("relationshipCount", (AnyValue)Values.longValue((long)result.relationshipCount()));
        builder.add("projectMillis", (AnyValue)Values.longValue((long)result.projectMillis()));
        builder.add("configuration", ValueUtils.asAnyValue(result.configuration()));
        return builder.build();
    }

    @Nullable
    public AggregationResult buildGraph() {
        GraphImporter importer = this.importer;
        if (importer == null) {
            return null;
        }
        if (this.result != null) {
            return this.result;
        }
        this.result = importer.result(this.username, this.databaseId, this.progressTimer);
        return this.result;
    }

    private static final class GraphImporter {
        private final String graphName;
        private final GraphProjectFromCypherAggregationConfig config;
        private final LazyIdMapBuilder idMapBuilder;
        private final boolean canWriteToDatabase;
        private final ExtractNodeId extractNodeId;
        private final Map<RelationshipType, RelationshipsBuilder> relImporters;
        private final ImmutableMutableGraphSchema.Builder graphSchemaBuilder;

        private GraphImporter(String graphName, GraphProjectFromCypherAggregationConfig config, LazyIdMapBuilder idMapBuilder, boolean canWriteToDatabase) {
            this.graphName = graphName;
            this.config = config;
            this.idMapBuilder = idMapBuilder;
            this.canWriteToDatabase = canWriteToDatabase;
            this.relImporters = new ConcurrentHashMap<RelationshipType, RelationshipsBuilder>();
            this.graphSchemaBuilder = MutableGraphSchema.builder();
            this.extractNodeId = new ExtractNodeId();
        }

        static GraphImporter of(TextValue graphNameValue, String username, DatabaseId databaseId, AnyValue configMap, boolean canWriteToDatabase) {
            String graphName = graphNameValue.stringValue();
            GraphImporter.validateGraphName(graphName, username, databaseId);
            GraphProjectFromCypherAggregationConfig config = GraphProjectFromCypherAggregationConfig.of(username, graphName, configMap instanceof MapValue ? (MapValue)configMap : MapValue.EMPTY);
            LazyIdMapBuilder idMapBuilder = GraphImporter.idMapBuilder(config.readConcurrency());
            return new GraphImporter(graphName, config, idMapBuilder, canWriteToDatabase);
        }

        private static void validateGraphName(String graphName, String username, DatabaseId databaseId) {
            if (GraphStoreCatalog.exists((String)username, (DatabaseId)databaseId, (String)graphName)) {
                throw new IllegalArgumentException("Graph " + graphName + " already exists");
            }
        }

        private static LazyIdMapBuilder idMapBuilder(int readConcurrency) {
            return new LazyIdMapBuilder(readConcurrency, true, true);
        }

        void update(AnyValue sourceNode, AnyValue targetNode, @Nullable MapValue sourceNodePropertyValues, @Nullable MapValue targetNodePropertyValues, NodeLabelToken sourceNodeLabels, NodeLabelToken targetNodeLabels, AnyValue relationshipConfig) {
            MapValue relationshipProperties = null;
            RelationshipType relationshipType = RelationshipType.ALL_RELATIONSHIPS;
            if (relationshipConfig instanceof MapValue) {
                relationshipProperties = GraphImporter.propertiesConfig("properties", (MapValue)relationshipConfig);
                relationshipType = GraphImporter.typeConfig("relationshipType", (MapValue)relationshipConfig);
            }
            long intermediateSourceId = this.loadNode(sourceNode, sourceNodeLabels, sourceNodePropertyValues);
            if (targetNode != NoValue.NO_VALUE) {
                RelationshipsBuilder relImporter;
                if (this.relImporters.containsKey(relationshipType)) {
                    relImporter = this.relImporters.get(relationshipType);
                } else {
                    MapValue finalRelationshipProperties = relationshipProperties;
                    relImporter = this.relImporters.computeIfAbsent(relationshipType, type -> this.newRelImporter((RelationshipType)type, finalRelationshipProperties));
                }
                long intermediateTargetId = this.loadNode(targetNode, targetNodeLabels, targetNodePropertyValues);
                if (relationshipProperties != null) {
                    if (relationshipProperties.size() == 1) {
                        relationshipProperties.foreach((key, value) -> {
                            double property = ReadHelper.extractValue((AnyValue)value, (double)Double.NaN);
                            relImporter.addFromInternal(intermediateSourceId, intermediateTargetId, property);
                        });
                    } else {
                        double[] propertyValues = new double[relationshipProperties.size()];
                        int[] index = new int[]{0};
                        relationshipProperties.foreach((key, value) -> {
                            double property = ReadHelper.extractValue((AnyValue)value, (double)Double.NaN);
                            int n = index[0];
                            index[0] = n + 1;
                            int i = n;
                            propertyValues[i] = property;
                        });
                        relImporter.addFromInternal(intermediateSourceId, intermediateTargetId, propertyValues);
                    }
                } else {
                    relImporter.addFromInternal(intermediateSourceId, intermediateTargetId);
                }
            }
        }

        AggregationResult result(String username, DatabaseId databaseId, ProgressTimer timer) {
            String graphName = this.graphName;
            GraphImporter.validateGraphName(graphName, username, databaseId);
            this.idMapBuilder.prepareForFlush();
            boolean canWriteToDatabase = this.canWriteToDatabase && !this.extractNodeId.hasSeenArbitraryIds();
            GraphStoreBuilder graphStoreBuilder = new GraphStoreBuilder().concurrency(this.config.readConcurrency()).capabilities((Capabilities)ImmutableStaticCapabilities.of((boolean)canWriteToDatabase)).databaseId(databaseId);
            AdjacencyCompressor.ValueMapper valueMapper = this.buildNodesWithProperties(graphStoreBuilder);
            this.buildRelationshipsWithProperties(graphStoreBuilder, valueMapper);
            CSRGraphStore graphStore = graphStoreBuilder.schema(this.graphSchemaBuilder.build()).build();
            GraphStoreCatalog.set((GraphProjectConfig)this.config, (GraphStore)graphStore);
            long projectMillis = timer.stop().getDuration();
            return AggregationResultImpl.builder().graphName(graphName).nodeCount(graphStore.nodeCount()).relationshipCount(graphStore.relationshipCount()).projectMillis(projectMillis).configuration(this.config.toMap()).build();
        }

        private RelationshipsBuilder newRelImporter(RelationshipType relType, @Nullable MapValue properties) {
            List<String> undirectedTypes = this.config.undirectedRelationshipTypes();
            Orientation orientation = undirectedTypes.contains(relType.name) || undirectedTypes.contains("*") ? Orientation.UNDIRECTED : Orientation.NATURAL;
            List<String> inverseIndexedRelationshipTypes = this.config.inverseIndexedRelationshipTypes();
            boolean indexInverse = inverseIndexedRelationshipTypes.contains(relType.name) || inverseIndexedRelationshipTypes.contains("*");
            RelationshipsBuilderBuilder relationshipsBuilderBuilder = GraphFactory.initRelationshipsBuilder().nodes((PartialIdMap)this.idMapBuilder).relationshipType(relType).orientation(orientation).aggregation(Aggregation.NONE).indexInverse(indexInverse).concurrency(this.config.readConcurrency());
            if (properties != null) {
                for (String propertyKey : properties.keySet()) {
                    relationshipsBuilderBuilder.addPropertyConfig(ImmutablePropertyConfig.builder().propertyKey(propertyKey).build());
                }
            }
            return relationshipsBuilderBuilder.build();
        }

        private long loadNode(@NotNull AnyValue node, NodeLabelToken nodeLabels, @Nullable MapValue nodeProperties) {
            long originalNodeId = this.extractNodeId(node);
            return nodeProperties == null ? this.idMapBuilder.addNode(originalNodeId, nodeLabels) : this.idMapBuilder.addNodeWithProperties(originalNodeId, PropertyValues.of((MapValue)nodeProperties), nodeLabels);
        }

        private AdjacencyCompressor.ValueMapper buildNodesWithProperties(GraphStoreBuilder graphStoreBuilder) {
            LazyIdMapBuilder.HighLimitIdMapAndProperties idMapAndProperties = this.idMapBuilder.build();
            HighLimitIdMap idMap = idMapAndProperties.idMap();
            MutableNodeSchema nodeSchema = idMapAndProperties.schema();
            this.graphSchemaBuilder.nodeSchema(nodeSchema);
            Nodes nodes = ImmutableNodes.builder().idMap((IdMap)idMap).schema(nodeSchema).properties(idMapAndProperties.propertyStore()).build();
            graphStoreBuilder.nodes(nodes);
            return arg_0 -> ((IdMap)idMap.rootIdMap()).toMappedNodeId(arg_0);
        }

        private void buildRelationshipsWithProperties(GraphStoreBuilder graphStoreBuilder, AdjacencyCompressor.ValueMapper valueMapper) {
            ImmutableRelationshipImportResult.Builder relationshipImportResultBuilder = RelationshipImportResult.builder();
            MutableRelationshipSchema relationshipSchema = MutableRelationshipSchema.empty();
            this.relImporters.forEach((relationshipType, relImporter) -> {
                SingleTypeRelationships relationships = relImporter.build(Optional.of(valueMapper), Optional.empty());
                relationshipSchema.set(relationships.relationshipSchemaEntry());
                relationshipImportResultBuilder.putImportResult(relationshipType, relationships);
            });
            graphStoreBuilder.relationshipImportResult(relationshipImportResultBuilder.build());
            this.graphSchemaBuilder.relationshipSchema(relationshipSchema);
            this.relImporters.clear();
        }

        @Nullable
        static MapValue propertiesConfig(String propertyKey, @NotNull MapValue propertiesConfig) {
            AnyValue nodeProperties = propertiesConfig.get(propertyKey);
            if (nodeProperties instanceof MapValue) {
                MapValue mapProperties = (MapValue)nodeProperties;
                if (mapProperties.isEmpty()) {
                    return null;
                }
                return mapProperties;
            }
            if (nodeProperties == NoValue.NO_VALUE) {
                return null;
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `%s` must be a `Map of Property Values`, but was `%s`.", (Object[])new Object[]{propertyKey, nodeProperties.getTypeName()}));
        }

        private static RelationshipType typeConfig(String relationshipTypeKey, @NotNull MapValue relationshipConfig) {
            AnyValue relationshipTypeEntry = relationshipConfig.get(relationshipTypeKey);
            if (relationshipTypeEntry instanceof TextValue) {
                return RelationshipType.of((String)((TextValue)relationshipTypeEntry).stringValue());
            }
            if (relationshipTypeEntry == NoValue.NO_VALUE) {
                return RelationshipType.ALL_RELATIONSHIPS;
            }
            throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"The value of `%s` must be `String`, but was `%s`.", (Object[])new Object[]{relationshipTypeKey, relationshipTypeEntry.valueRepresentation().valueGroup()}));
        }

        private long extractNodeId(@NotNull AnyValue node) {
            return (Long)node.map((ValueMapper)this.extractNodeId);
        }
    }

    private static final class ConfigValidator {
        private static final Set<String> NODES_CONFIG_KEYS = Set.of("sourceNodeProperties", "sourceNodeLabels", "targetNodeProperties", "targetNodeLabels");
        private static final Set<String> RELATIONSHIPS_CONFIG_KEYS = Set.of("properties", "relationshipType");
        private final AtomicBoolean validate = new AtomicBoolean(true);

        private ConfigValidator() {
        }

        void validateConfigs(AnyValue nodesConfig, AnyValue relationshipConfig) {
            if ((nodesConfig instanceof MapValue || relationshipConfig instanceof MapValue) && this.validate.get() && this.validate.getAndSet(false)) {
                if (nodesConfig instanceof MapValue) {
                    ConfigKeyValidation.requireOnlyKeysFrom(NODES_CONFIG_KEYS, (Iterable)((MapValue)nodesConfig).keySet());
                }
                if (relationshipConfig instanceof MapValue) {
                    ConfigKeyValidation.requireOnlyKeysFrom(RELATIONSHIPS_CONFIG_KEYS, (Iterable)((MapValue)relationshipConfig).keySet());
                }
            }
        }
    }
}

