/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.projection;

import org.neo4j.gds.core.loading.construction.NodeLabelToken;
import org.neo4j.gds.core.loading.construction.NodeLabelTokens;
import org.neo4j.gds.projection.PartialValueMapper;
import org.neo4j.values.AnyValue;
import org.neo4j.values.SequenceValue;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;

enum ReadNodeLabels implements PartialValueMapper<NodeLabelToken>
{
    INSTANCE;


    @Override
    public NodeLabelToken unsupported(AnyValue value) {
        return NodeLabelTokens.invalid();
    }

    @Override
    public NodeLabelToken mapSequence(SequenceValue value) {
        if (value.isEmpty()) {
            return NodeLabelTokens.empty();
        }
        return NodeLabelTokens.of((SequenceValue)value);
    }

    @Override
    public NodeLabelToken mapNoValue() {
        return NodeLabelTokens.missing();
    }

    @Override
    public NodeLabelToken mapBoolean(BooleanValue value) {
        if (value.booleanValue()) {
            throw new IllegalArgumentException("Using `true` to load all labels is deprecated, use `{ sourceNodeLabels: labels(s) }` instead");
        }
        return NodeLabelTokens.empty();
    }

    @Override
    public NodeLabelToken mapText(TextValue value) {
        return NodeLabelTokens.of((TextValue)value);
    }

    public NodeLabelToken mapTextArray(TextArray value) {
        return NodeLabelTokens.of((TextArray)value);
    }
}

