/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.Collection;
import java.util.Map;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.executor.ProcConfigParser;

public class AlgoConfigParser<CONFIG extends AlgoBaseConfig>
implements ProcConfigParser<CONFIG> {
    private final NewConfigFunction<CONFIG> newConfigFunction;
    private final String username;

    public AlgoConfigParser(String username, NewConfigFunction<CONFIG> newConfigFunction) {
        this.username = username;
        this.newConfigFunction = newConfigFunction;
    }

    @Override
    public CONFIG processInput(Map<String, Object> configuration) {
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(configuration);
        CONFIG algoConfig = this.newConfigFunction.apply(this.username, cypherMapWrapper);
        this.validateConfig(cypherMapWrapper, algoConfig.configKeys());
        return algoConfig;
    }

    private void validateConfig(CypherMapWrapper cypherConfig, Collection<String> allowedKeys) {
        cypherConfig.requireOnlyKeysFrom(allowedKeys);
    }
}

