/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.progress.EmptyTaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.core.write.RelationshipStreamExporterBuilder;
import org.neo4j.gds.transaction.SecurityContextWrapper;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.kernel.internal.GraphDatabaseAPI;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

@ValueClass
public interface ExecutionContext {
    public static final ExecutionContext EMPTY = new ExecutionContext(){

        @Override
        @Nullable
        public GraphDatabaseAPI api() {
            return null;
        }

        @Override
        @Nullable
        public ModelCatalog modelCatalog() {
            return null;
        }

        @Override
        @Nullable
        public Log log() {
            return NullLog.getInstance();
        }

        @Override
        @Nullable
        public Transaction procedureTransaction() {
            return null;
        }

        @Override
        @Nullable
        public KernelTransaction transaction() {
            return null;
        }

        @Override
        @Nullable
        public ProcedureCallContext callContext() {
            return ProcedureCallContext.EMPTY;
        }

        @Override
        @Nullable
        public TaskRegistryFactory taskRegistryFactory() {
            return EmptyTaskRegistryFactory.INSTANCE;
        }

        @Override
        @Nullable
        public UserLogRegistryFactory userLogRegistryFactory() {
            return EmptyUserLogRegistryFactory.INSTANCE;
        }

        @Override
        @Nullable
        public RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder() {
            return null;
        }

        @Override
        public String username() {
            return "";
        }
    };

    @Nullable
    public GraphDatabaseAPI api();

    @Nullable
    public ModelCatalog modelCatalog();

    @Nullable
    public Log log();

    @Nullable
    public Transaction procedureTransaction();

    @Nullable
    public KernelTransaction transaction();

    @Value.Lazy
    default public InternalTransaction internalTransaction() {
        return this.transaction().internalTransaction();
    }

    @Nullable
    public ProcedureCallContext callContext();

    @Nullable
    public TaskRegistryFactory taskRegistryFactory();

    @Nullable
    public UserLogRegistryFactory userLogRegistryFactory();

    public String username();

    @Nullable
    public RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder();

    @Value.Lazy
    default public NamedDatabaseId databaseId() {
        return this.api().databaseId();
    }

    @Value.Lazy
    default public boolean containsOutputField(String fieldName) {
        return this.callContext().outputFields().anyMatch(field -> StringFormatting.toLowerCaseWithLocale((String)field).equals(fieldName));
    }

    @Value.Lazy
    default public boolean isGdsAdmin() {
        if (this.transaction() == null) {
            return false;
        }
        return ((SecurityContextWrapper)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.api(), SecurityContextWrapper.class)).isAdmin(this.transaction().securityContext());
    }
}

