/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Stream;
import org.immutables.value.Value;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallable;
import org.neo4j.gds.executor.ImmutableGdsCallableDefinition;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.reflections.scanners.Scanners;

public final class GdsCallableFinder {
    private static final List<String> PACKAGES_TO_SCAN = List.of("org.neo4j.gds");
    private static final List<String> DEFAULT_PACKAGE_BLACKLIST = List.of("org.neo4j.gds.pregel", "org.neo4j.gds.test");

    public static Stream<GdsCallableDefinition> findAll() {
        return GdsCallableFinder.findAll(DEFAULT_PACKAGE_BLACKLIST);
    }

    public static Stream<GdsCallableDefinition> findAll(Collection<String> blacklist) {
        return GdsCallableFinder.allGdsCallables(blacklist).sorted(Comparator.comparing(GdsCallableDefinition::name, String.CASE_INSENSITIVE_ORDER));
    }

    public static Optional<GdsCallableDefinition> findByName(String name) {
        return GdsCallableFinder.findByName(name, DEFAULT_PACKAGE_BLACKLIST);
    }

    public static Optional<GdsCallableDefinition> findByName(String name, Collection<String> blacklist) {
        String lowerCaseName = name.toLowerCase(Locale.ROOT);
        return GdsCallableFinder.allGdsCallables(blacklist).filter(callable -> callable.name().toLowerCase(Locale.ROOT).equals(lowerCaseName)).findFirst();
    }

    @NotNull
    private static Stream<GdsCallableDefinition> allGdsCallables(Collection<String> blacklist) {
        return PACKAGES_TO_SCAN.stream().map(pkg -> new Reflections(pkg, new Scanner[]{Scanners.TypesAnnotated})).flatMap(reflections -> reflections.getTypesAnnotatedWith(GdsCallable.class).stream()).filter(clazz -> blacklist.stream().noneMatch(item -> clazz.getPackageName().startsWith((String)item))).peek(clazz -> {
            assert (AlgorithmSpec.class.isAssignableFrom((Class<?>)clazz));
        }).map(clazz -> {
            GdsCallable gdsCallable = clazz.getAnnotation(GdsCallable.class);
            return ImmutableGdsCallableDefinition.builder().name(gdsCallable.name()).description(gdsCallable.description()).executionMode(gdsCallable.executionMode()).algorithmSpecClass((Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>>)clazz).build();
        });
    }

    private GdsCallableFinder() {
    }

    @ValueClass
    public static interface GdsCallableDefinition {
        public Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass();

        @Value.Lazy
        default public AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>> algorithmSpec() {
            try {
                return this.algorithmSpecClass().getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }

        public String name();

        public String description();

        public ExecutionMode executionMode();
    }
}

