/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.executor.AlgorithmSpec;
import org.neo4j.gds.executor.ExecutionMode;
import org.neo4j.gds.executor.GdsCallableFinder;

@ParametersAreNonnullByDefault
@Generated(from="GdsCallableFinder.GdsCallableDefinition", generator="Immutables")
@Immutable
public final class ImmutableGdsCallableDefinition
implements GdsCallableFinder.GdsCallableDefinition {
    private final Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass;
    private final String name;
    private final String description;
    private final ExecutionMode executionMode;
    private volatile transient long lazyInitBitmap;
    private static final long ALGORITHM_SPEC_LAZY_INIT_BIT = 1L;
    private transient AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>> algorithmSpec;

    private ImmutableGdsCallableDefinition(Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass, String name, String description, ExecutionMode executionMode) {
        this.algorithmSpecClass = Objects.requireNonNull(algorithmSpecClass, "algorithmSpecClass");
        this.name = Objects.requireNonNull(name, "name");
        this.description = Objects.requireNonNull(description, "description");
        this.executionMode = Objects.requireNonNull(executionMode, "executionMode");
    }

    private ImmutableGdsCallableDefinition(ImmutableGdsCallableDefinition original, Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass, String name, String description, ExecutionMode executionMode) {
        this.algorithmSpecClass = algorithmSpecClass;
        this.name = name;
        this.description = description;
        this.executionMode = executionMode;
    }

    @Override
    public Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass() {
        return this.algorithmSpecClass;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String description() {
        return this.description;
    }

    @Override
    public ExecutionMode executionMode() {
        return this.executionMode;
    }

    public final ImmutableGdsCallableDefinition withAlgorithmSpecClass(Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> value) {
        if (this.algorithmSpecClass == value) {
            return this;
        }
        Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> newValue = Objects.requireNonNull(value, "algorithmSpecClass");
        return new ImmutableGdsCallableDefinition(this, newValue, this.name, this.description, this.executionMode);
    }

    public final ImmutableGdsCallableDefinition withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new ImmutableGdsCallableDefinition(this, this.algorithmSpecClass, newValue, this.description, this.executionMode);
    }

    public final ImmutableGdsCallableDefinition withDescription(String value) {
        String newValue = Objects.requireNonNull(value, "description");
        if (this.description.equals(newValue)) {
            return this;
        }
        return new ImmutableGdsCallableDefinition(this, this.algorithmSpecClass, this.name, newValue, this.executionMode);
    }

    public final ImmutableGdsCallableDefinition withExecutionMode(ExecutionMode value) {
        if (this.executionMode == value) {
            return this;
        }
        ExecutionMode newValue = Objects.requireNonNull(value, "executionMode");
        if (this.executionMode.equals((Object)newValue)) {
            return this;
        }
        return new ImmutableGdsCallableDefinition(this, this.algorithmSpecClass, this.name, this.description, newValue);
    }

    public boolean equals(@Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableGdsCallableDefinition && this.equalTo((ImmutableGdsCallableDefinition)another);
    }

    private boolean equalTo(ImmutableGdsCallableDefinition another) {
        return this.algorithmSpecClass.equals(another.algorithmSpecClass) && this.name.equals(another.name) && this.description.equals(another.description) && this.executionMode.equals((Object)another.executionMode);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.algorithmSpecClass.hashCode();
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description.hashCode();
        h += (h << 5) + this.executionMode.hashCode();
        return h;
    }

    public String toString() {
        return "GdsCallableDefinition{algorithmSpecClass=" + this.algorithmSpecClass + ", name=" + this.name + ", description=" + this.description + ", executionMode=" + this.executionMode + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>> algorithmSpec() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableGdsCallableDefinition immutableGdsCallableDefinition = this;
            synchronized (immutableGdsCallableDefinition) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.algorithmSpec = Objects.requireNonNull(GdsCallableFinder.GdsCallableDefinition.super.algorithmSpec(), "algorithmSpec");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.algorithmSpec;
    }

    public static GdsCallableFinder.GdsCallableDefinition of(Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass, String name, String description, ExecutionMode executionMode) {
        return new ImmutableGdsCallableDefinition(algorithmSpecClass, name, description, executionMode);
    }

    public static GdsCallableFinder.GdsCallableDefinition copyOf(GdsCallableFinder.GdsCallableDefinition instance) {
        if (instance instanceof ImmutableGdsCallableDefinition) {
            return (ImmutableGdsCallableDefinition)instance;
        }
        return ImmutableGdsCallableDefinition.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GdsCallableFinder.GdsCallableDefinition", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_ALGORITHM_SPEC_CLASS = 1L;
        private static final long INIT_BIT_NAME = 2L;
        private static final long INIT_BIT_DESCRIPTION = 4L;
        private static final long INIT_BIT_EXECUTION_MODE = 8L;
        private long initBits = 15L;
        @Nullable
        private Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass;
        @Nullable
        private String name;
        @Nullable
        private String description;
        @Nullable
        private ExecutionMode executionMode;

        private Builder() {
        }

        public final Builder from(GdsCallableFinder.GdsCallableDefinition instance) {
            Objects.requireNonNull(instance, "instance");
            this.algorithmSpecClass(instance.algorithmSpecClass());
            this.name(instance.name());
            this.description(instance.description());
            this.executionMode(instance.executionMode());
            return this;
        }

        public final Builder algorithmSpecClass(Class<AlgorithmSpec<Algorithm<Object>, Object, AlgoBaseConfig, Object, AlgorithmFactory<?, Algorithm<Object>, AlgoBaseConfig>>> algorithmSpecClass) {
            this.algorithmSpecClass = Objects.requireNonNull(algorithmSpecClass, "algorithmSpecClass");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder name(String name) {
            this.name = Objects.requireNonNull(name, "name");
            this.initBits &= 0xFFFFFFFFFFFFFFFDL;
            return this;
        }

        public final Builder description(String description) {
            this.description = Objects.requireNonNull(description, "description");
            this.initBits &= 0xFFFFFFFFFFFFFFFBL;
            return this;
        }

        public final Builder executionMode(ExecutionMode executionMode) {
            this.executionMode = Objects.requireNonNull(executionMode, "executionMode");
            this.initBits &= 0xFFFFFFFFFFFFFFF7L;
            return this;
        }

        public Builder clear() {
            this.initBits = 15L;
            this.algorithmSpecClass = null;
            this.name = null;
            this.description = null;
            this.executionMode = null;
            return this;
        }

        public GdsCallableFinder.GdsCallableDefinition build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableGdsCallableDefinition(null, this.algorithmSpecClass, this.name, this.description, this.executionMode);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("algorithmSpecClass");
            }
            if ((this.initBits & 2L) != 0L) {
                attributes.add("name");
            }
            if ((this.initBits & 4L) != 0L) {
                attributes.add("description");
            }
            if ((this.initBits & 8L) != 0L) {
                attributes.add("executionMode");
            }
            return "Cannot build GdsCallableDefinition, some of required attributes are not set " + attributes;
        }
    }
}

