/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import org.neo4j.gds.Algorithm;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.executor.AlgoConfigParser;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.gds.executor.ExecutorSpec;
import org.neo4j.gds.executor.GraphCreationFactory;
import org.neo4j.gds.executor.GraphStoreFromCatalogLoader;
import org.neo4j.gds.executor.MemoryUsageValidator;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.executor.ProcConfigParser;
import org.neo4j.gds.executor.ProcedureGraphCreationFactory;
import org.neo4j.gds.executor.validation.ValidationConfiguration;
import org.neo4j.gds.executor.validation.Validator;

public class ProcedureExecutorSpec<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig>
implements ExecutorSpec<ALGO, ALGO_RESULT, CONFIG> {
    @Override
    public ProcConfigParser<CONFIG> configParser(NewConfigFunction<CONFIG> newConfigFunction, ExecutionContext executionContext) {
        return new AlgoConfigParser<CONFIG>(executionContext.username(), newConfigFunction);
    }

    @Override
    public Validator<CONFIG> validator(ValidationConfiguration<CONFIG> validationConfiguration) {
        return new Validator<CONFIG>(validationConfiguration);
    }

    @Override
    public GraphCreationFactory<ALGO, ALGO_RESULT, CONFIG> graphCreationFactory(ExecutionContext executionContext) {
        return new ProcedureGraphCreationFactory((config, graphName) -> new GraphStoreFromCatalogLoader((String)graphName, (AlgoBaseConfig)config, executionContext.username(), executionContext.databaseId(), executionContext.isGdsAdmin()), new MemoryUsageValidator(executionContext.log(), executionContext.api()));
    }
}

