/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor.validation;

import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.neo4j.gds.Orientation;
import org.neo4j.gds.RelationshipProjection;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.executor.validation.BeforeLoadValidation;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.gds.utils.StringJoining;

public final class GraphProjectConfigValidations {

    public static class OrientationValidation<CONFIG extends AlgoBaseConfig>
    implements BeforeLoadValidation<CONFIG> {
        @Override
        public void validateConfigsBeforeLoad(GraphProjectConfig graphProjectConfig, CONFIG algorithmConfig) {
            graphProjectConfig.accept((GraphProjectConfig.Cases)new GraphProjectConfig.Visitor((AlgoBaseConfig)algorithmConfig){
                final /* synthetic */ AlgoBaseConfig val$algorithmConfig;
                {
                    this.val$algorithmConfig = algoBaseConfig;
                }

                public void visit(GraphProjectFromStoreConfig storeConfig) {
                    List filteredProjections = storeConfig.relationshipProjections().projections().entrySet().stream().filter(entry -> this.val$algorithmConfig.relationshipTypes().equals(Collections.singletonList("*")) || this.val$algorithmConfig.relationshipTypes().contains(((RelationshipType)entry.getKey()).name())).collect(Collectors.toList());
                    boolean allUndirected = filteredProjections.stream().allMatch(entry -> ((RelationshipProjection)entry.getValue()).orientation() == Orientation.UNDIRECTED);
                    boolean anyUndirected = filteredProjections.stream().anyMatch(entry -> ((RelationshipProjection)entry.getValue()).orientation() == Orientation.UNDIRECTED);
                    if (anyUndirected && !allUndirected) {
                        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Combining UNDIRECTED orientation with NATURAL or REVERSE is not supported. Found projections: %s.", (Object[])new Object[]{StringJoining.join(filteredProjections.stream().map(entry -> StringFormatting.formatWithLocale((String)"%s (%s)", (Object[])new Object[]{((RelationshipType)entry.getKey()).name, ((RelationshipProjection)entry.getValue()).orientation()})).sorted())}));
                    }
                }
            });
        }
    }

    public static class UndirectedGraphValidation<CONFIG extends AlgoBaseConfig>
    implements BeforeLoadValidation<CONFIG> {
        @Override
        public void validateConfigsBeforeLoad(GraphProjectConfig graphProjectConfig, CONFIG config) {
            graphProjectConfig.accept((GraphProjectConfig.Cases)new GraphProjectConfig.Visitor((AlgoBaseConfig)config){
                final /* synthetic */ AlgoBaseConfig val$config;
                {
                    this.val$config = algoBaseConfig;
                }

                public void visit(GraphProjectFromStoreConfig storeConfig) {
                    storeConfig.relationshipProjections().projections().entrySet().stream().filter(entry -> this.val$config.relationshipTypes().equals(Collections.singletonList("*")) || this.val$config.relationshipTypes().contains(((RelationshipType)entry.getKey()).name())).filter(entry -> ((RelationshipProjection)entry.getValue()).orientation() != Orientation.UNDIRECTED).forEach(entry -> {
                        throw new IllegalArgumentException(StringFormatting.formatWithLocale((String)"Procedure requires relationship projections to be UNDIRECTED. Projection for `%s` uses orientation `%s`", (Object[])new Object[]{((RelationshipType)entry.getKey()).name, ((RelationshipProjection)entry.getValue()).orientation()}));
                    });
                }
            });
        }
    }
}

