/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor.validation;

import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.executor.GraphStoreValidation;
import org.neo4j.gds.executor.validation.ValidationConfiguration;

public class Validator<CONFIG extends AlgoBaseConfig> {
    private final ValidationConfiguration<CONFIG> validationConfiguration;

    public Validator(ValidationConfiguration<CONFIG> validationConfiguration) {
        this.validationConfiguration = validationConfiguration;
    }

    public void validateConfigsBeforeLoad(GraphProjectConfig graphProjectConfig, CONFIG config) {
        this.validationConfiguration.beforeLoadValidations().forEach(validation -> validation.validateConfigsBeforeLoad(graphProjectConfig, config));
    }

    public void validateConfigWithGraphStore(GraphStore graphStore, GraphProjectConfig graphProjectConfig, CONFIG config) {
        config.graphStoreValidation(graphStore, config.nodeLabelIdentifiers(graphStore), config.internalRelationshipTypes(graphStore));
        GraphStoreValidation.validate(graphStore, config);
        this.validationConfiguration.afterLoadValidations().forEach(validation -> validation.validateConfigsAfterLoad(graphStore, graphProjectConfig, config));
    }
}

