/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.configuration.DefaultsConfiguration;
import org.neo4j.gds.configuration.LimitViolation;
import org.neo4j.gds.configuration.LimitsConfiguration;
import org.neo4j.gds.core.CypherMapWrapper;
import org.neo4j.gds.executor.NewConfigFunction;
import org.neo4j.gds.executor.ProcConfigParser;

public class AlgoConfigParser<CONFIG extends AlgoBaseConfig>
implements ProcConfigParser<CONFIG> {
    private final NewConfigFunction<CONFIG> newConfigFunction;
    private final String username;
    private final DefaultsConfiguration defaults;
    private final LimitsConfiguration limits;

    public AlgoConfigParser(String username, NewConfigFunction<CONFIG> newConfigFunction, DefaultsConfiguration defaults, LimitsConfiguration limits) {
        this.username = username;
        this.newConfigFunction = newConfigFunction;
        this.defaults = defaults;
        this.limits = limits;
    }

    @Override
    public CONFIG processInput(Map<String, Object> configuration) {
        Map configurationWithDefaultsApplied = this.defaults.apply(configuration, this.username);
        CONFIG algorithmConfiguration = this.produceConfig(configurationWithDefaultsApplied);
        HashSet<String> allowedKeys = new HashSet<String>(algorithmConfiguration.configKeys());
        HashSet<String> irrelevantInputtedKeys = this.getIrrelevantInputtedKeys(configuration, allowedKeys);
        HashMap<String, Object> configurationButWithIrrelevantInputtedKeysRemoved = this.getConfigurationForLimitValidation(configuration, irrelevantInputtedKeys);
        this.validateLimits(configurationButWithIrrelevantInputtedKeysRemoved);
        Set<String> addedKeys = this.findAddedKeys(configurationWithDefaultsApplied, configuration.keySet());
        Set<String> addedButIrrelevantKeys = this.findIrrelevantKeys(addedKeys, allowedKeys);
        HashMap<String, Object> configurationWithDefaultsAppliedButIrrelevantKeysRemoved = this.weedOutIrrelevantKeys(configurationWithDefaultsApplied, addedButIrrelevantKeys);
        this.validateConfig(allowedKeys, configurationWithDefaultsAppliedButIrrelevantKeysRemoved);
        return algorithmConfiguration;
    }

    @NotNull
    private HashSet<String> getIrrelevantInputtedKeys(Map<String, Object> configuration, HashSet<String> allowedKeys) {
        HashSet<String> irrelevantInputtedKeys = new HashSet<String>(configuration.keySet());
        irrelevantInputtedKeys.removeAll(allowedKeys);
        return irrelevantInputtedKeys;
    }

    @NotNull
    private HashMap<String, Object> getConfigurationForLimitValidation(Map<String, Object> configuration, HashSet<String> irrelevantInputtedKeys) {
        HashMap<String, Object> configurationButWithIrrelevantInputtedKeysRemoved = new HashMap<String, Object>(configuration);
        configurationButWithIrrelevantInputtedKeysRemoved.keySet().removeAll(irrelevantInputtedKeys);
        return configurationButWithIrrelevantInputtedKeysRemoved;
    }

    private void validateLimits(HashMap<String, Object> configurationButWithIrrelevantInputtedKeysRemoved) {
        Set violations = this.limits.validate(configurationButWithIrrelevantInputtedKeysRemoved, this.username);
        if (violations.isEmpty()) {
            return;
        }
        LinkedList<String> violationMessages = new LinkedList<String>();
        String delimeter = "\n";
        if (violations.size() > 1) {
            violationMessages.add("Configuration exceeded multiple limits:");
            delimeter = "\n - ";
        }
        violations.stream().map(LimitViolation::getErrorMessage).sorted().forEach(violationMessages::add);
        throw new IllegalArgumentException(String.join((CharSequence)delimeter, violationMessages));
    }

    private CONFIG produceConfig(Map<String, Object> configurationWithDefaultsApplied) {
        CypherMapWrapper cypherMapWrapper = CypherMapWrapper.create(configurationWithDefaultsApplied);
        return this.newConfigFunction.apply(this.username, cypherMapWrapper);
    }

    @NotNull
    private Set<String> findAddedKeys(Map<String, Object> configurationWithDefaultsApplied, Set<String> inputtedKeys) {
        HashSet<String> addedKeys = new HashSet<String>(configurationWithDefaultsApplied.keySet());
        addedKeys.removeAll(inputtedKeys);
        return addedKeys;
    }

    @NotNull
    private Set<String> findIrrelevantKeys(Set<String> addedKeys, Set<String> allowedKeys) {
        HashSet<String> irrelevantKeys = new HashSet<String>(addedKeys);
        irrelevantKeys.removeAll(allowedKeys);
        return irrelevantKeys;
    }

    @NotNull
    private HashMap<String, Object> weedOutIrrelevantKeys(Map<String, Object> configurationWithDefaultsApplied, Set<String> irrelevantKeys) {
        HashMap<String, Object> configurationWithDefaultsAppliedButIrrelevantKeysRemoved = new HashMap<String, Object>(configurationWithDefaultsApplied);
        configurationWithDefaultsAppliedButIrrelevantKeysRemoved.keySet().removeAll(irrelevantKeys);
        return configurationWithDefaultsAppliedButIrrelevantKeysRemoved;
    }

    private void validateConfig(Set<String> allowedKeys, Map<String, Object> configuration) {
        CypherMapWrapper.create(configuration).requireOnlyKeysFrom(allowedKeys);
    }
}

