/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import org.immutables.value.Value;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.annotation.ValueClass;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.progress.EmptyTaskRegistryFactory;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.EmptyUserLogRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.core.write.RelationshipStreamExporterBuilder;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.logging.Log;
import org.neo4j.logging.NullLog;

@ValueClass
public interface ExecutionContext {
    public static final ExecutionContext EMPTY = new ExecutionContext(){

        @Override
        @Nullable
        public GraphDatabaseService databaseService() {
            return null;
        }

        @Override
        @Nullable
        public ModelCatalog modelCatalog() {
            return null;
        }

        @Override
        @Nullable
        public Log log() {
            return NullLog.getInstance();
        }

        @Override
        @Nullable
        public Transaction procedureTransaction() {
            return null;
        }

        @Override
        @Nullable
        public KernelTransaction transaction() {
            return null;
        }

        @Override
        @Nullable
        public ProcedureCallContext callContext() {
            return ProcedureCallContext.EMPTY;
        }

        @Override
        @Nullable
        public TaskRegistryFactory taskRegistryFactory() {
            return EmptyTaskRegistryFactory.INSTANCE;
        }

        @Override
        @Nullable
        public UserLogRegistryFactory userLogRegistryFactory() {
            return EmptyUserLogRegistryFactory.INSTANCE;
        }

        @Override
        @Nullable
        public RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder() {
            return null;
        }

        @Override
        @Nullable
        public RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder() {
            return null;
        }

        @Override
        @Nullable
        public NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder() {
            return null;
        }

        @Override
        public String username() {
            return "";
        }
    };

    @Nullable
    public GraphDatabaseService databaseService();

    @Nullable
    public ModelCatalog modelCatalog();

    @Nullable
    public Log log();

    @Nullable
    public Transaction procedureTransaction();

    @Nullable
    public KernelTransaction transaction();

    @Value.Lazy
    default public InternalTransaction internalTransaction() {
        return this.transaction().internalTransaction();
    }

    @Nullable
    public ProcedureCallContext callContext();

    @Nullable
    public TaskRegistryFactory taskRegistryFactory();

    @Nullable
    public UserLogRegistryFactory userLogRegistryFactory();

    public String username();

    @Nullable
    public RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder();

    @Nullable
    public RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder();

    @Nullable
    public NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder();

    @Value.Lazy
    default public DatabaseId databaseId() {
        return DatabaseId.of((GraphDatabaseService)this.databaseService());
    }

    @Value.Lazy
    default public boolean containsOutputField(String fieldName) {
        return this.callContext().outputFields().anyMatch(field -> field.equals(fieldName));
    }

    @Value.Lazy
    default public boolean isGdsAdmin() {
        if (this.transaction() == null) {
            return false;
        }
        String PREDEFINED_ADMIN_ROLE = "admin";
        return this.transaction().securityContext().roles().contains(PREDEFINED_ADMIN_ROLE);
    }
}

