/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.Collections;
import java.util.Set;
import java.util.function.Predicate;
import org.neo4j.gds.NodeLabel;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.GraphProjectFromStoreConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.executor.GraphStoreCreator;
import org.neo4j.gds.utils.StringFormatting;

public class FictitiousGraphStoreLoader
implements GraphStoreCreator {
    private final GraphProjectConfig graphProjectConfig;

    public FictitiousGraphStoreLoader(GraphProjectConfig graphProjectConfig) {
        this.graphProjectConfig = graphProjectConfig;
    }

    @Override
    public GraphProjectConfig graphProjectConfig() {
        return this.graphProjectConfig;
    }

    @Override
    public GraphDimensions graphDimensions() {
        int labelCount = 0;
        if (this.graphProjectConfig() instanceof GraphProjectFromStoreConfig) {
            GraphProjectFromStoreConfig storeConfig = (GraphProjectFromStoreConfig)this.graphProjectConfig();
            Set nodeLabels = storeConfig.nodeProjections().projections().keySet();
            labelCount = nodeLabels.stream().allMatch(Predicate.isEqual(NodeLabel.ALL_NODES)) ? 0 : nodeLabels.size();
        }
        return ImmutableGraphDimensions.builder().nodeCount(this.graphProjectConfig().nodeCount()).highestPossibleNodeCount(this.graphProjectConfig().nodeCount()).estimationNodeLabelCount(labelCount).relationshipCounts(Collections.singletonMap(RelationshipType.ALL_RELATIONSHIPS, this.graphProjectConfig().relationshipCount())).relCountUpperBound(Math.max(this.graphProjectConfig().relationshipCount(), 0L)).build();
    }

    @Override
    public MemoryEstimation estimateMemoryUsageDuringLoading() {
        return this.graphProjectConfig.graphStoreFactory().getWithDimension(GraphLoaderContext.NULL_CONTEXT, this.graphDimensions()).estimateMemoryUsageDuringLoading();
    }

    @Override
    public MemoryEstimation estimateMemoryUsageAfterLoading() {
        return this.graphProjectConfig.graphStoreFactory().getWithDimension(GraphLoaderContext.NULL_CONTEXT, this.graphDimensions()).estimateMemoryUsageAfterLoading();
    }

    @Override
    public GraphStore graphStore() {
        throw new UnsupportedOperationException(StringFormatting.formatWithLocale((String)"%s does not support creating a graph store", (Object[])new Object[]{this.getClass().getSimpleName()}));
    }
}

