/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.gds.RelationshipType;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphDimensions;
import org.neo4j.gds.core.loading.CatalogRequest;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.loading.GraphStoreWithConfig;
import org.neo4j.gds.core.loading.ImmutableCatalogRequest;
import org.neo4j.gds.executor.GraphStoreLoader;

public final class GraphStoreFromCatalogLoader
implements GraphStoreLoader {
    private final AlgoBaseConfig config;
    private final GraphStore graphStore;
    private final GraphProjectConfig graphProjectConfig;

    public GraphStoreFromCatalogLoader(String graphName, AlgoBaseConfig config, String username, DatabaseId databaseId, boolean isGdsAdmin) {
        this.config = config;
        GraphStoreWithConfig graphStoreWithConfig = GraphStoreFromCatalogLoader.graphStoreFromCatalog(graphName, (BaseConfig)config, username, databaseId, isGdsAdmin);
        this.graphStore = graphStoreWithConfig.graphStore();
        this.graphProjectConfig = graphStoreWithConfig.config();
    }

    @Override
    public GraphProjectConfig graphProjectConfig() {
        return this.graphProjectConfig;
    }

    @Override
    public GraphStore graphStore() {
        return this.graphStore;
    }

    @Override
    public GraphDimensions graphDimensions() {
        GraphStore graphStore = this.graphStore();
        Graph filteredGraph = graphStore.getGraph(this.config.nodeLabelIdentifiers(graphStore), this.config.internalRelationshipTypes(graphStore), Optional.empty());
        long relCount = filteredGraph.relationshipCount();
        HashMap<String, Integer> relationshipTypeTokens = new HashMap<String, Integer>();
        int i = 0;
        for (String key : graphStore.relationshipPropertyKeys()) {
            relationshipTypeTokens.put(key, i++);
        }
        return ImmutableGraphDimensions.builder().nodeCount(filteredGraph.nodeCount()).relationshipCounts(this.filteredGraphRelationshipCounts(this.config, graphStore, filteredGraph)).relCountUpperBound(relCount).relationshipPropertyTokens(relationshipTypeTokens).build();
    }

    public static GraphStoreWithConfig graphStoreFromCatalog(String graphName, BaseConfig config, String username, DatabaseId databaseId, boolean isGdsAdmin) {
        CatalogRequest request = ImmutableCatalogRequest.of((String)databaseId.databaseName(), (String)username, (Optional)config.usernameOverride(), (boolean)isGdsAdmin);
        return GraphStoreCatalog.get((CatalogRequest)request, (String)graphName);
    }

    private Map<RelationshipType, Long> filteredGraphRelationshipCounts(AlgoBaseConfig config, GraphStore graphStore, Graph filteredGraph) {
        long relCount = filteredGraph.relationshipCount();
        return Stream.concat(config.internalRelationshipTypes(graphStore).stream(), Stream.of(RelationshipType.ALL_RELATIONSHIPS)).distinct().collect(Collectors.toMap(Function.identity(), key -> key == RelationshipType.ALL_RELATIONSHIPS ? relCount : filteredGraph.relationshipTypeFilteredGraph(Set.of(key)).relationshipCount()));
    }
}

