/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import org.neo4j.gds.api.GraphLoaderContext;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.api.GraphStoreFactory;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.core.GraphDimensions;
import org.neo4j.gds.core.ImmutableGraphLoader;
import org.neo4j.gds.core.utils.mem.MemoryEstimation;
import org.neo4j.gds.executor.GraphStoreCreator;

public class GraphStoreFromDatabaseLoader
implements GraphStoreCreator {
    private final GraphProjectConfig graphProjectConfig;
    private final String username;
    private final GraphLoaderContext graphLoaderContext;
    private final GraphStoreFactory<?, ?> graphStoreFactory;

    public GraphStoreFromDatabaseLoader(GraphProjectConfig graphProjectConfig, String username, GraphLoaderContext graphLoaderContext) {
        this.graphProjectConfig = graphProjectConfig;
        this.username = username;
        this.graphLoaderContext = graphLoaderContext;
        this.graphStoreFactory = this.graphStoreFactory();
    }

    @Override
    public GraphProjectConfig graphProjectConfig() {
        return this.graphProjectConfig;
    }

    @Override
    public GraphStore graphStore() {
        return this.graphStoreFactory.build();
    }

    @Override
    public GraphDimensions graphDimensions() {
        return this.graphStoreFactory.estimationDimensions();
    }

    @Override
    public MemoryEstimation estimateMemoryUsageDuringLoading() {
        return this.graphStoreFactory.estimateMemoryUsageDuringLoading();
    }

    @Override
    public MemoryEstimation estimateMemoryUsageAfterLoading() {
        return this.graphStoreFactory.estimateMemoryUsageDuringLoading();
    }

    private GraphStoreFactory<?, ?> graphStoreFactory() {
        return ImmutableGraphLoader.builder().context(this.graphLoaderContext).username(this.username).projectConfig(this.graphProjectConfig).build().graphStoreFactory();
    }
}

