/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.ArrayList;
import java.util.Objects;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;
import javax.annotation.concurrent.NotThreadSafe;
import org.immutables.value.Generated;
import org.jetbrains.annotations.Nullable;
import org.neo4j.gds.api.DatabaseId;
import org.neo4j.gds.core.model.ModelCatalog;
import org.neo4j.gds.core.utils.progress.TaskRegistryFactory;
import org.neo4j.gds.core.utils.warnings.UserLogRegistryFactory;
import org.neo4j.gds.core.write.NodePropertyExporter;
import org.neo4j.gds.core.write.NodePropertyExporterBuilder;
import org.neo4j.gds.core.write.RelationshipExporter;
import org.neo4j.gds.core.write.RelationshipExporterBuilder;
import org.neo4j.gds.core.write.RelationshipStreamExporter;
import org.neo4j.gds.core.write.RelationshipStreamExporterBuilder;
import org.neo4j.gds.executor.ExecutionContext;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Transaction;
import org.neo4j.internal.kernel.api.procs.ProcedureCallContext;
import org.neo4j.kernel.api.KernelTransaction;
import org.neo4j.kernel.impl.coreapi.InternalTransaction;
import org.neo4j.logging.Log;

@ParametersAreNonnullByDefault
@Generated(from="ExecutionContext", generator="Immutables")
@Immutable
public final class ImmutableExecutionContext
implements ExecutionContext {
    @Nullable
    private final GraphDatabaseService databaseService;
    @Nullable
    private final ModelCatalog modelCatalog;
    @Nullable
    private final Log log;
    @Nullable
    private final Transaction procedureTransaction;
    @Nullable
    private final KernelTransaction transaction;
    @Nullable
    private final ProcedureCallContext callContext;
    @Nullable
    private final TaskRegistryFactory taskRegistryFactory;
    @Nullable
    private final UserLogRegistryFactory userLogRegistryFactory;
    private final String username;
    @Nullable
    private final RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder;
    @Nullable
    private final RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder;
    @Nullable
    private final NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder;
    private volatile transient long lazyInitBitmap;
    private static final long INTERNAL_TRANSACTION_LAZY_INIT_BIT = 1L;
    private transient InternalTransaction internalTransaction;
    private static final long DATABASE_ID_LAZY_INIT_BIT = 2L;
    private transient DatabaseId databaseId;
    private static final long IS_GDS_ADMIN_LAZY_INIT_BIT = 4L;
    private transient boolean isGdsAdmin;

    private ImmutableExecutionContext(@Nullable GraphDatabaseService databaseService, @Nullable ModelCatalog modelCatalog, @Nullable Log log, @Nullable Transaction procedureTransaction, @Nullable KernelTransaction transaction, @Nullable ProcedureCallContext callContext, @Nullable TaskRegistryFactory taskRegistryFactory, @Nullable UserLogRegistryFactory userLogRegistryFactory, String username, @Nullable RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder, @Nullable RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder, @Nullable NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder) {
        this.databaseService = databaseService;
        this.modelCatalog = modelCatalog;
        this.log = log;
        this.procedureTransaction = procedureTransaction;
        this.transaction = transaction;
        this.callContext = callContext;
        this.taskRegistryFactory = taskRegistryFactory;
        this.userLogRegistryFactory = userLogRegistryFactory;
        this.username = Objects.requireNonNull(username, "username");
        this.relationshipStreamExporterBuilder = relationshipStreamExporterBuilder;
        this.relationshipExporterBuilder = relationshipExporterBuilder;
        this.nodePropertyExporterBuilder = nodePropertyExporterBuilder;
    }

    private ImmutableExecutionContext(ImmutableExecutionContext original, @Nullable GraphDatabaseService databaseService, @Nullable ModelCatalog modelCatalog, @Nullable Log log, @Nullable Transaction procedureTransaction, @Nullable KernelTransaction transaction, @Nullable ProcedureCallContext callContext, @Nullable TaskRegistryFactory taskRegistryFactory, @Nullable UserLogRegistryFactory userLogRegistryFactory, String username, @Nullable RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder, @Nullable RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder, @Nullable NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder) {
        this.databaseService = databaseService;
        this.modelCatalog = modelCatalog;
        this.log = log;
        this.procedureTransaction = procedureTransaction;
        this.transaction = transaction;
        this.callContext = callContext;
        this.taskRegistryFactory = taskRegistryFactory;
        this.userLogRegistryFactory = userLogRegistryFactory;
        this.username = username;
        this.relationshipStreamExporterBuilder = relationshipStreamExporterBuilder;
        this.relationshipExporterBuilder = relationshipExporterBuilder;
        this.nodePropertyExporterBuilder = nodePropertyExporterBuilder;
    }

    @Override
    @Nullable
    public GraphDatabaseService databaseService() {
        return this.databaseService;
    }

    @Override
    @Nullable
    public ModelCatalog modelCatalog() {
        return this.modelCatalog;
    }

    @Override
    @Nullable
    public Log log() {
        return this.log;
    }

    @Override
    @Nullable
    public Transaction procedureTransaction() {
        return this.procedureTransaction;
    }

    @Override
    @Nullable
    public KernelTransaction transaction() {
        return this.transaction;
    }

    @Override
    @Nullable
    public ProcedureCallContext callContext() {
        return this.callContext;
    }

    @Override
    @Nullable
    public TaskRegistryFactory taskRegistryFactory() {
        return this.taskRegistryFactory;
    }

    @Override
    @Nullable
    public UserLogRegistryFactory userLogRegistryFactory() {
        return this.userLogRegistryFactory;
    }

    @Override
    public String username() {
        return this.username;
    }

    @Override
    @Nullable
    public RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder() {
        return this.relationshipStreamExporterBuilder;
    }

    @Override
    @Nullable
    public RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder() {
        return this.relationshipExporterBuilder;
    }

    @Override
    @Nullable
    public NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder() {
        return this.nodePropertyExporterBuilder;
    }

    public final ImmutableExecutionContext withDatabaseService(@Nullable GraphDatabaseService value) {
        if (this.databaseService == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, value, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withModelCatalog(@Nullable ModelCatalog value) {
        if (this.modelCatalog == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, value, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withLog(@Nullable Log value) {
        if (this.log == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, value, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withProcedureTransaction(@Nullable Transaction value) {
        if (this.procedureTransaction == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, value, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withTransaction(@Nullable KernelTransaction value) {
        if (this.transaction == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, value, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withCallContext(@Nullable ProcedureCallContext value) {
        if (this.callContext == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, value, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withTaskRegistryFactory(@Nullable TaskRegistryFactory value) {
        if (this.taskRegistryFactory == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, value, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withUserLogRegistryFactory(@Nullable UserLogRegistryFactory value) {
        if (this.userLogRegistryFactory == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, value, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withUsername(String value) {
        String newValue = Objects.requireNonNull(value, "username");
        if (this.username.equals(newValue)) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, newValue, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withRelationshipStreamExporterBuilder(@Nullable RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> value) {
        if (this.relationshipStreamExporterBuilder == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, value, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withRelationshipExporterBuilder(@Nullable RelationshipExporterBuilder<? extends RelationshipExporter> value) {
        if (this.relationshipExporterBuilder == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, value, this.nodePropertyExporterBuilder);
    }

    public final ImmutableExecutionContext withNodePropertyExporterBuilder(@Nullable NodePropertyExporterBuilder<? extends NodePropertyExporter> value) {
        if (this.nodePropertyExporterBuilder == value) {
            return this;
        }
        return new ImmutableExecutionContext(this, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, value);
    }

    public boolean equals(@javax.annotation.Nullable Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof ImmutableExecutionContext && this.equalTo((ImmutableExecutionContext)another);
    }

    private boolean equalTo(ImmutableExecutionContext another) {
        return Objects.equals(this.databaseService, another.databaseService) && Objects.equals(this.modelCatalog, another.modelCatalog) && Objects.equals(this.log, another.log) && Objects.equals(this.procedureTransaction, another.procedureTransaction) && Objects.equals(this.transaction, another.transaction) && Objects.equals(this.callContext, another.callContext) && Objects.equals(this.taskRegistryFactory, another.taskRegistryFactory) && Objects.equals(this.userLogRegistryFactory, another.userLogRegistryFactory) && this.username.equals(another.username) && Objects.equals(this.relationshipStreamExporterBuilder, another.relationshipStreamExporterBuilder) && Objects.equals(this.relationshipExporterBuilder, another.relationshipExporterBuilder) && Objects.equals(this.nodePropertyExporterBuilder, another.nodePropertyExporterBuilder);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.databaseService);
        h += (h << 5) + Objects.hashCode(this.modelCatalog);
        h += (h << 5) + Objects.hashCode(this.log);
        h += (h << 5) + Objects.hashCode(this.procedureTransaction);
        h += (h << 5) + Objects.hashCode(this.transaction);
        h += (h << 5) + Objects.hashCode(this.callContext);
        h += (h << 5) + Objects.hashCode(this.taskRegistryFactory);
        h += (h << 5) + Objects.hashCode(this.userLogRegistryFactory);
        h += (h << 5) + this.username.hashCode();
        h += (h << 5) + Objects.hashCode(this.relationshipStreamExporterBuilder);
        h += (h << 5) + Objects.hashCode(this.relationshipExporterBuilder);
        h += (h << 5) + Objects.hashCode(this.nodePropertyExporterBuilder);
        return h;
    }

    public String toString() {
        return "ExecutionContext{databaseService=" + this.databaseService + ", modelCatalog=" + this.modelCatalog + ", log=" + this.log + ", procedureTransaction=" + this.procedureTransaction + ", transaction=" + this.transaction + ", callContext=" + this.callContext + ", taskRegistryFactory=" + this.taskRegistryFactory + ", userLogRegistryFactory=" + this.userLogRegistryFactory + ", username=" + this.username + ", relationshipStreamExporterBuilder=" + this.relationshipStreamExporterBuilder + ", relationshipExporterBuilder=" + this.relationshipExporterBuilder + ", nodePropertyExporterBuilder=" + this.nodePropertyExporterBuilder + "}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InternalTransaction internalTransaction() {
        if ((this.lazyInitBitmap & 1L) == 0L) {
            ImmutableExecutionContext immutableExecutionContext = this;
            synchronized (immutableExecutionContext) {
                if ((this.lazyInitBitmap & 1L) == 0L) {
                    this.internalTransaction = Objects.requireNonNull(ExecutionContext.super.internalTransaction(), "internalTransaction");
                    this.lazyInitBitmap |= 1L;
                }
            }
        }
        return this.internalTransaction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public DatabaseId databaseId() {
        if ((this.lazyInitBitmap & 2L) == 0L) {
            ImmutableExecutionContext immutableExecutionContext = this;
            synchronized (immutableExecutionContext) {
                if ((this.lazyInitBitmap & 2L) == 0L) {
                    this.databaseId = Objects.requireNonNull(ExecutionContext.super.databaseId(), "databaseId");
                    this.lazyInitBitmap |= 2L;
                }
            }
        }
        return this.databaseId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isGdsAdmin() {
        if ((this.lazyInitBitmap & 4L) == 0L) {
            ImmutableExecutionContext immutableExecutionContext = this;
            synchronized (immutableExecutionContext) {
                if ((this.lazyInitBitmap & 4L) == 0L) {
                    this.isGdsAdmin = ExecutionContext.super.isGdsAdmin();
                    this.lazyInitBitmap |= 4L;
                }
            }
        }
        return this.isGdsAdmin;
    }

    public static ExecutionContext of(@Nullable GraphDatabaseService databaseService, @Nullable ModelCatalog modelCatalog, @Nullable Log log, @Nullable Transaction procedureTransaction, @Nullable KernelTransaction transaction, @Nullable ProcedureCallContext callContext, @Nullable TaskRegistryFactory taskRegistryFactory, @Nullable UserLogRegistryFactory userLogRegistryFactory, String username, @Nullable RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder, @Nullable RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder, @Nullable NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder) {
        return new ImmutableExecutionContext(databaseService, modelCatalog, log, procedureTransaction, transaction, callContext, taskRegistryFactory, userLogRegistryFactory, username, relationshipStreamExporterBuilder, relationshipExporterBuilder, nodePropertyExporterBuilder);
    }

    public static ExecutionContext copyOf(ExecutionContext instance) {
        if (instance instanceof ImmutableExecutionContext) {
            return (ImmutableExecutionContext)instance;
        }
        return ImmutableExecutionContext.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="ExecutionContext", generator="Immutables")
    @NotThreadSafe
    public static final class Builder {
        private static final long INIT_BIT_USERNAME = 1L;
        private long initBits = 1L;
        @javax.annotation.Nullable
        private GraphDatabaseService databaseService;
        @javax.annotation.Nullable
        private ModelCatalog modelCatalog;
        @javax.annotation.Nullable
        private Log log;
        @javax.annotation.Nullable
        private Transaction procedureTransaction;
        @javax.annotation.Nullable
        private KernelTransaction transaction;
        @javax.annotation.Nullable
        private ProcedureCallContext callContext;
        @javax.annotation.Nullable
        private TaskRegistryFactory taskRegistryFactory;
        @javax.annotation.Nullable
        private UserLogRegistryFactory userLogRegistryFactory;
        @javax.annotation.Nullable
        private String username;
        @javax.annotation.Nullable
        private RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder;
        @javax.annotation.Nullable
        private RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder;
        @javax.annotation.Nullable
        private NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder;

        private Builder() {
        }

        public final Builder from(ExecutionContext instance) {
            NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilderValue;
            RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilderValue;
            UserLogRegistryFactory userLogRegistryFactoryValue;
            TaskRegistryFactory taskRegistryFactoryValue;
            ProcedureCallContext callContextValue;
            KernelTransaction transactionValue;
            Transaction procedureTransactionValue;
            Log logValue;
            ModelCatalog modelCatalogValue;
            Objects.requireNonNull(instance, "instance");
            @Nullable GraphDatabaseService databaseServiceValue = instance.databaseService();
            if (databaseServiceValue != null) {
                this.databaseService(databaseServiceValue);
            }
            if ((modelCatalogValue = instance.modelCatalog()) != null) {
                this.modelCatalog(modelCatalogValue);
            }
            if ((logValue = instance.log()) != null) {
                this.log(logValue);
            }
            if ((procedureTransactionValue = instance.procedureTransaction()) != null) {
                this.procedureTransaction(procedureTransactionValue);
            }
            if ((transactionValue = instance.transaction()) != null) {
                this.transaction(transactionValue);
            }
            if ((callContextValue = instance.callContext()) != null) {
                this.callContext(callContextValue);
            }
            if ((taskRegistryFactoryValue = instance.taskRegistryFactory()) != null) {
                this.taskRegistryFactory(taskRegistryFactoryValue);
            }
            if ((userLogRegistryFactoryValue = instance.userLogRegistryFactory()) != null) {
                this.userLogRegistryFactory(userLogRegistryFactoryValue);
            }
            this.username(instance.username());
            @Nullable RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilderValue = instance.relationshipStreamExporterBuilder();
            if (relationshipStreamExporterBuilderValue != null) {
                this.relationshipStreamExporterBuilder(relationshipStreamExporterBuilderValue);
            }
            if ((relationshipExporterBuilderValue = instance.relationshipExporterBuilder()) != null) {
                this.relationshipExporterBuilder(relationshipExporterBuilderValue);
            }
            if ((nodePropertyExporterBuilderValue = instance.nodePropertyExporterBuilder()) != null) {
                this.nodePropertyExporterBuilder(nodePropertyExporterBuilderValue);
            }
            return this;
        }

        public final Builder databaseService(@Nullable GraphDatabaseService databaseService) {
            this.databaseService = databaseService;
            return this;
        }

        public final Builder modelCatalog(@Nullable ModelCatalog modelCatalog) {
            this.modelCatalog = modelCatalog;
            return this;
        }

        public final Builder log(@Nullable Log log) {
            this.log = log;
            return this;
        }

        public final Builder procedureTransaction(@Nullable Transaction procedureTransaction) {
            this.procedureTransaction = procedureTransaction;
            return this;
        }

        public final Builder transaction(@Nullable KernelTransaction transaction) {
            this.transaction = transaction;
            return this;
        }

        public final Builder callContext(@Nullable ProcedureCallContext callContext) {
            this.callContext = callContext;
            return this;
        }

        public final Builder taskRegistryFactory(@Nullable TaskRegistryFactory taskRegistryFactory) {
            this.taskRegistryFactory = taskRegistryFactory;
            return this;
        }

        public final Builder userLogRegistryFactory(@Nullable UserLogRegistryFactory userLogRegistryFactory) {
            this.userLogRegistryFactory = userLogRegistryFactory;
            return this;
        }

        public final Builder username(String username) {
            this.username = Objects.requireNonNull(username, "username");
            this.initBits &= 0xFFFFFFFFFFFFFFFEL;
            return this;
        }

        public final Builder relationshipStreamExporterBuilder(@Nullable RelationshipStreamExporterBuilder<? extends RelationshipStreamExporter> relationshipStreamExporterBuilder) {
            this.relationshipStreamExporterBuilder = relationshipStreamExporterBuilder;
            return this;
        }

        public final Builder relationshipExporterBuilder(@Nullable RelationshipExporterBuilder<? extends RelationshipExporter> relationshipExporterBuilder) {
            this.relationshipExporterBuilder = relationshipExporterBuilder;
            return this;
        }

        public final Builder nodePropertyExporterBuilder(@Nullable NodePropertyExporterBuilder<? extends NodePropertyExporter> nodePropertyExporterBuilder) {
            this.nodePropertyExporterBuilder = nodePropertyExporterBuilder;
            return this;
        }

        public Builder clear() {
            this.initBits = 1L;
            this.databaseService = null;
            this.modelCatalog = null;
            this.log = null;
            this.procedureTransaction = null;
            this.transaction = null;
            this.callContext = null;
            this.taskRegistryFactory = null;
            this.userLogRegistryFactory = null;
            this.username = null;
            this.relationshipStreamExporterBuilder = null;
            this.relationshipExporterBuilder = null;
            this.nodePropertyExporterBuilder = null;
            return this;
        }

        public ExecutionContext build() {
            if (this.initBits != 0L) {
                throw new IllegalStateException(this.formatRequiredAttributesMessage());
            }
            return new ImmutableExecutionContext(null, this.databaseService, this.modelCatalog, this.log, this.procedureTransaction, this.transaction, this.callContext, this.taskRegistryFactory, this.userLogRegistryFactory, this.username, this.relationshipStreamExporterBuilder, this.relationshipExporterBuilder, this.nodePropertyExporterBuilder);
        }

        private String formatRequiredAttributesMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if ((this.initBits & 1L) != 0L) {
                attributes.add("username");
            }
            return "Cannot build ExecutionContext, some of required attributes are not set " + attributes;
        }
    }
}

