/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.StringJoiner;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.gds.compat.GraphDatabaseApiProxy;
import org.neo4j.gds.config.BaseConfig;
import org.neo4j.gds.core.loading.GraphStoreCatalog;
import org.neo4j.gds.core.utils.mem.GcListenerExtension;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.core.utils.mem.MemoryTreeWithDimensions;
import org.neo4j.gds.exceptions.MemoryEstimationNotImplementedException;
import org.neo4j.gds.internal.MemoryEstimationSettings;
import org.neo4j.gds.mem.MemoryUsage;
import org.neo4j.gds.utils.StringFormatting;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.logging.Log;

public class MemoryUsageValidator {
    private final Log log;
    private final GraphDatabaseService api;

    public MemoryUsageValidator(Log log, GraphDatabaseService api) {
        this.log = log;
        this.api = api;
    }

    public <C extends BaseConfig> MemoryRange tryValidateMemoryUsage(C config, Function<C, MemoryTreeWithDimensions> runEstimation) {
        return this.tryValidateMemoryUsage(config, runEstimation, GcListenerExtension::freeMemory);
    }

    public <C extends BaseConfig> MemoryRange tryValidateMemoryUsage(C config, Function<C, MemoryTreeWithDimensions> runEstimation, FreeMemoryInspector inspector) {
        MemoryTreeWithDimensions memoryTreeWithDimensions = null;
        try {
            memoryTreeWithDimensions = runEstimation.apply(config);
        }
        catch (MemoryEstimationNotImplementedException memoryEstimationNotImplementedException) {
            // empty catch block
        }
        if (memoryTreeWithDimensions == null) {
            return MemoryRange.empty();
        }
        if (config.sudo()) {
            this.log.debug("Sudo mode: Won't check for available memory.");
        } else {
            Config neo4jConfig = (Config)GraphDatabaseApiProxy.resolveDependency((GraphDatabaseService)this.api, Config.class);
            Boolean useMaxMemoryEstimation = (Boolean)neo4jConfig.get(MemoryEstimationSettings.validate_using_max_memory_estimation);
            MemoryUsageValidator.validateMemoryUsage(memoryTreeWithDimensions, inspector.freeMemory(), useMaxMemoryEstimation, this.log);
        }
        return memoryTreeWithDimensions.memoryTree.memoryUsage();
    }

    static void validateMemoryUsage(MemoryTreeWithDimensions memoryTreeWithDimensions, long availableBytes, boolean useMaxMemoryEstimation, Log log) {
        if (useMaxMemoryEstimation) {
            MemoryUsageValidator.validateMemoryUsage(availableBytes, memoryTreeWithDimensions.memoryTree.memoryUsage().max, "maximum", log, "Consider resizing your Aura instance via console.neo4j.io.", "Alternatively, use 'sudo: true' to override the memory validation.", "Overriding the validation is at your own risk.", "The database can run out of memory and data can be lost.");
        } else {
            MemoryUsageValidator.validateMemoryUsage(availableBytes, memoryTreeWithDimensions.memoryTree.memoryUsage().min, "minimum", log, new String[0]);
        }
    }

    private static void validateMemoryUsage(long availableBytes, long requiredBytes, String memoryString, Log log, String ... messages) {
        if (requiredBytes > availableBytes) {
            StringJoiner errorMessage = new StringJoiner(" ", "", "");
            errorMessage.add(StringFormatting.formatWithLocale((String)"Procedure was blocked since %s estimated memory (%s) exceeds current free memory (%s).", (Object[])new Object[]{memoryString, MemoryUsage.humanReadable((long)requiredBytes), MemoryUsage.humanReadable((long)availableBytes)}));
            if (!GraphStoreCatalog.isEmpty()) {
                errorMessage.add(StringFormatting.formatWithLocale((String)"Note: there are %s graphs currently loaded into memory.", (Object[])new Object[]{GraphStoreCatalog.graphStoreCount()}));
            }
            for (String message : messages) {
                errorMessage.add(message);
            }
            String message = errorMessage.toString();
            log.info(message);
            throw new IllegalStateException(message);
        }
    }

    @FunctionalInterface
    public static interface FreeMemoryInspector {
        public long freeMemory();
    }
}

