/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.gds.executor;

import java.util.Collection;
import java.util.Optional;
import org.neo4j.gds.Algorithm;
import org.neo4j.gds.AlgorithmFactory;
import org.neo4j.gds.api.Graph;
import org.neo4j.gds.api.GraphStore;
import org.neo4j.gds.config.AlgoBaseConfig;
import org.neo4j.gds.config.GraphProjectConfig;
import org.neo4j.gds.config.RelationshipWeightConfig;
import org.neo4j.gds.core.utils.mem.MemoryRange;
import org.neo4j.gds.executor.GraphCreation;
import org.neo4j.gds.executor.GraphStoreLoader;
import org.neo4j.gds.executor.MemoryUsageValidator;
import org.neo4j.gds.executor.ProcedureMemoryEstimation;

public class ProcedureGraphCreation<ALGO extends Algorithm<ALGO_RESULT>, ALGO_RESULT, CONFIG extends AlgoBaseConfig>
implements GraphCreation<ALGO, ALGO_RESULT, CONFIG> {
    private final GraphStoreLoader graphStoreLoader;
    private final MemoryUsageValidator memoryUsageValidator;
    private final CONFIG config;

    ProcedureGraphCreation(GraphStoreLoader graphStoreLoader, MemoryUsageValidator memoryUsageValidator, CONFIG config) {
        this.graphStoreLoader = graphStoreLoader;
        this.memoryUsageValidator = memoryUsageValidator;
        this.config = config;
    }

    @Override
    public GraphStore graphStore() {
        return this.graphStoreLoader.graphStore();
    }

    @Override
    public Graph createGraph(GraphStore graphStore) {
        Optional weightProperty = this.config instanceof RelationshipWeightConfig ? ((RelationshipWeightConfig)this.config).relationshipWeightProperty() : Optional.empty();
        Collection nodeLabels = this.config.nodeLabelIdentifiers(graphStore);
        Collection relationshipTypes = this.config.internalRelationshipTypes(graphStore);
        return graphStore.getGraph(nodeLabels, relationshipTypes, weightProperty);
    }

    @Override
    public GraphProjectConfig graphProjectConfig() {
        return this.graphStoreLoader.graphProjectConfig();
    }

    @Override
    public MemoryRange validateMemoryEstimation(AlgorithmFactory<?, ALGO, CONFIG> algorithmFactory) {
        ProcedureMemoryEstimation<ALGO, CONFIG> procedureMemoryEstimation = new ProcedureMemoryEstimation<ALGO, CONFIG>(this.graphStoreLoader.graphDimensions(), algorithmFactory);
        return this.memoryUsageValidator.tryValidateMemoryUsage(this.config, procedureMemoryEstimation::memoryEstimation);
    }
}

